/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;

public class MUU_DSBatchSrv
extends MUU_Object {
    public static final String m_strProductCode = "DSBATCHSRV";
    public static final String m_strPublicName = "Data Step Batch Server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><Properties/><UsedByComponents/><UsingPrototype/></ServerComponent><LogicalServer><Properties/><UsedByComponents/><UsingPrototype/></LogicalServer><Property><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8'\"/>";
    private static final String CONFIG_FILE_NAME = "sasbatch";

    MUU_DSBatchSrv() {
    }

    void SubstituteValues(ServerComponent cmSrv) throws MUUException {
        String strTempDir = MUU_Object.getProperty("tempdir");
        File dirTemp = new File(strTempDir);
        if (dirTemp.exists()) {
            String[] arrServers = dirTemp.list();
            for (int iSrv = 0; iSrv < arrServers.length; ++iSrv) {
                String strFileName = arrServers[iSrv];
                if (!strFileName.startsWith(m_strProductCode.toLowerCase()) || !strFileName.endsWith("_Configuration.properties")) continue;
                Properties propServer = new Properties();
                try {
                    String strFileSep = System.getProperty("file.separator");
                    strFileName = strTempDir + strFileSep + strFileName;
                    propServer.load(new FileInputStream(strFileName));
                    String strSrvName = propServer.getProperty("server.dsbatchsrv.name");
                    String strSrvDirName = propServer.getProperty("server.dsbatchsrv.config.dir.name");
                    if (!strSrvName.equalsIgnoreCase(cmSrv.getName())) continue;
                    String strSrvDir = propServer.getProperty("config.lev.appservercontext.dir");
                    strSrvDir = strSrvDir + strFileSep;
                    strSrvDir = strSrvDir + strSrvDirName;
                    String executableFile = null;
                    File scriptDirectory = new File(strSrvDir);
                    if (scriptDirectory.exists() && scriptDirectory.isDirectory()) {
                        executableFile = MetaDataHelper.getConfigFileName(scriptDirectory.getAbsolutePath(), CONFIG_FILE_NAME);
                    }
                    String strCommandLine = executableFile;
                    String strLogDir = strSrvDir + strFileSep + "Logs";
                    AssociationList lstProps = cmSrv.getProperties();
                    for (int iProp = 0; iProp < lstProps.size(); ++iProp) {
                        Property objProp = (Property)lstProps.get(iProp);
                        if ("CmdLine".equalsIgnoreCase(objProp.getPropertyName())) {
                            objProp.setDefaultValue(strCommandLine);
                            objProp.updateMetadataAll();
                        } else if ("LogDir".equalsIgnoreCase(objProp.getPropertyName())) {
                            objProp.setDefaultValue(strLogDir);
                            objProp.updateMetadataAll();
                        }
                        if (iProp < lstProps.size()) continue;
                        MUU_Client.m_logger.error(MessageBundle.getString("MUU_DSBatchSrv.prop.nt.found.log"));
                    }
                    break;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (RemoteException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (MdException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
            }
        } else {
            MUU_Client.m_logger.error(MessageBundle.getString("MUU_DSBatchSrv.tmpdir.nt.found.log"));
        }
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            this.doLocationChange();
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.SubstituteValues(cmSrv);
            cmSrv.updateMetadataAll();
            this.m_store.updatedMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    @Override
    protected String getHostPropertyName() {
        return "dsbatchsrv.host";
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return true;
    }
}

