/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.util.Names;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class MUU_ConnectSrv
extends MUU_Object {
    public static final String m_strProductCode = "CONNECTSRV";
    public static final String m_strPublicName = "Connect Server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><Properties/><UsedByComponents/><UsingPrototype/></ServerComponent><LogicalServer><Properties/><UsedByComponents/><UsingPrototype/></LogicalServer><Property><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='SAS/CONNECT'\"/>";
    public static final String m_strXMLSelect2 = "<XMLSelect search=\"ServerContext[UsingComponents/LogicalServer[@ClassIdentifier='028e4060-d545-11d5-880d-aa0004006d06']]\"/>";
    public static final String m_strXMLSelect_Spawner = "<XMLSelect Search=\"@ProductName='SAS/CONNECT Spawner'\"/>";
    private static final String m_ServerName = "server.connectsrv.name";
    private static final String m_pattern = "SAS/CONNECT";
    private ServerComponent cmSrv = null;
    private String m_host = "";
    private String m_oldHost = "";
    private String m_spawnerName = "";
    private ServerComponent configurableObject = null;
    private String m_changedHost = "";

    @Override
    public boolean UpgradeObjects(String strReposId) throws MUUException {
        try {
            this.m_reposID = strReposId;
            MUU_Client.m_logger.info("reposID:" + this.m_reposID);
            this.updateSoftwareVersion(MUU_Client.m_strSoftwareVersion, MUU_Client.m_strMajor, MUU_Client.m_strMinor);
            this.cmSrv = (ServerComponent)this.m_objMetadata;
            this.configurableObject = MetaDataHelper.getConfigurableObject(this.cmSrv);
            this.m_changedHost = this.getChangedHostName(this.configurableObject);
            this.doLocationChange();
            this.SubstituteValues(this.cmSrv);
            this.cmSrv.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return false;
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    public void updateServers() {
        try {
            List serverList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, this.m_reposID, m_strMetadataType, 128, m_strXMLSelect);
            for (int i = 0; i < serverList.size(); ++i) {
                ServerComponent s = (ServerComponent)serverList.get(i);
                LogicalServer ls = (LogicalServer)s.getUsedByComponents().get(0);
                if (s.getSourceConnections() != null && s.getSourceConnections().size() > 0) {
                    SASClientConnection connection = (SASClientConnection)s.getSourceConnections().get(0);
                    connection.setName(this.setString(connection.getName(), m_pattern, "Connect"));
                    if (connection.getRemoteAddress().equalsIgnoreCase(this.m_oldHost)) {
                        Machine machine = this.getMachine(this.m_host);
                        if (machine != null) {
                            s.setAssociatedMachine(machine);
                        }
                        connection.setRemoteAddress(this.m_host);
                        connection.updateMetadataAll();
                    }
                }
                ls.setName(this.setString(ls.getName(), m_pattern, "Connect"));
                ls.updateMetadataAll();
                s.setName(this.setString(s.getName(), m_pattern, "Connect"));
                s.updateMetadataAll();
            }
            List serverContextList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, this.m_reposID, "ServerContext", 128, m_strXMLSelect2);
            for (int i = 0; i < serverContextList.size(); ++i) {
                ServerContext sc = (ServerContext)serverContextList.get(i);
                sc.setName(this.setString(sc.getName(), m_pattern, "Connect"));
                sc.updateMetadataAll();
            }
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void SubstituteValues(ServerComponent cmSrv) throws MUUException {
        String strTempDir = MUU_Object.getProperty("tempdir");
        String productCode = MUU_Object.getProperty("productcode");
        SMUProperties smuProperties = SMUProperties.getSMUProperties(productCode, strTempDir);
        File dirTemp = new File(strTempDir);
        String strFileSep = System.getProperty("file.separator");
        String newSasCmd = "";
        String commandName = "";
        if (dirTemp.exists()) {
            String[] arrServers0 = dirTemp.list();
            for (int iSrv = 0; iSrv < arrServers0.length; ++iSrv) {
                String strFileName = arrServers0[iSrv];
                if (!strFileName.toLowerCase().startsWith("connectsrv.configuration")) continue;
                Properties propServer = new Properties();
                String configFileName = strTempDir + strFileSep + strFileName;
                try {
                    propServer.load(new FileInputStream(configFileName));
                    commandName = propServer.getProperty("server.connectsrv.script.name");
                    this.m_host = propServer.getProperty("os.localhost.fqdn.host.name");
                    this.m_oldHost = propServer.getProperty(m_ServerName);
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
            }
            this.updateServers();
            String[] arrServers = dirTemp.list();
            for (int iSrv = 0; iSrv < arrServers.length; ++iSrv) {
                String strFileName = arrServers[iSrv];
                if (!strFileName.startsWith(m_strProductCode.toLowerCase()) || !strFileName.endsWith("_Configuration.properties")) continue;
                MUU_Client.m_logger.info("Expect configuration file:" + strFileName);
                Properties propServer = new Properties();
                String strSrvDir = "";
                try {
                    SASClientConnection connection;
                    ServerComponent spawner;
                    strFileName = strTempDir + strFileSep + strFileName;
                    propServer.load(new FileInputStream(strFileName));
                    String oldSrvName = propServer.getProperty(m_ServerName);
                    String strSrvName = this.setString(oldSrvName, m_pattern, "Connect");
                    this.m_spawnerName = propServer.getProperty("spawner.connectsrv.servercomponent.name");
                    MUU_Client.m_logger.info("SpawnerName: " + this.m_spawnerName);
                    if (strSrvName.equalsIgnoreCase(cmSrv.getName())) {
                        boolean noCommand = true;
                        MUU_Client.m_logger.info("update Server:" + strSrvName);
                        cmSrv.setName(strSrvName);
                        cmSrv.updateMetadataAll();
                        strSrvDir = strSrvDir + propServer.getProperty("config.lev.appservercontext.dir");
                        strSrvDir = strSrvDir + strFileSep;
                        strSrvDir = strSrvDir + propServer.getProperty("server.connectsrv.config.dir.name");
                        newSasCmd = strSrvDir + strFileSep + commandName;
                        if ("Windows".equalsIgnoreCase(MUU_Object.getOS_Family())) {
                            newSasCmd = "\"" + newSasCmd + "\"";
                        }
                        AssociationList propList = cmSrv.getProperties();
                        for (int i = 0; i < propList.size(); ++i) {
                            Property prop = (Property)propList.get(i);
                            if (!prop.getPropertyName().equalsIgnoreCase("Command")) continue;
                            MUU_Client.m_logger.info("newSascmd:" + newSasCmd);
                            prop.setDefaultValue(newSasCmd);
                            prop.updateMetadataAll();
                            noCommand = false;
                        }
                        if (noCommand) {
                            String strName = "Server.Connect.SASCMD.Name.xmlKey.txt";
                            Property sascmd = this.CreateProperty(this.m_reposID, strName, "Command", newSasCmd, "1111");
                            propList.add(sascmd);
                            MUU_Client.m_logger.info("add newSascmd:" + newSasCmd);
                        }
                    }
                    if (!this.changeAssociatedMachine(spawner = this.getConnectSpawner(this.m_spawnerName))) {
                        MUU_Client.m_logger.info("Dit not change machine for connect spawner " + spawner.getName());
                    }
                    if (cmSrv.getSourceConnections() == null || cmSrv.getSourceConnections().size() <= 0 || (connection = (SASClientConnection)cmSrv.getSourceConnections().get(0)) == null) continue;
                    if (!this.changeAssociatedMachine(cmSrv)) {
                        MUU_Client.m_logger.info("Did not change machine for connect server" + cmSrv.getName());
                    }
                    String changedPort = this.getChangedPort(connection);
                    MUU_Client.m_logger.info("changedPort:" + changedPort);
                    connection.setPort(changedPort);
                    connection.updateMetadataAll();
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (RemoteException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (MdException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
            }
            this.updateConnectSpawners();
        } else {
            MUU_Client.m_logger.error("Error: Temporay directory not found. 9.1.3 command will not be replaced by 9.2.");
        }
    }

    private ServerComponent getConnectSpawner(String name) {
        ServerComponent s = null;
        try {
            List spawnerList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, this.m_reposID, m_strMetadataType, 128, m_strXMLSelect_Spawner);
            for (int i = 0; i < spawnerList.size(); ++i) {
                s = (ServerComponent)spawnerList.get(i);
                if (!s.getName().equalsIgnoreCase(name)) continue;
                return s;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return s;
    }

    private void updateConnectSpawners() {
        try {
            List spawnerList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, this.m_reposID, m_strMetadataType, 128, m_strXMLSelect_Spawner);
            for (int i = 0; i < spawnerList.size(); ++i) {
                ServerComponent sc = (ServerComponent)spawnerList.get(i);
                sc.setName(this.setString(sc.getName(), m_pattern, "Connect"));
                sc.setMinor(Integer.parseInt(MUU_Client.m_strMinor));
                sc.setSoftwareVersion(MUU_Client.m_strSoftwareVersion);
                sc.setMajor(Integer.parseInt(MUU_Client.m_strMajor));
                sc.updateMetadataAll();
                MUU_Client.m_logger.info("updated connectspawner name:" + sc.getName());
                if (sc.getName().equalsIgnoreCase(this.m_spawnerName) && !this.changeAssociatedMachine(sc)) {
                    MUU_Client.m_logger.info("Did not change machine for spawner" + sc.getName());
                }
                sc.updateMetadataAll();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }

    private Machine getMachine(String host) {
        try {
            List machList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, this.m_reposID, "Machine", 128, "<XMLSELECT search=\"*[@Name='" + host + "']\" />");
            if (machList.size() != 0) {
                Machine machine = (Machine)machList.get(0);
                return machine;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String setString(String str, String connectsrvPattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(connectsrvPattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + connectsrvPattern.length();
        }
        result.append(str.substring(s));
        return Names.mapNameToOMRObjectName((String)result.toString());
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    public boolean doLocationChange(String changedHost) throws MUUException {
        List clientConnections = MetaDataHelper.getSASClientConnections((ServerComponent)this.m_objMetadata);
        SASClientConnection connection = null;
        try {
            if (clientConnections != null) {
                for (int index = 0; index < clientConnections.size(); ++index) {
                    connection = (SASClientConnection)clientConnections.get(index);
                    connection.setRemoteAddress(changedHost);
                }
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return false;
    }

    private boolean changeAssociatedMachine(ServerComponent server) {
        boolean changeMachine = false;
        if (this.m_changedHost != null) {
            try {
                Machine associatedMachine = server.getAssociatedMachine();
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.name.log") + associatedMachine + " : " + this.m_changedHost);
                String machineName = null;
                if (associatedMachine != null) {
                    machineName = associatedMachine.getName();
                }
                if (!MetaDataHelper.isHostsEqual(machineName, this.m_changedHost)) {
                    Machine newMachine = this.locateMachine(this.m_changedHost);
                    if (newMachine != null) {
                        server.setAssociatedMachine(newMachine);
                        server.updateMetadataAll();
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_ConnectSrv.changing.host.fmt.log", new Object[]{this.cmSrv.getName(), this.m_changedHost}));
                    } else {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_ConnectSrv.new.machine.not.found.fmt.log", new Object[]{this.m_changedHost}));
                    }
                    changeMachine = true;
                }
            }
            catch (MUUException e) {
                e.printStackTrace();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (MdException e1) {
                e1.printStackTrace();
            }
        }
        return changeMachine;
    }

    protected String getChangedPort(SASClientConnection con) {
        String propertyName = null;
        String changedPort = null;
        try {
            propertyName = con.getId() + "_" + "changedport";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        changedPort = MUU_ConnectSrv.getProperty(propertyName);
        return changedPort;
    }

    private boolean isPrimaryServer(SMUProperties smuProperties, ServerComponent server) throws MUUException {
        String serverId = null;
        try {
            serverId = server.getId();
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return smuProperties.isPrimaryServer(serverId);
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        return false;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return false;
    }
}

