/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MUU_Spawner;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.impl.RootImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MUU {
    IOMI m_con = null;
    MdFactory m_mdFactory = null;
    MdOMIUtil m_omiUtil = null;
    MdObjectStore m_store = null;

    MUU(IOMI con, MdFactory factory) throws MUUException {
        try {
            this.m_con = con;
            this.m_mdFactory = factory;
            this.m_omiUtil = factory.getOMIUtil();
            this.m_store = factory.createObjectStore();
        }
        catch (RemoteException e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    public boolean UpgradeMetadata(String strReposId, String strProdCode) throws MUUException {
        Vector<MUU_Object> vObjects = new Vector<MUU_Object>();
        try {
            String strClasspath = MUU.class.getResource("MUU.class").toString();
            if (strClasspath.indexOf("!/") != -1) {
                strClasspath = strClasspath.substring(0, strClasspath.indexOf("!/") + 2);
            }
            URL urlJAR = new URL(strClasspath);
            JarURLConnection juc = (JarURLConnection)urlJAR.openConnection();
            JarFile jf = juc.getJarFile();
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                try {
                    String ext;
                    String entry = entries.nextElement().getName();
                    if (entry.length() <= 6 || entry.lastIndexOf(".") == -1 || !(ext = entry.substring(entry.lastIndexOf("."))).equalsIgnoreCase(".class")) continue;
                    entry = entry.replace('/', '.');
                    if ((entry = entry.substring(0, entry.length() - 6)).indexOf("com.sas.metadata.muu") == -1) continue;
                    Class<?> clsUpgrade = Class.forName(entry);
                    Field fProdCode = clsUpgrade.getField("m_strProductCode");
                    Field fMdType = clsUpgrade.getField("m_strMetadataType");
                    Field fTemplate = clsUpgrade.getField("m_strTemplate");
                    Field fPublicName = clsUpgrade.getField("m_strPublicName");
                    Field fXMLSelect = clsUpgrade.getField("m_strXMLSelect");
                    String strCLSProdCode = (String)fProdCode.get(clsUpgrade);
                    String strMdType = (String)fMdType.get(clsUpgrade);
                    String strTemplate = (String)fTemplate.get(clsUpgrade);
                    String strPublicName = (String)fPublicName.get(clsUpgrade);
                    String strXMLSelect = (String)fXMLSelect.get(clsUpgrade);
                    if (!strCLSProdCode.equalsIgnoreCase(strProdCode) && strProdCode.length() != 0) continue;
                    List lstObj = this.getObjectList(strReposId, strMdType, 128, strXMLSelect);
                    Object[] arrObjects = new Object[]{strPublicName, new Integer(lstObj.size())};
                    String strMsg = MessageBundle.getString("MUU.obj.found.fmt.log", arrObjects);
                    MUU_Client.m_logger.info(strMsg);
                    for (int iObj = 0; iObj < lstObj.size(); ++iObj) {
                        RootImpl obj = (RootImpl)lstObj.get(iObj);
                        MUU_Object muuObj = (MUU_Object)clsUpgrade.newInstance();
                        muuObj.init(this.m_con, this.m_mdFactory, this.m_store);
                        String strInputXML = "<" + strMdType + " Id=\"";
                        strInputXML = strInputXML + obj.getId();
                        strInputXML = strInputXML + "\"/>";
                        RootImpl mdObject = (RootImpl)this.getMdObject(strInputXML, strTemplate);
                        muuObj.setMetadata(mdObject);
                        if (!muuObj.isMigrated()) continue;
                        vObjects.add(muuObj);
                    }
                }
                catch (ClassCastException e) {
                    MUU_Client.m_logger.error("ClassCastException: " + e.getMessage());
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (InstantiationException e) {
                    MUU_Client.m_logger.error("InstantiationException: " + e.getMessage());
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (NoSuchFieldException e) {
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
            }
            Object[] arrObjects1 = new Object[]{new Integer(vObjects.size())};
            String strMsg = MessageBundle.getString("MUU.obj.upgraded.fmt.log", arrObjects1);
            MUU_Client.m_logger.info(strMsg);
            if (vObjects.size() == 0) {
                return true;
            }
            MUU_Client.m_logger.info(MessageBundle.getString("UPGRADING.METADATA.log"));
            for (int iObj = 0; iObj < vObjects.size(); ++iObj) {
                MUU_Object obj = (MUU_Object)vObjects.get(iObj);
                Object[] arrObjects = new Object[]{new Integer(iObj + 1), obj.getPublicName(), obj.m_objMetadata.getName()};
                strMsg = MessageBundle.getString("MUU.update.metadata.msg.fmt.log", arrObjects);
                MUU_Client.m_logger.info(strMsg);
                obj.UpgradeObjects(strReposId);
            }
            this.m_store.updatedMetadataAll();
            MUU_Client.m_logger.info(MessageBundle.getString("MUU.upgradation.finished.txt"));
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected List getObjectList(String strReposId, String strType, int iFlags, String strOptions) throws MUUException {
        try {
            List lstObjects = this.m_omiUtil.getMetadataObjects(strReposId, strType, iFlags, strOptions);
            return lstObjects;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected Object getMdObject(String strInputXML, String strTemplate) throws MUUException {
        try {
            int iFlags = 268;
            List lstObjects = this.m_omiUtil.getMetadataObjects((MdStore)this.m_store, strInputXML, strTemplate, iFlags);
            if (lstObjects.size() > 0) {
                return lstObjects.get(0);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return null;
    }

    protected void DebugMUU(String strReposId) throws MUUException {
        List lstObj = this.getObjectList(strReposId, "ServerComponent", 128, "<XMLSelect Search=\"@ClassIdentifier='IOM Spawner'\"/>");
        for (int iObj = 0; iObj < lstObj.size(); ++iObj) {
            RootImpl obj = (RootImpl)lstObj.get(iObj);
            MUU_Spawner muuObj = new MUU_Spawner();
            muuObj.init(this.m_con, this.m_mdFactory, this.m_store);
            String strInputXML = "<ServerComponent Id=\"A5E8OFTI.AW000004\"/>";
            RootImpl mdObject = (RootImpl)this.getMdObject(strInputXML, "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><SoftwareTrees/><Properties/><ServiceTypes/><SourceConnections/><UsedByComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><TCPIPConnection><Properties/><Domain/><Source/><UsingPrototype/></TCPIPConnection><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"></Property></Templates>");
            muuObj.setMetadata(mdObject);
            try {
                Object[] arrObjects = new Object[]{new Integer(iObj + 1), muuObj.getPublicName(), muuObj.m_objMetadata.getName()};
                String strMsg = MessageBundle.getString("MUU.update.metadata.msg.fmt.log", arrObjects);
                MUU_Client.m_logger.info(strMsg);
                muuObj.UpgradeObjects(strReposId);
                continue;
            }
            catch (Exception e) {
                MUU_Client.m_logger.error(e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }
}

