/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PersistConstants;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.impl.RB;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PromptObjectFactory {
    private static PromptObjectFactory singleton;
    private static final Map<String, Object> mapOfClasses;

    private PromptObjectFactory() {
    }

    public static void addEntry(String key, String className, boolean replace) {
        if (replace || !mapOfClasses.containsKey(key)) {
            mapOfClasses.put(key, className);
        }
    }

    public static void addEntry(String key, String className) {
        PromptObjectFactory.addEntry(key, className, false);
    }

    public static synchronized PromptObjectFactory getInstance() {
        if (singleton == null) {
            singleton = new PromptObjectFactory();
        }
        return singleton;
    }

    public static void verifyFactoryIntegrity() {
        Field[] fields = PersistConstants.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> c;
            Field field = fields[i];
            String fieldName = field.getName();
            if (fieldName == null || !fieldName.startsWith("ELEMENT_") || (c = field.getType()) == null || !c.equals(String.class)) continue;
            String elementName = null;
            try {
                elementName = (String)field.get(null);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("The field named \"" + fieldName + "\" must be declared static.");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (mapOfClasses.containsKey(elementName)) continue;
            String msg = "PromptObjectFactory-- No element name-to-class mapping found for element: " + elementName;
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }

    public PersistenceInterface newObject(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c;
        ValidateArg.notNull((Object)type, (String)"type");
        if (mapOfClasses.containsKey(type)) {
            Object out = mapOfClasses.get(type);
            if (out instanceof Class) {
                c = (Class<?>)out;
            } else {
                String className = (String)out;
                c = Class.forName(className);
                mapOfClasses.put(type, c);
            }
        } else {
            String msg = MessageFormat.format(RB.getStringResource("PromptObjectFactory.unknownClass.fmt.log"), type);
            throw new ClassNotFoundException(msg);
        }
        return (PersistenceInterface)c.newInstance();
    }

    public boolean isElementRecognized(String elementName) {
        return mapOfClasses.containsKey(elementName);
    }

    static {
        mapOfClasses = new ConcurrentHashMap<String, Object>(180);
        mapOfClasses.put("BooleanDefinition", "com.sas.prompts.definitions.BooleanDefinition");
        mapOfClasses.put("ColorDefinition", "com.sas.prompts.definitions.ColorDefinition");
        mapOfClasses.put("DataSourceDefinition", "com.sas.prompts.definitions.DataSourceDefinition");
        mapOfClasses.put("DataSourceColumnDefinition", "com.sas.prompts.definitions.DataSourceColumnDefinition");
        mapOfClasses.put("DateDefinition", "com.sas.prompts.definitions.DateDefinition");
        mapOfClasses.put("DateRangeDefinition", "com.sas.prompts.definitions.DateRangeDefinition");
        mapOfClasses.put("DoubleDefinition", "com.sas.prompts.definitions.DoubleDefinition");
        mapOfClasses.put("DoubleRangeDefinition", "com.sas.prompts.definitions.DoubleRangeDefinition");
        mapOfClasses.put("HyperlinkDefinition", "com.sas.prompts.definitions.HyperlinkDefinition");
        mapOfClasses.put("InputFileDefinition", "com.sas.prompts.definitions.InputFileDefinition");
        mapOfClasses.put("IntegerDefinition", "com.sas.prompts.definitions.IntegerDefinition");
        mapOfClasses.put("IntegerRangeDefinition", "com.sas.prompts.definitions.IntegerRangeDefinition");
        mapOfClasses.put("OutputFileDefinition", "com.sas.prompts.definitions.OutputFileDefinition");
        mapOfClasses.put("SASLibraryDefinition", "com.sas.prompts.definitions.SASLibraryDefinition");
        mapOfClasses.put("StringRangeDefinition", "com.sas.prompts.definitions.StringRangeDefinition");
        mapOfClasses.put("TextDefinition", "com.sas.prompts.definitions.TextDefinition");
        mapOfClasses.put("ModalGroupDefinition", "com.sas.prompts.definitions.ModalGroupDefinition");
        mapOfClasses.put("HyperlinkDefinition", "com.sas.prompts.definitions.HyperlinkDefinition");
        mapOfClasses.put("OLAPMemberNameDefinition", "com.sas.prompts.definitions.remote.OLAPMemberNameDefinition");
        mapOfClasses.put("StoredProcessDefinition", "com.sas.prompts.storedprocess.StoredProcessDefinition");
        mapOfClasses.put("MetadataSourceDefinition", "com.sas.prompts.definitions.MetadataSourceDefinition");
        mapOfClasses.put("FontDefinition", "com.sas.prompts.definitions.FontDefinition");
        mapOfClasses.put("FileUploadDefinition", "com.sas.prompts.definitions.FileUploadDefinition");
        mapOfClasses.put("ObjectDefinition", "com.sas.prompts.definitions.ObjectDefinition");
        mapOfClasses.put("SharedFontDefinition", "com.sas.prompts.definitions.shared.SharedFontDefinition");
        mapOfClasses.put("SharedBooleanDefinition", "com.sas.prompts.definitions.shared.SharedBooleanDefinition");
        mapOfClasses.put("SharedColorDefinition", "com.sas.prompts.definitions.shared.SharedColorDefinition");
        mapOfClasses.put("SharedDataSourceDefinition", "com.sas.prompts.definitions.shared.SharedDataSourceDefinition");
        mapOfClasses.put("SharedDataSourceColumnDefinition", "com.sas.prompts.definitions.shared.SharedDataSourceColumnDefinition");
        mapOfClasses.put("SharedDateDefinition", "com.sas.prompts.definitions.shared.SharedDateDefinition");
        mapOfClasses.put("SharedDateRangeDefinition", "com.sas.prompts.definitions.shared.SharedDateRangeDefinition");
        mapOfClasses.put("SharedDoubleDefinition", "com.sas.prompts.definitions.shared.SharedDoubleDefinition");
        mapOfClasses.put("SharedDoubleRangeDefinition", "com.sas.prompts.definitions.shared.SharedDoubleRangeDefinition");
        mapOfClasses.put("SharedHyperlinkDefinition", "com.sas.prompts.definitions.shared.SharedHyperlinkDefinition");
        mapOfClasses.put("SharedInputFileDefinition", "com.sas.prompts.definitions.shared.SharedInputFileDefinition");
        mapOfClasses.put("SharedIntegerDefinition", "com.sas.prompts.definitions.shared.SharedIntegerDefinition");
        mapOfClasses.put("SharedIntegerRangeDefinition", "com.sas.prompts.definitions.shared.SharedIntegerRangeDefinition");
        mapOfClasses.put("SharedOutputFileDefinition", "com.sas.prompts.definitions.shared.SharedOutputFileDefinition");
        mapOfClasses.put("SharedSASLibraryDefinition", "com.sas.prompts.definitions.shared.SharedSASLibraryDefinition");
        mapOfClasses.put("SharedStringRangeDefinition", "com.sas.prompts.definitions.shared.SharedStringRangeDefinition");
        mapOfClasses.put("SharedTextDefinition", "com.sas.prompts.definitions.shared.SharedTextDefinition");
        mapOfClasses.put("SharedHyperlinkDefinition", "com.sas.prompts.definitions.shared.SharedHyperlinkDefinition");
        mapOfClasses.put("SharedOLAPMemberNameDefinition", "com.sas.prompts.definitions.remote.shared.SharedOLAPMemberNameDefinition");
        mapOfClasses.put("SharedMetadataSourceDefinition", "com.sas.prompts.definitions.shared.SharedMetadataSourceDefinition");
        mapOfClasses.put("SharedFileUploadDefinition", "com.sas.prompts.definitions.shared.SharedFileUploadDefinition");
        mapOfClasses.put("RelationalDataItemValueProvider", "com.sas.storage.valueprovider.dynamic.iq.RelationalDataItemValueProvider");
        mapOfClasses.put("ColumnValueProvider", "com.sas.storage.valueprovider.workspace.ColumnValueProvider");
        mapOfClasses.put("MemberValueProvider", "com.sas.storage.valueprovider.olap.MemberValueProvider");
        mapOfClasses.put("StaticValueProvider", "com.sas.storage.valueprovider.StaticValueProvider");
        mapOfClasses.put("JDBCDynamicValueProvider", "com.sas.prompts.valueprovider.dynamic.jdbc.JDBCDynamicValueProvider");
        mapOfClasses.put("SearchCriteria", "com.sas.storage.valueprovider.SearchCriteria");
        mapOfClasses.put("OLAPSearchCriteria", "com.sas.storage.valueprovider.OLAPSearchCriteria");
        mapOfClasses.put("Help", "com.sas.prompts.PromptHelp");
        mapOfClasses.put("ValueItemList", "com.sas.storage.valueprovider.ValueItemList");
        mapOfClasses.put("ValueItemPersister", "com.sas.storage.valueprovider.ValueItemPersister");
        mapOfClasses.put("Language", "com.sas.util.xmlpersist.impl.LocalizedLabels");
        mapOfClasses.put("Text", "com.sas.util.xmlpersist.impl.LocalizedText");
        mapOfClasses.put("PromptDefinitionCombination", "com.sas.prompts.PromptDefinitionCombination");
        mapOfClasses.put("LocalizablePersistableString", "com.sas.util.xmlpersist.impl.LocalizablePersistableString");
        mapOfClasses.put("PersistableSupportedSpecialValues", "com.sas.util.xmlpersist.impl.PersistableSupportedSpecialValues");
        mapOfClasses.put("IQIdentityValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider");
        mapOfClasses.put("RelationalDataItemValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider");
        mapOfClasses.put("IQRelationalDataItemValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.IQRelationalDataItemValueProvider");
        mapOfClasses.put("OLAPDataItemValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider");
        mapOfClasses.put("PromptColumnValueProvider", "com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider");
        mapOfClasses.put("LocalizableColumnValue", "");
        mapOfClasses.put("LocalizableColumnLabel", "");
        mapOfClasses.put("LocalizableColumn", "com.sas.storage.valueretriever.LocalizableColumn");
        mapOfClasses.put("LanguageSet", "com.sas.storage.valueretriever.LanguageSet");
        mapOfClasses.put("StaticValueRetrieverSupport", "com.sas.prompts.definitions.vr.StaticValueRetrieverSupport");
        mapOfClasses.put("DynamicValueRetrieverSupport", "com.sas.prompts.definitions.vr.DynamicValueRetrieverSupport");
        mapOfClasses.put("WebServiceValueRetrieverSupport", "com.sas.prompts.definitions.vr.WebServiceValueRetrieverSupport");
        mapOfClasses.put("CubeNamesValueProvider", "com.sas.prompts.valueprovider.dynamic.olap.CubeNamesValueProvider");
        mapOfClasses.put("CubeItemsValueProvider", "com.sas.prompts.valueprovider.dynamic.olap.CubeItemsValueProvider");
        mapOfClasses.put("PromptMemberValueProvider", "com.sas.prompts.valueprovider.dynamic.olap.PromptMemberValueProvider");
        mapOfClasses.put("InfoMapsValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.InfoMapsValueProvider");
        mapOfClasses.put("InfoMapItemsValueProvider", "com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider");
        mapOfClasses.put("TableNamesValueProvider", "com.sas.prompts.valueprovider.dynamic.workspace.TableNamesValueProvider");
        mapOfClasses.put("ColumnNamesValueProvider", "com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider");
        mapOfClasses.put("ThemeValueProvider", "");
        mapOfClasses.put("QueryItem", "com.sas.prompts.definitions.vr.PersistableQueryItem");
        mapOfClasses.put("QueryItemSearchCriteria", "com.sas.prompts.definitions.vr.PersistableQueryItemSearchCriteria");
        mapOfClasses.put("MetadataItem", "com.sas.prompts.definitions.vr.PersistableMetadataItem");
        mapOfClasses.put("Boolean", "com.sas.prompts.datatypes.values.BooleanValue");
        mapOfClasses.put("Collection", "com.sas.prompts.datatypes.values.CollectionValue");
        mapOfClasses.put("Color", "com.sas.prompts.datatypes.values.ColorValue");
        mapOfClasses.put("DataSource", "com.sas.prompts.datatypes.values.DataSourceValue");
        mapOfClasses.put("DataSourceColumn", "com.sas.prompts.datatypes.values.DataSourceColumnValue");
        mapOfClasses.put("DateRange", "com.sas.prompts.datatypes.values.DateRangeValue");
        mapOfClasses.put("Date", "com.sas.prompts.datatypes.values.DateValue");
        mapOfClasses.put("DoubleRange", "com.sas.prompts.datatypes.values.DoubleRangeValue");
        mapOfClasses.put("Double", "com.sas.prompts.datatypes.values.DoubleValue");
        mapOfClasses.put("FileLocation", "com.sas.prompts.datatypes.values.FileLocationValue");
        mapOfClasses.put("Hyperlink", "com.sas.prompts.datatypes.values.HyperlinkValue");
        mapOfClasses.put("IntegerRange", "com.sas.prompts.datatypes.values.IntegerRangeValue");
        mapOfClasses.put("Integer", "com.sas.prompts.datatypes.values.IntegerValue");
        mapOfClasses.put("MissingValue", "com.sas.prompts.datatypes.values.MissingValue");
        mapOfClasses.put("Month", "com.sas.prompts.datatypes.values.MonthValue");
        mapOfClasses.put("OLAPMemberName", "com.sas.prompts.datatypes.values.OLAPMemberNameValue");
        mapOfClasses.put("Quarter", "com.sas.prompts.datatypes.values.QuarterValue");
        mapOfClasses.put("SASLibraryLocation", "com.sas.prompts.datatypes.values.SASLibraryLocationValue");
        mapOfClasses.put("SpecialValue", "com.sas.prompts.datatypes.values.SpecialValue");
        mapOfClasses.put("String", "com.sas.prompts.datatypes.values.StringValue");
        mapOfClasses.put("MaskedString", "com.sas.prompts.datatypes.values.MaskedValue");
        mapOfClasses.put("StringRange", "com.sas.prompts.datatypes.values.StringRangeValue");
        mapOfClasses.put("Timestamp", "com.sas.prompts.datatypes.values.TimestampValue");
        mapOfClasses.put("Time", "com.sas.prompts.datatypes.values.TimeValue");
        mapOfClasses.put("Week", "com.sas.prompts.datatypes.values.WeekValue");
        mapOfClasses.put("Weekday", "com.sas.prompts.datatypes.values.WeekdayValue");
        mapOfClasses.put("Year", "com.sas.prompts.datatypes.values.YearValue");
        mapOfClasses.put("NullValue", "com.sas.prompts.datatypes.values.NullValue");
        mapOfClasses.put("AnnotatedValue", "com.sas.prompts.datatypes.values.AnnotatedValue");
        mapOfClasses.put("FontValue", "com.sas.prompts.datatypes.values.FontValue");
        mapOfClasses.put("MetadataSource", "com.sas.prompts.datatypes.values.MetadataSourceValue");
        mapOfClasses.put("Object", "com.sas.prompts.datatypes.values.ObjectValue");
        mapOfClasses.put("ObjectValue", "com.sas.prompts.datatypes.values.ObjectValue");
        mapOfClasses.put("HorizontalGroup", "com.sas.prompts.groups.HorizontalGroup");
        mapOfClasses.put("ModalChoiceGroup", "com.sas.prompts.groups.ModalChoiceGroup");
        mapOfClasses.put("ModalGroup", "com.sas.prompts.groups.ModalGroup");
        mapOfClasses.put("PromptGroup", "com.sas.prompts.groups.PromptGroup");
        mapOfClasses.put("TransparentGroup", "com.sas.prompts.groups.TransparentGroup");
        mapOfClasses.put("SharedPromptGroup", "com.sas.prompts.groups.shared.SharedPromptGroup");
        mapOfClasses.put("SharedModalGroup", "com.sas.prompts.groups.shared.SharedModalGroup");
        mapOfClasses.put("SharedModalChoiceGroup", "com.sas.prompts.groups.shared.SharedModalChoiceGroup");
        mapOfClasses.put("SharedTransparentGroup", "com.sas.prompts.groups.shared.SharedTransparentGroup");
        mapOfClasses.put("TextValue", "com.sas.prompts.util.TextValue");
        mapOfClasses.put("MapText", "com.sas.prompts.util.MapText");
        mapOfClasses.put("Attribute", "com.sas.prompts.util.AttributeValue");
        mapOfClasses.put("GridLayout", "com.sas.prompts.groups.PromptGroupGridLayout");
        mapOfClasses.put("GridLayoutInfo", "com.sas.prompts.groups.PromptGroupGridLayoutInfo");
        mapOfClasses.put("BooleanOperand", "com.sas.storage.simplesqlmodel.BooleanOperand");
        mapOfClasses.put("ColumnInfo", "com.sas.storage.simplesqlmodel.ColumnInfo");
        mapOfClasses.put("ColumnOperand", "com.sas.storage.simplesqlmodel.ColumnOperand");
        mapOfClasses.put("DoubleOperand", "com.sas.storage.simplesqlmodel.DoubleOperand");
        mapOfClasses.put("DateOperand", "com.sas.storage.simplesqlmodel.DateOperand");
        mapOfClasses.put("TimeOperand", "com.sas.storage.simplesqlmodel.TimeOperand");
        mapOfClasses.put("TimestampOperand", "com.sas.storage.simplesqlmodel.TimestampOperand");
        mapOfClasses.put("Expression", "com.sas.storage.simplesqlmodel.Expression");
        mapOfClasses.put("FormattedOperator", "com.sas.storage.simplesqlmodel.FormattedOperator");
        mapOfClasses.put("IntegerOperand", "com.sas.storage.simplesqlmodel.IntegerOperand");
        mapOfClasses.put("StringOperand", "com.sas.storage.simplesqlmodel.StringOperand");
        mapOfClasses.put("WhereClause", "com.sas.storage.simplesqlmodel.WhereClause");
        mapOfClasses.put("MultiValueFormattedOperator", "com.sas.storage.simplesqlmodel.MultiValueFormattedOperator");
        mapOfClasses.put("PromptValueOperand", "com.sas.prompts.simplesqlmodel.PromptValueOperand");
        mapOfClasses.put("PromptColumnOperand", "com.sas.prompts.simplesqlmodel.PromptColumnOperand");
        mapOfClasses.put("PromptValues", "com.sas.prompts.PromptValues");
        mapOfClasses.put("PromptDefinitionReference", "com.sas.prompts.PromptDefinitionReference");
        mapOfClasses.put("AttributeDependency", "com.sas.prompts.AttributeDependency");
        mapOfClasses.put("AttributeDependencyClearOperand", "com.sas.prompts.AttributeDependencyClearOperand");
        mapOfClasses.put("DefaultScriptHolder", "com.sas.prompts.script.impl.DefaultScriptHolder");
        mapOfClasses.put("SOAPWebServiceValueRetriever", "");
        mapOfClasses.put("RESTWebServiceValueRetriever", "");
        mapOfClasses.put("CDATA", "com.sas.prompts.util.CDATA");
        mapOfClasses.put("BaseUIConfiguration", "com.sas.prompts.uiconfig.BaseUIConfiguration");
        mapOfClasses.put("ButtonUIConfiguration", "com.sas.prompts.uiconfig.ButtonUIConfiguration");
        mapOfClasses.put("CheckBoxUIConfiguration", "com.sas.prompts.uiconfig.CheckBoxUIConfiguration");
        mapOfClasses.put("ComboBoxUIConfiguration", "com.sas.prompts.uiconfig.ComboBoxUIConfiguration");
        mapOfClasses.put("ImageUIConfiguration", "com.sas.prompts.uiconfig.ImageUIConfiguration");
        mapOfClasses.put("ListUIConfiguration", "com.sas.prompts.uiconfig.ListUIConfiguration");
        mapOfClasses.put("CheckBoxListUIConfiguration", "com.sas.prompts.uiconfig.CheckBoxListUIConfiguration");
        mapOfClasses.put("MapUIConfiguration", "com.sas.prompts.uiconfig.MapUIConfiguration");
        mapOfClasses.put("RadioBoxUIConfiguration", "com.sas.prompts.uiconfig.RadioBoxUIConfiguration");
        mapOfClasses.put("SliderUIConfiguration", "com.sas.prompts.uiconfig.SliderUIConfiguration");
        mapOfClasses.put("TableUIConfiguration", "com.sas.prompts.uiconfig.TableUIConfiguration");
        mapOfClasses.put("SpinnerUIConfiguration", "com.sas.prompts.uiconfig.SpinnerUIConfiguration");
        mapOfClasses.put("TitledGroupUIConfiguration", "com.sas.prompts.uiconfig.TitledGroupUIConfiguration");
        mapOfClasses.put("CollapsibleGroupUIConfiguration", "com.sas.prompts.uiconfig.CollapsibleGroupUIConfiguration");
        mapOfClasses.put("ClassInstanceUIConfiguration", "com.sas.prompts.uiconfig.ClassInstanceUIConfiguration");
        mapOfClasses.put("TreeUIConfiguration", "com.sas.prompts.uiconfig.TreeUIConfiguration");
        mapOfClasses.put("DualSelectorUIConfiguration", "com.sas.prompts.uiconfig.DualSelectorUIConfiguration");
        mapOfClasses.put("CheckBoxTreeUIConfiguration", "com.sas.prompts.uiconfig.CheckBoxTreeUIConfiguration");
        mapOfClasses.put("Column", "com.sas.prompts.definitions.vr.PersistableColumnDefinition");
        mapOfClasses.put("Search", "com.sas.prompts.definitions.vr.PersistableSearch");
    }
}

