/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.StringValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LocalizedLabels
extends AbstractPersistence {
    private Locale locale;
    private LinkedHashMap<String, String> map = new LinkedHashMap();

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public final Map<String, String> getLabelsMap() {
        LinkedHashMap<String, String> retVal = new LinkedHashMap<String, String>();
        retVal.putAll(this.map);
        return retVal;
    }

    public final void setLabelsMap(Map<String, String> map) {
        if (!(map instanceof LinkedHashMap)) {
            throw new IllegalArgumentException("Must supply a LinkedHashMap");
        }
        this.map.putAll(map);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("LabelSet");
        if (!list.isEmpty()) {
            Iterator iter = list.iterator();
            this.getLogger2().debug("consumeRelObjects, setLabelsMap() ");
            while (iter.hasNext()) {
                BasePersistedValue text = (BasePersistedValue)iter.next();
                this.map.put((String)text.getValue(), text.getIndex());
                if (null == text.getValue()) continue;
                this.getLogger2().debug("consumeRelObjects, added label:", text.getValue().toString());
                this.getLogger2().debug("consumeRelObjects, with index:", text.getIndex());
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String locString = provider.consumeAttr("xml:lang");
        if (null == locString) {
            locString = provider.consumeAttr("lang");
        }
        if (null != locString) {
            this.getLogger2().debug("consuming attribute- locale: ", locString);
            this.setLocale(XmlUtil.xmlToLocale(locString));
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getLocale()) {
            String localeValue = XmlUtil.localeToXml(this.locale);
            element.setAttribute("xml:lang", localeValue);
            this.getLogger2().debug("Writing localized labels for locale", localeValue);
        }
        if (!this.map.isEmpty()) {
            List list = this.getWritableLabels();
            LocalizedLabels.writeRelatedObjects(list, element, writingContext, "LabelSet");
        }
    }

    private List getWritableLabels() {
        ArrayList<StringValue> list = new ArrayList<StringValue>();
        for (String text : this.map.keySet()) {
            String index = this.map.get(text);
            StringValue sv = new StringValue();
            sv.setIndex(index);
            sv.setValue(text);
            list.add(sv);
        }
        return list;
    }

    @Override
    public String getDefinitionElementName() {
        return "Language";
    }

    public boolean isEquivalentLocale(Locale locale2Check) {
        boolean retVal = false;
        if (null != this.locale && null != locale2Check) {
            if (this.locale.equals(locale2Check)) {
                retVal = true;
            } else if (this.locale.getLanguage().equals(locale2Check.getLanguage())) {
                retVal = true;
            }
        }
        return retVal;
    }
}

