/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.LocalizableString;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LocalizablePersistableString
extends LocalizableString
implements PersistenceInterface,
MultiLocaleProperties {
    private LoggerFactoryInterface factory = null;
    private CommonLoggerInterface logger = null;

    public LocalizablePersistableString(String text, Locale defaultLocale) {
        super(text, defaultLocale);
    }

    public LocalizablePersistableString() {
    }

    public LocalizablePersistableString(LocalizableString localizableString) {
        for (Locale locale : localizableString.getLocales()) {
            this.setText(localizableString.getText(locale), locale);
        }
        this.setDefaultLocale(localizableString.getDefaultLocale());
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList list = roHolder.consumeObjects("Labels");
        if (!list.isEmpty()) {
            Iterator iter = list.iterator();
            this.getLogger2().debug("consumeRelObjects()");
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setText(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, text is:", text.getText());
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String locString = provider.consumeAttr("defaultLocale");
        if (null != locString) {
            this.getLogger2().debug("consumeAttr, defaultLocale is: ", locString);
            this.setDefaultLocale(XmlUtil.xmlToLocale(locString));
        }
    }

    @Override
    public void consumeElementText(String text) {
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        List list;
        if (null != this.getDefaultLocale()) {
            String localeValue = XmlUtil.localeToXml(this.getDefaultLocale());
            element.setAttribute("defaultLocale", localeValue);
        }
        if (!(list = PersistHelper.getAllText(this, null)).isEmpty()) {
            this.getLogger2().debug("Writing persistable strings of size:", Integer.toString(list.size()));
            PersistHelper.writeRelatedObjects(list, element, writingContext, "Labels");
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "LocalizablePersistableString";
    }

    @Override
    public void replace(Object referencedObject, Object replacementObject) {
    }

    @Override
    public Element write(Node parentNode, IntegratedWritingContext writingContext) throws BackingStoreException {
        PromptsWritingContext writingContext2 = (PromptsWritingContext)writingContext;
        if (writingContext2.hasBeenWritten(this)) {
            PersistHelper.writeReferenceUnder(parentNode, writingContext2, this);
            return null;
        }
        Element element = this.writeDefinitionUnder(parentNode, writingContext2);
        Map writingContextOptionsMap = writingContext2.getOptionsMap();
        if (writingContextOptionsMap != null && writingContextOptionsMap.containsKey("removeUnreferencedPersistenceIDs")) {
            PersistHelper.removeUnreferencedPersistenceIDs(element, writingContext2);
        }
        return element;
    }

    final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext) throws BackingStoreException {
        String persistenceID = writingContext.getPersistenceID(this);
        return this.writeDefinitionUnder(parentNode, writingContext, persistenceID);
    }

    @Override
    public final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext, String persistenceID) throws BackingStoreException {
        Element thisElement = PersistHelper.newSubelement(parentNode, this.getDefinitionElementName());
        writingContext.markObjAsWritten(this);
        if (persistenceID != null) {
            thisElement.setAttribute("obj", persistenceID);
        }
        this.writeDefinition(thisElement, writingContext);
        return thisElement;
    }

    @Override
    public final void write(Node nodeToWriteUnder) throws BackingStoreException {
        this.write(nodeToWriteUnder, PersistenceFactory.newWritingContext(this, this.factory));
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    @Deprecated
    public final void setLoggerFactory(LoggerFactoryInterface factory) {
        this.factory = factory;
    }

    protected static final void writeRelatedObjects(List objsToWrite, Node parentNode, PromptsWritingContext writingContext, String relationshipName) throws BackingStoreException {
        PersistHelper.writeRelatedObjects(objsToWrite, parentNode, writingContext, relationshipName);
    }

    @Override
    public void beginLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void endLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList propertyList = new PropertyList();
        String text = this.getText(locale);
        if (null != text) {
            this.getLogger2().debug("getLocalizableProperties for:", text);
        }
        propertyList.addProperty("value", text);
        return propertyList;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (null != map && map.containsProperty("value")) {
            String text = map.getProperty("value");
            this.setText(text, locale);
            if (null != text) {
                this.getLogger2().debug("setLocalizableProperties for:", text);
            }
        }
    }

    @Override
    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getLocalizableProperties(this.getDefaultLocale());
    }

    @Override
    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setLocalizableProperties(this.getDefaultLocale(), map);
    }
}

