/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedReadingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import com.sas.util.xmlpersist.impl.RB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.xml.sax.SAXException;

class DefaultReadingContext
implements PromptsReadingContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> optionsMap = null;
    private Map<Object, Object> missingResources = null;
    private Map<Object, List<Object>> unknownAttributes = null;
    private List<Object> unknownElements = null;
    private IntegratedReadingContext foreignContext;
    private HashMap<String, PersistenceInterface> _regularItemsRefdByPersistenceID = new HashMap();
    private HashMap<String, PersistenceInterface> _unresolvedForwardReferencesWithinModel = new HashMap(40);
    private static final String RB_KEY = "DefaultReadingContext.";
    private transient LoggerFactoryInterface factory;
    private PersistenceInterface model;
    private transient CommonLoggerInterface logger = null;
    private static transient PromptObjectFactory objectFactory = null;

    DefaultReadingContext() {
        this(null);
    }

    DefaultReadingContext(LoggerFactoryInterface factory) {
        try {
            objectFactory = PromptObjectFactory.getInstance();
        }
        catch (ExceptionInInitializerError e) {
            this.getLogger2().error("Error occurred while initializing the PromptObjectFactory singleton.", (Throwable)e);
            throw e;
        }
    }

    DefaultReadingContext(LoggerFactoryInterface factory, PersistenceInterface model) {
        this(factory);
        this.model = model;
    }

    protected final CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    @Override
    public final PersistenceInterface getObjectForUsedObjectElement(String useOfType, String persistenceID) throws SAXException {
        PersistenceInterface out = this._regularItemsRefdByPersistenceID.get(persistenceID);
        if (out == null && (out = this._unresolvedForwardReferencesWithinModel.get(persistenceID)) == null) {
            out = this.newForwardReferenceObject(useOfType, persistenceID);
        }
        if (null != out) {
            this.getLogger2().debug("getObjectForUsedObjectElement()", out.toString());
        } else {
            this.getLogger2().debug("getObjectForUsedObjectElement()", "object is null");
        }
        return out;
    }

    private PersistenceInterface getNewRegularObject(String type, String persistenceID) throws SAXException {
        PersistenceInterface out = this.newObject(type);
        if (persistenceID != null && out != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, out);
        }
        return out;
    }

    private PersistenceInterface newForwardReferenceObject(String type, String persistenceID) throws SAXException {
        PersistenceInterface out = this.newObject(type);
        this._unresolvedForwardReferencesWithinModel.put(persistenceID, out);
        return out;
    }

    private PersistenceInterface newObject(String type) throws SAXException {
        PersistenceInterface o = null;
        try {
            o = objectFactory.newObject(type);
            this.getLogger2().debug("Making object of: ", type);
        }
        catch (ClassNotFoundException e) {
            throw new SAXException(e);
        }
        catch (InstantiationException e) {
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        PersistenceInterface out = o;
        return out;
    }

    private PersistenceInterface findAndUseForwardReferenceAsRegularObject(String persistenceID) {
        PersistenceInterface out = this._unresolvedForwardReferencesWithinModel.remove(persistenceID);
        if (out != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, out);
        }
        return out;
    }

    @Override
    public final void notePersistenceIDOfModelBeingRead(PersistenceInterface model1, String persistenceID) {
        if (persistenceID != null) {
            this._regularItemsRefdByPersistenceID.put(persistenceID, model1);
        }
    }

    @Override
    public final PersistenceInterface getObjectForNewObjectElement(String persistenceID, String elementName) throws SAXException {
        PersistenceInterface obj = null;
        if (persistenceID != null) {
            obj = this.findAndUseForwardReferenceAsRegularObject(persistenceID);
        }
        if (obj == null) {
            obj = this.getNewRegularObject(elementName, persistenceID);
        }
        if (null != obj && this.getLogger2().isDebugEnabled()) {
            this.getLogger2().debug("getObjectForNewObjectElement() was passed:", persistenceID);
            this.getLogger2().debug("Found obj for that ID,", obj.toString());
        }
        return obj;
    }

    public static final boolean isElementRecognized(String elementName) {
        return objectFactory.isElementRecognized(elementName);
    }

    @Override
    public PersistenceInterface getObjectFromMetadata(String type, String sbipUrl) throws BackingStoreException {
        this.getLogger2().info(RB.getStringResource("DefaultReadingContext.returnNull.log"));
        return null;
    }

    @Override
    public Object getObject(String reference, Class type) {
        PersistenceInterface out = this._regularItemsRefdByPersistenceID.get(reference);
        if (null != out) {
            this.getLogger2().debug("getObject() returns:", out.toString());
            if (null != type && !type.isInstance(out)) {
                out = null;
                this.getLogger2().debug("Returning null because object was not an instance of the type.");
            }
        } else {
            this.getLogger2().info("getObject() could not find an object for this reference: {0}", reference);
        }
        return out;
    }

    @Override
    public Object getObject(String reference) {
        if (null != this.getReadingContext()) {
            return this.getReadingContext().getObject(reference);
        }
        return null;
    }

    protected final LoggerFactoryInterface getFactory() {
        return this.factory;
    }

    @Override
    public void setOptionsMap(Map<String, Object> map) {
        this.optionsMap = map;
    }

    @Override
    public Map<String, Object> getOptionsMap() {
        return this.optionsMap;
    }

    @Override
    public final IntegratedReadingContext getReadingContext() {
        return this.foreignContext;
    }

    @Override
    public final void setReadingContext(IntegratedReadingContext foreignContext) {
        this.foreignContext = foreignContext;
    }

    @Override
    public PersistenceInterface getModel() {
        return this.model;
    }

    @Override
    public String modifySbipURL(String input) {
        return input;
    }

    @Override
    public Map<Object, Object> getMissingResources() {
        if (null == this.missingResources) {
            this.missingResources = new HashMap<Object, Object>();
        }
        return this.missingResources;
    }

    @Override
    public void addMissingResource(Object key, Object value) {
        if (null == this.missingResources) {
            this.missingResources = new HashMap<Object, Object>();
        }
        this.missingResources.put(key, value);
    }

    @Override
    public void addUnknownAttribute(Object key, Object value) {
        if (null == this.unknownAttributes) {
            this.unknownAttributes = new HashMap<Object, List<Object>>();
        }
        List<Object> mapList = null;
        mapList = this.unknownAttributes.containsKey(key) ? this.unknownAttributes.get(key) : new ArrayList<Object>();
        mapList.add(value);
        this.unknownAttributes.put(key, mapList);
    }

    @Override
    public Map<Object, List<Object>> getUnknownAttributes() {
        if (null == this.unknownAttributes) {
            this.unknownAttributes = new HashMap<Object, List<Object>>();
        }
        return this.unknownAttributes;
    }

    @Override
    public void addUnknownElement(Object elementName) {
        if (null == this.unknownElements) {
            this.unknownElements = new ArrayList<Object>();
        }
        this.unknownElements.add(elementName);
    }

    @Override
    public List<Object> getUnknownElements() {
        if (null == this.unknownElements) {
            this.unknownElements = new ArrayList<Object>();
        }
        return this.unknownElements;
    }

    @Override
    public Object getServer() {
        return null;
    }

    @Override
    public void setServer(Object server) {
    }

    @Override
    public void destroy() {
    }
}

