/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueretriever;

import com.sas.storage.valueretriever.LocalizableColumn;
import com.sas.storage.vr.dto.ColumnValueItem;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.AttributeDescription;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StaticValueRetrieverConfiguration
extends ValueRetrieverConfiguration
implements AttributeConfigurationInterface,
AttributeDescription {
    public static final String RB_KEY = "StaticValueRetrieverConfiguration.";
    public static final String VALUE_COLUMN = "StaticValueRetrieverConfiguration.VALUE_COLUMN";
    public static final String LABEL_COLUMNS = "StaticValueRetrieverConfiguration.LABEL_COLUMNS";
    private static final long serialVersionUID = 1L;
    public static final String DISPLAY_VALUE = "DISPLAY_VALUE";
    private LocalizableColumn valueColumn = new LocalizableColumn();
    private List<LocalizableColumn> labelsList = new LinkedList<LocalizableColumn>();
    private Locale locale = Locale.getDefault();
    private static Logger logger = LogManager.getLogger((String)StaticValueRetrieverConfiguration.class.getName());
    private List<QueryProperty> queryProperties = new ArrayList<QueryProperty>();

    public void configureValueColumn(@NotNull LocalizableColumn columnValue0) {
        if (null != columnValue0) {
            this.valueColumn = columnValue0;
        }
    }

    public void configureLabelColumns(@NotNull List<LocalizableColumn> list) {
        if (null != list) {
            this.labelsList.clear();
            this.labelsList = list;
        }
    }

    public LocalizableColumn getWritableValueColumn() {
        return this.valueColumn;
    }

    public List<LocalizableColumn> getWritableLabelColumns() {
        return this.labelsList;
    }

    public ColumnValueItem getValueColumn() {
        return this.valueColumn.getColumnValueItem(this.locale);
    }

    public void setValueColumn(@NotNull ColumnValueItem item) {
        this.valueColumn = LocalizableColumn.newColumn(item);
        logger.debug("setValueColumn to item named " + item.getName());
        logger.debug("setValueColumn to item of data type " + item.getDataType().toString());
        if (item.getLocale() != null && !this.locale.toString().equals(item.getLocale())) {
            this.locale = XmlUtil.xmlToLocale(item.getLocale());
        }
    }

    public List<ColumnValueItem> getAllLabels() {
        ArrayList<ColumnValueItem> listToReturn = new ArrayList<ColumnValueItem>();
        for (LocalizableColumn labelItem : this.labelsList) {
            ColumnValueItem label = labelItem.getColumnValueItem(this.locale);
            listToReturn.add(label);
        }
        return listToReturn;
    }

    public void setAllLabels(List<ColumnValueItem> list) {
        ValidateArg.notNull(list, (String)"list");
        this.checkInputList(list);
        this.labelsList.clear();
        for (ColumnValueItem item : list) {
            LocalizableColumn label = LocalizableColumn.newColumn(item);
            label.setColumnValueItem(item);
            this.labelsList.add(label);
        }
    }

    private void checkInputList(List<ColumnValueItem> list) {
        Integer size = null;
        int i = 0;
        for (ColumnValueItem item : list) {
            i = item.getRowData().size();
            if (null == size) {
                size = i;
                continue;
            }
            if (i == size) continue;
            throw new IllegalArgumentException("All column value items must have the same number of rows.");
        }
    }

    public boolean isDynamicSource() {
        return false;
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        logger.debug("configureAttributes starting");
        HashMap<String, Object> subOptions = new HashMap<String, Object>();
        if (options.containsKey(VALUE_COLUMN)) {
            logger.debug("configureAttributes() found a value column.");
            this.configureValueColumn(options, context, subOptions);
        }
        if (options.containsKey(LABEL_COLUMNS)) {
            subOptions.clear();
            List labelCVIs = (List)options.get(LABEL_COLUMNS);
            if (null != labelCVIs && !labelCVIs.isEmpty()) {
                logger.debug("configureAttributes() found label columns.");
                if (this.labelsList.size() == labelCVIs.size()) {
                    this.configureExistingColumns(labelCVIs, subOptions, context);
                } else if (this.labelsList.isEmpty()) {
                    this.setAllLabels(labelCVIs);
                } else {
                    logger.warn("The supplied list differed in size from the size of existing labels list. Stopping here.");
                }
            }
        }
        if (options.containsKey(DISPLAY_VALUE)) {
            String dispValue = (String)options.get(DISPLAY_VALUE);
            if (!this.queryProperties.isEmpty()) {
                for (QueryProperty qp : this.queryProperties) {
                    if (!DISPLAY_VALUE.equals(qp.getName())) continue;
                    qp.setValue(dispValue);
                    logger.debug("configureAttributes() updating DISPLAY_VALUE property.");
                    break;
                }
            } else {
                logger.debug("configureAttributes() adding new DISPLAY_VALUE property.");
                QueryProperty qp = new QueryProperty();
                qp.setName(DISPLAY_VALUE);
                qp.setValue(dispValue);
                this.queryProperties.add(qp);
            }
        }
    }

    private void configureValueColumn(Map<String, ?> options, Map<String, ?> context, Map<String, Object> subOptions) {
        ColumnValueItem input = (ColumnValueItem)options.get(VALUE_COLUMN);
        if (null != this.valueColumn.getColumnName() && this.valueColumn.matchesMe(input)) {
            subOptions.put("Column", input);
            this.valueColumn.configureAttributes(subOptions, context);
        } else {
            this.setValueColumn(input);
        }
    }

    private void configureExistingColumns(List<ColumnValueItem> labelCVIs, Map<String, Object> subOptions, Map<String, ?> context) {
        for (int i = 0; i < labelCVIs.size(); ++i) {
            ColumnValueItem item = labelCVIs.get(i);
            subOptions.clear();
            subOptions.put("Column", item);
            this.labelsList.get(i).configureAttributes(subOptions, context);
        }
    }

    public List<?> getAttributeDescriptors(Locale locale1) {
        return Collections.emptyList();
    }

    public void setLocale(@NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        this.locale = locale;
    }

    public List<QueryProperty> getQueryProperties() {
        ArrayList<QueryProperty> retVal = new ArrayList<QueryProperty>();
        retVal.addAll(this.queryProperties);
        return retVal;
    }

    public void setQueryProperties(List<QueryProperty> list) {
        if (null != list) {
            this.queryProperties.clear();
            this.queryProperties.addAll(list);
        }
    }
}

