/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.simplesqlmodel.Evaluator;
import com.sas.storage.simplesqlmodel.OperandFactory;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.storage.valueprovider.Searchable;
import com.sas.storage.valueprovider.StorageValueProviderConstants;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.AttributeConfigurationUtil;
import com.sas.util.ListFactory;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizedLabels;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StaticValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
MultiLocaleProperties,
Searchable,
AttributeConfigurationInterface {
    private transient Locale defaultLocale;
    private transient Map uniqueValues = null;
    private transient String shortName;
    private Map<Locale, List<ValueItem>> localeToValueItemMap;
    private DataTypeInterface dataType;
    private boolean displayValue;
    private boolean useValueAsLabel;

    public StaticValueProvider() {
        this(null, Locale.US);
    }

    public StaticValueProvider(List values, Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
        if (values != null) {
            this.setValues(values, defaultLocale);
        }
        this.setDataType((DataTypeInterface)new StringType());
    }

    @Override
    public String getDefinitionElementName() {
        return "StaticValueProvider";
    }

    public void setValuesAsLabel(boolean valuesAsLabel) {
        this.useValueAsLabel = valuesAsLabel;
    }

    public boolean getValuesAsLabel() {
        return this.useValueAsLabel;
    }

    public void setValueDisplayed(boolean displayValue) {
        this.displayValue = displayValue;
    }

    @Override
    public boolean isValueDisplayed() {
        return this.displayValue;
    }

    @Deprecated
    public void setQualifyLabelWithValue(boolean qualifyLabelWithValue) {
        this.setValueDisplayed(qualifyLabelWithValue);
    }

    @Deprecated
    public boolean isQualifyLabelWithValue() {
        return this.isValueDisplayed();
    }

    @Override
    public DataTypeInterface getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeInterface dataType) {
        if (dataType instanceof CollectionType) {
            throw new IllegalArgumentException("CollectionType is not allowed.");
        }
        this.dataType = dataType;
        String name = dataType.getClass().getName();
        int beginIndex = name.lastIndexOf(".");
        this.shortName = name.substring(beginIndex + 1);
    }

    @Override
    public Object getValues(Locale locale) throws ValueProviderException {
        List internalList = this.getInternalValues(locale);
        return ListFactory.newList((Collection)internalList);
    }

    private List getInternalValues(Locale locale) {
        List<ValueItem> internalList = Collections.EMPTY_LIST;
        if (this.localeToValueItemMap != null) {
            boolean found = false;
            if (this.localeToValueItemMap.containsKey(locale)) {
                internalList = this.localeToValueItemMap.get(locale);
                found = true;
            }
            if (!found && null != locale) {
                for (Map.Entry<Locale, List<ValueItem>> entry : this.localeToValueItemMap.entrySet()) {
                    if (entry.getKey() == null || !entry.getKey().getLanguage().equals(locale.getLanguage())) continue;
                    found = true;
                    internalList = entry.getValue();
                    this.getLogger2().debug("getInternalValues() using language locale:", locale.getLanguage());
                    break;
                }
            }
            if (!found && this.defaultLocale != null && this.localeToValueItemMap.containsKey(this.defaultLocale)) {
                internalList = this.localeToValueItemMap.get(this.defaultLocale);
                this.getLogger2().debug("getInternalValues() using default locale:", this.defaultLocale.toString());
                found = true;
            } else if (!found) {
                this.getLogger2().debug("getInternalValues() using first set of values.");
                Collection<List<ValueItem>> values = this.localeToValueItemMap.values();
                if (values != null && values.size() > 0) {
                    internalList = values.iterator().next();
                }
            }
        }
        return internalList;
    }

    public boolean removeValue(Object value, Locale locale) {
        List internalValues = this.getInternalValues(locale);
        return internalValues.remove(value);
    }

    @Override
    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        List returnList = Collections.EMPTY_LIST;
        if (count == 0) {
            return returnList;
        }
        List internalList = this.getInternalValues(locale);
        if (count == -1) {
            return ListFactory.newList((Collection)internalList);
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid Index specified");
        }
        if (count < 0) {
            count = 100;
        }
        returnList = ListFactory.newList(internalList.subList(index, Math.min(index + count, internalList.size())));
        return returnList;
    }

    public void setValues(List<ValueItem> valueItemList, Locale locale) {
        this.initLocaleToValuesMap();
        this.localeToValueItemMap.put(locale, valueItemList);
    }

    public String getLabelForValue(Object value, Locale locale) {
        try {
            List values = (List)this.getValues(locale);
            if (null != locale) {
                this.getLogger2().debug("getLabelForValue(): locale is ", locale.toString());
            }
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                ValueItem item = (ValueItem)values.get(i);
                if (null == item.getValue() || !item.getValue().equals(value)) continue;
                this.getLogger2().debug("Found ValueItem in list at ", Integer.toString(i));
                return item.getLabel().toString();
            }
        }
        catch (ValueProviderException valueProviderException) {
            // empty catch block
        }
        return null;
    }

    public Object getValueForLabel(String label, Locale locale) {
        try {
            List values = (List)this.getValues(locale);
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                ValueItem item = (ValueItem)values.get(i);
                if (item.getLabel() == null || !item.getLabel().equals(label)) continue;
                return item.getValue();
            }
        }
        catch (ValueProviderException valueProviderException) {
            // empty catch block
        }
        return null;
    }

    public void setValueForLabel(Object value, String label, Locale locale) {
        this.initLocaleToValuesMap();
        if (!this.localeToValueItemMap.containsKey(locale)) {
            this.localeToValueItemMap.put(locale, new ArrayList());
        }
        List<ValueItem> valueItemList = this.localeToValueItemMap.get(locale);
        int n = valueItemList.size();
        for (int i = 0; i < n; ++i) {
            ValueItem item = valueItemList.get(i);
            if (!item.getLabel().equals(label)) continue;
            item.setValue(value);
            return;
        }
        valueItemList.add(new ValueItem((Object)label, value));
    }

    protected void initLocaleToValuesMap() {
        if (this.localeToValueItemMap == null) {
            this.localeToValueItemMap = new LinkedHashMap<Locale, List<ValueItem>>();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StaticValueProvider clone = (StaticValueProvider)super.clone();
        if (this.localeToValueItemMap instanceof HashMap) {
            Map m = (Map)((HashMap)this.localeToValueItemMap).clone();
            Locale l = (Locale)this.defaultLocale.clone();
            clone.setValues((List)m.values(), l);
        }
        return clone;
    }

    final Map getUniqueValuesAsText() {
        if (null == this.uniqueValues) {
            int i;
            this.uniqueValues = new LinkedHashMap();
            this.initLocaleToValuesMap();
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            Collection<List<ValueItem>> col = this.localeToValueItemMap.values();
            for (List<ValueItem> internalList : col) {
                int n = internalList.size();
                for (i = 0; i < n; ++i) {
                    ValueItem item = internalList.get(i);
                    set.add(item.getValue());
                }
            }
            Iterator it = set.iterator();
            i = 0;
            while (it.hasNext()) {
                Object value = it.next();
                this.uniqueValues.put(value, Integer.toString(i));
                ++i;
            }
        }
        this.getLogger2().debug("Number of unique values:", Integer.toString(this.uniqueValues.size()));
        return this.uniqueValues;
    }

    final Map<Locale, Set<String>> getLabels() {
        HashMap<Locale, Set<String>> map = new HashMap<Locale, Set<String>>();
        this.initLocaleToValuesMap();
        Set<Locale> col = this.localeToValueItemMap.keySet();
        Iterator iter = col.iterator();
        String out = null;
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                LinkedHashSet<String> set = null;
                List<ValueItem> internalList = this.localeToValueItemMap.get(locale);
                Iterator<ValueItem> it = internalList.iterator();
                if (it.hasNext()) {
                    set = new LinkedHashSet<String>();
                    while (it.hasNext()) {
                        ValueItem item = it.next();
                        out = item.getLabel();
                        set.add(out);
                    }
                }
                map.put(locale, set);
            }
        }
        this.getLogger2().debug("Number of label sets:", Integer.toString(map.size()));
        return map;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.getLogger2().debug("consumeRelObjects, setting labels and values.");
        ArrayList labelsList = roHolder.consumeObjects("Labels");
        ArrayList valuesList = roHolder.consumeObjects("Values");
        this.processValuesLabels(valuesList, labelsList);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setValueDisplayed(provider.consumeBooleanAttr("valueDisplayed", false));
        String dtString = provider.consumeAttr("dataType");
        if (null != dtString) {
            this.getLogger2().debug("consumeAttributes(), make dataType:", dtString);
            this.setDataType(PersistenceFactory.newDataType(dtString));
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr(element, "dataType", this.shortName);
        XmlUtil.setBooleanAttr(element, "valueDisplayed", this.isValueDisplayed(), false);
        if (this.localeToValueItemMap != null && !this.localeToValueItemMap.isEmpty()) {
            this.getLogger2().debug("Writing values list.");
            List list = this.getWritableValues();
            StaticValueProvider.writeRelatedObjects(list, element, writingContext, "Values");
            this.getLogger2().debug("Writing labels.");
            List list2 = this.getWritableLabels();
            this.uniqueValues = null;
            StaticValueProvider.writeRelatedObjects(list2, element, writingContext, "Labels");
        }
    }

    final void processValuesLabels(List valuesList, List labelsList) {
        HashMap<String, BasePersistedValue> valuesMap = new HashMap<String, BasePersistedValue>();
        for (BasePersistedValue valueObj : valuesList) {
            valuesMap.put(valueObj.getIndex(), valueObj);
        }
        for (LocalizedLabels element : labelsList) {
            Locale locale = element.getLocale();
            Map<String, String> labelsMap = element.getLabelsMap();
            LinkedList<ValueItem> link = new LinkedList<ValueItem>();
            for (String label : labelsMap.keySet()) {
                String index = labelsMap.get(label);
                Object value = valuesMap.get(index);
                if (value instanceof BasePersistedValue) {
                    value = ((BasePersistedValue)value).getValue();
                }
                ValueItem item = new ValueItem();
                item.setLabel(label);
                item.setValue(value);
                link.add(item);
            }
            this.setValues(link, locale);
        }
    }

    final List getWritableValues() {
        ArrayList<BasePersistedValue> list = new ArrayList<BasePersistedValue>();
        Map map = this.getUniqueValuesAsText();
        for (Object value : map.keySet()) {
            String index = (String)map.get(value);
            try {
                BasePersistedValue t = PersistenceFactory.newPersistedValue(this.shortName, null);
                t.setIndex(index);
                t.setValue(value);
                list.add(t);
            }
            catch (ClassNotFoundException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
            catch (NullPointerException e) {
                this.getLogger2().error("No persisted value can be obtained for " + this.shortName);
            }
        }
        return list;
    }

    final List getWritableLabels() {
        ArrayList<LocalizedLabels> list = new ArrayList<LocalizedLabels>();
        Map<Locale, Set<String>> map = this.getLabels();
        Iterator<Locale> iter = map.keySet().iterator();
        Map uniqueValuesAsText = this.getUniqueValuesAsText();
        while (iter.hasNext()) {
            Locale locale = iter.next();
            LinkedHashSet items = (LinkedHashSet)map.get(locale);
            if (null == items || items.isEmpty()) continue;
            LinkedHashMap<String, String> indexLabelMap = new LinkedHashMap<String, String>();
            for (String label : items) {
                Object value = this.getValueForLabel(label, locale);
                String valueIndex = (String)uniqueValuesAsText.get(value);
                indexLabelMap.put(label, valueIndex);
            }
            LocalizedLabels t = new LocalizedLabels();
            t.setLocale(locale);
            t.setLabelsMap(indexLabelMap);
            list.add(t);
        }
        return list;
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, index, count);
    }

    public Collection getLocales() {
        List locales = ListFactory.newList(this.localeToValueItemMap.keySet());
        return locales;
    }

    @Override
    public final PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = new PropertyList();
        List labels = this.getWritableLabels();
        if (!labels.isEmpty()) {
            this.getLogger2().debug("getLocalizableProperties(), this value provider contains some labels.");
        }
        LocalizedLabels elem2 = null;
        for (LocalizedLabels elem2 : labels) {
            if (elem2.getLocale() != null && elem2.isEquivalentLocale(locale)) {
                this.getLogger2().debug("Found labels for the requested locale of", locale.toString());
                break;
            }
            elem2 = null;
        }
        if (null != elem2) {
            Map<String, String> map = elem2.getLabelsMap();
            int i = 0;
            if (!map.isEmpty()) {
                list.addComment("these are really labels, not values");
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                PropertyList subList = new PropertyList();
                subList.addProperty(entry.getValue(), entry.getKey());
                list.addProperty("value", i, subList);
                this.getLogger2().debug("Added property to list:", entry.getKey());
                ++i;
            }
            this.getLogger2().debug("Returning PropertyList of size", Integer.toString(map.size()));
        } else {
            this.getLogger2().warn("getLocalizableProperties(), no labels matching the supplied locale were found.", locale.toString());
        }
        return list;
    }

    @Override
    public final void setLocalizableProperties(Locale locale, PropertyMap map) {
        this.initLocaleToValuesMap();
        if (map.containsIndexedNestedProperty("value") || map.containsIndexedProperty("value")) {
            List valuesUS = this.getInternalValues(Locale.US);
            if (valuesUS.equals(Collections.EMPTY_LIST)) {
                throw new IllegalStateException("Some values must exist before StaticValuesProvider.setLocalizableProperties() will work.");
            }
            this.getLogger2().debug("setLocalizableProperties(), adding the following for", locale.toString());
            LinkedList<ValueItem> internalList = new LinkedList<ValueItem>();
            if (map.containsIndexedNestedProperty("value")) {
                int[] indexes = map.getNestedPropertyIndexes("value");
                for (int i = 0; i < indexes.length; ++i) {
                    if (!map.containsIndexedNestedProperty("value", i)) continue;
                    ValueItem item = new ValueItem();
                    PropertyMap subMap = map.getNestedProperties("value", i);
                    Iterator<String> it = subMap.getPropertyIterator();
                    item.setValue(((ValueItem)valuesUS.get(i)).getValue());
                    item.setLabel(subMap.getProperty(it.next()));
                    this.getLogger2().debug(Integer.toString(i), item.getLabel());
                    internalList.add(item);
                }
            } else if (map.containsIndexedProperty("value")) {
                this.getLogger2().debug("setLocalizableProperties running for ", locale.toString());
                this.getLogger2().debug("pre-S0448424 compatibility-mode");
                int[] indexes = map.getPropertyIndexes("value");
                for (int i = 0; i < indexes.length; ++i) {
                    if (!map.containsIndexedProperty("value", i)) continue;
                    ValueItem item = new ValueItem();
                    item.setValue(((ValueItem)valuesUS.get(i)).getValue());
                    item.setLabel(map.getProperty("value", i));
                    this.getLogger2().debug(item.getLabel(), Integer.toString(i));
                    internalList.add(item);
                }
            }
            this.setValues(internalList, locale);
        }
    }

    @Override
    public final PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    @Override
    public final void setLocalizableProperties(PropertyMap map) {
        this.getLogger2().warn("setLocalizableProperties(map) is running with the default locale, so likely nothing will happen. Locale is: " + Locale.getDefault().toString());
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    @Override
    public void beginLocalization() {
    }

    @Override
    public void endLocalization() {
    }

    @Override
    public final Collection<ValueItem> search(List<ValueOperandV2Interface> values, Evaluator evaluator, Locale locale) {
        ArrayList<ValueOperandV2Interface> list = new ArrayList<ValueOperandV2Interface>();
        list.add(0, null);
        list.addAll(1, values);
        return this.searchAll(list, evaluator, locale);
    }

    @Override
    public final Collection<ValueItem> search(ValueOperandV2Interface value, Evaluator evaluator, Locale locale) {
        ArrayList<ValueOperandV2Interface> list = new ArrayList<ValueOperandV2Interface>();
        list.add(0, null);
        list.add(1, value);
        return this.searchAll(list, evaluator, locale);
    }

    private Collection<ValueItem> searchAll(List<ValueOperandV2Interface> list, Evaluator evaluator, Locale locale) {
        ValidateArg.notNull(list, (String)"list");
        ValidateArg.notNull((Object)evaluator, (String)"operator");
        ValidateArg.notNull((Object)locale, (String)"locale");
        ArrayList<ValueItem> retVal = new ArrayList<ValueItem>();
        List internal = this.getInternalValues(locale);
        for (Object listElement : internal) {
            ValueItem vi = (ValueItem)listElement;
            ValueOperandV2Interface v = (ValueOperandV2Interface)OperandFactory.newValueOperand(vi.getValue());
            list.set(0, v);
            if (!evaluator.evaluateOperandsAsBoolean(list, locale, Collections.EMPTY_MAP)) continue;
            retVal.add(vi);
        }
        return retVal;
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        if (options.containsKey("valueDisplayed")) {
            this.setValueDisplayed(AttributeConfigurationUtil.getBoolOption((String)"valueDisplayed", options, context));
        }
        if (options.containsKey("dataType")) {
            String dataTypeShortName = AttributeConfigurationUtil.getStringOption((String)"dataType", options, context);
            this.setDataType(PersistenceFactory.newDataType(dataTypeShortName));
        }
        List values = null;
        List labels = null;
        if (options.containsKey("_valueProvider." + StorageValueProviderConstants.values)) {
            values = (List)options.get("_valueProvider." + StorageValueProviderConstants.values);
        }
        if (options.containsKey("_valueProvider." + StorageValueProviderConstants.labels)) {
            labels = (List)options.get("_valueProvider." + StorageValueProviderConstants.labels);
        }
        if (values != null && labels == null || values == null && labels != null || values != null && labels != null && values.size() != labels.size()) {
            throw new IllegalArgumentException("The number of labels and values must match");
        }
        if (values != null && labels != null) {
            ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>(values.size());
            Iterator valueIterator = values.iterator();
            Iterator labelIterator = labels.iterator();
            while (valueIterator.hasNext()) {
                Object value = valueIterator.next();
                String label = (String)labelIterator.next();
                ValueItem valueItem = new ValueItem((Object)label, value);
                valueItemList.add(valueItem);
            }
            Locale locale = Locale.getDefault();
            if (context != null && context.containsKey("__SAS_Locale")) {
                locale = XmlUtil.xmlToLocale((String)context.get("__SAS_Locale"));
            }
            this.setValues(valueItemList, locale);
        }
    }
}

