/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.BaseOperator;
import com.sas.storage.simplesqlmodel.Evaluator;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WhereClause
extends AbstractPersistence
implements ResourceReferencesInterface,
Evaluator {
    private OperandInterface condition;

    public OperandInterface getCondition() {
        return this.condition;
    }

    public void setCondition(OperandInterface expression) {
        this.condition = expression;
        if (null != this.condition) {
            this.getLogger2().debug("condition set to:", this.condition.toString());
        }
    }

    public String getWhereClause(Map context) {
        if (this.condition != null) {
            String conditionString = this.condition.getOperandAsString(context);
            StringBuffer clause = new StringBuffer(conditionString.length() + 6);
            clause.append(" where ");
            clause.append(conditionString);
            this.getLogger2().debug("getWhereClause()", conditionString);
            return clause.toString();
        }
        return "";
    }

    @Override
    public boolean evaluateOperandsAsBoolean(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        if (list != null) {
            list = BaseOperator.expandOperandsInList(list, context);
        }
        if (this.condition instanceof Expression) {
            return ((Expression)this.condition).evaluateOperandsAsBoolean(list, locale, context);
        }
        if (this.condition instanceof ValueOperandV2Interface) {
            return ((ValueOperandV2Interface)((Object)this.condition)).evaluateOperandAsBoolean(locale, context);
        }
        return false;
    }

    @Override
    public Object evaluateOperands(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        return this.evaluateOperandsAsBoolean(list, locale, context);
    }

    @Override
    public String getDefinitionElementName() {
        return "WhereClause";
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Operand");
        if (!list.isEmpty()) {
            OperandInterface operand = (OperandInterface)list.get(0);
            this.setCondition(operand);
            this.getLogger2().debug("consumeRelObjects, setCondition() to ", operand.toString());
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.condition) {
            this.getLogger2().debug("Writing condition field.");
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
            list.add((PersistenceInterface)((Object)this.condition));
            WhereClause.writeRelatedObjects(list, element, writingContext, "Operand");
        }
    }

    public List getReferencedResources(Class arg0, boolean arg1) {
        if (null != this.condition && arg1 && this.condition instanceof ResourceReferencesInterface) {
            return ((ResourceReferencesInterface)this.condition).getReferencedResources(arg0, arg1);
        }
        return Collections.EMPTY_LIST;
    }
}

