/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.storage.simplesqlmodel.BaseValueOperand;
import com.sas.storage.simplesqlmodel.BooleanOperand;
import com.sas.storage.simplesqlmodel.DateOperand;
import com.sas.storage.simplesqlmodel.DoubleOperand;
import com.sas.storage.simplesqlmodel.IntegerOperand;
import com.sas.storage.simplesqlmodel.SpecialValueOperand;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.TimeOperand;
import com.sas.storage.simplesqlmodel.TimestampOperand;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.ValidateArg;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

@SASScope
public final class OperandFactory {
    public static ValueOperandInterface newValueOperand(Object value) {
        ValidateArg.notNull((Object)value, (String)"value");
        BaseValueOperand retVal = null;
        if (value instanceof String) {
            retVal = new StringOperand((String)value);
        } else if (value instanceof Integer) {
            retVal = new IntegerOperand((Integer)value);
        } else if (value instanceof Double) {
            retVal = new DoubleOperand((Double)value);
        } else if (value instanceof Boolean) {
            retVal = new BooleanOperand((Boolean)value);
        } else if (value instanceof Timestamp) {
            retVal = new TimestampOperand((Date)value);
        } else if (value instanceof Time) {
            retVal = new TimeOperand((Date)value);
        } else if (value instanceof Date) {
            retVal = new DateOperand((Date)value);
        } else if (value instanceof MissingValues) {
            new SpecialValueOperand(value);
        } else {
            throw new IllegalStateException("Unable to create operand from this: " + value);
        }
        return retVal;
    }

    public static ValueOperandInterface[] newValueOperandArray(DatePeriod value) {
        ValidateArg.notNull((Object)value, (String)"value");
        ValueOperandInterface[] retVal = new ValueOperandInterface[2];
        DateTypes periodType = value.getPeriodType();
        Date start = value.getStartOfPeriod();
        Date end = value.getEndOfPeriod();
        if (periodType == DateTypes.TIMESTAMP) {
            retVal[0] = new TimestampOperand(start);
            retVal[1] = new TimestampOperand(end);
        } else if (periodType == DateTypes.TIME || periodType == DateTypes.HOUR || periodType == DateTypes.MINUTE) {
            retVal[0] = new TimeOperand(start);
            retVal[1] = new TimeOperand(end);
        } else {
            retVal[0] = new DateOperand(start);
            retVal[1] = new DateOperand(end);
        }
        return retVal;
    }
}

