/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.storage.simplesqlmodel.BaseOperator;
import com.sas.storage.simplesqlmodel.BooleanOperand;
import com.sas.storage.simplesqlmodel.Evaluator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class FormattedOperator
extends BaseOperator
implements Evaluator {
    public static final OperandInterface NOT_FLAG_OPERAND = new StringOperand("Expression should be notted");
    public static final FormattedOperator BETWEEN_OPERATOR = new FormattedOperator("{0} BETWEEN {1} AND {2}", 3, 3);
    public static final FormattedOperator NOT_BETWEEN_OPERATOR = new FormattedOperator("NOT( {0} BETWEEN {1} AND {2} )", 3, 3);
    public static final FormattedOperator BETWEEN_OPERATOR_EXCLUSIVE = new FormattedOperator("(({0} > {1}) AND ({0} < {2}))", 3, 3);
    public static final FormattedOperator NOT_BETWEEN_OPERATOR_INCLUSIVE = new FormattedOperator("(({0} <= {1}) OR ({0} >= {2}))", 3, 3);
    public static final FormattedOperator IS_NULL_OPERATOR = new FormattedOperator("{0} IS NULL", 1, 1);
    public static final FormattedOperator AND_OPERATOR = new FormattedOperator("(({0}) AND ({1}))", 2, 2);
    public static final FormattedOperator OR_OPERATOR = new FormattedOperator("(({0}) OR ({1}))", 2, 2);
    public static final FormattedOperator EQUAL_OPERATOR = new FormattedOperator("{0} = {1}", 2, 2, "{0} is null", null);
    public static final FormattedOperator LESS_THAN_OPERATOR = new FormattedOperator("{0} < {1}", 2, 2);
    public static final FormattedOperator GREATER_THAN_OPERATOR = new FormattedOperator("{0} > {1}", 2, 2);
    public static final FormattedOperator LESS_THAN_EQUAL_OPERATOR = new FormattedOperator("{0} <= {1}", 2, 2);
    public static final FormattedOperator GREATER_THAN_EQUAL_OPERATOR = new FormattedOperator("{0} >= {1}", 2, 2);
    public static final FormattedOperator NOT_EQUAL_OPERATOR = new FormattedOperator("{0} <> {1}", 2, 2);
    public static final FormattedOperator LIKE_OPERATOR = new FormattedOperator("{0} LIKE {1}", 2, 2, "{0} is null", null, true);
    public static final FormattedOperator CONTAINS_OPERATOR = new FormattedOperator("{0} CONTAINS {1}", 2, 2, "{0} is null", null, true);
    public static final FormattedOperator LESS_THAN_DATE_START_OPERATOR = new FormattedOperator("{0} < {1}", 3, 3);
    public static final FormattedOperator GREATER_THAN_EQUAL_DATE_START_OPERATOR = new FormattedOperator("{0} >= {1}", 3, 3);
    public static final FormattedOperator LESS_THAN_EQUAL_DATE_END_OPERATOR = new FormattedOperator("{0} <= {2}", 3, 3);
    public static final FormattedOperator GREATER_THAN_DATE_END_OPERATOR = new FormattedOperator("{0} > {2}", 3, 3);
    public static final FormattedOperator NOT_OPERATOR = new FormattedOperator("NOT({0})", 1, 1);
    public static final FormattedOperator ANY_OPERATOR = new FormattedOperator("ANY {0}", 1, 1);
    public static final FormattedOperator ALL_OPERATOR = new FormattedOperator("ALL {0}", 1, 1);
    public static final FormattedOperator SOME_OPERATOR = new FormattedOperator("SOME {0}", 1, 1);
    public static final FormattedOperator IN_OPERATOR = new FormattedOperator("{0} IN ({1})", 1, -1, ", ");
    public static final FormattedOperator AVG_OPERATOR = new FormattedOperator("AVG({0})", 1, 1);
    public static final FormattedOperator PUT_OPERATOR = new FormattedOperator("PUT({0}, {1})", 2, 2);
    public static final FormattedOperator UPCASE_OPERATOR = new FormattedOperator("UPCASE ({0})", 1, 1);
    public static final FormattedOperator TRIM_OPERATOR = new FormattedOperator("TRIM ({0})", 1, 1);
    private static Map<String, FormattedOperator> operatorMap = null;
    private String format;
    private int fixedOperandCount;
    private int maxOperandCount;
    private String separator;
    private String charMissingFormat;
    private String numericMissingFormat;
    private boolean trimStringOperands;

    public static Map<String, FormattedOperator> getOperatorMap() {
        if (operatorMap == null) {
            HashMap<String, FormattedOperator> map = new HashMap<String, FormattedOperator>();
            map.put("All", ALL_OPERATOR);
            map.put("And", AND_OPERATOR);
            map.put("Any", ANY_OPERATOR);
            map.put("AVG", AVG_OPERATOR);
            map.put("Between", BETWEEN_OPERATOR);
            map.put("NotBetween", NOT_BETWEEN_OPERATOR_INCLUSIVE);
            map.put("BetweenExclusive", BETWEEN_OPERATOR_EXCLUSIVE);
            map.put("NotBetweenExclusive", NOT_BETWEEN_OPERATOR);
            map.put("Contains", CONTAINS_OPERATOR);
            map.put("Equal", EQUAL_OPERATOR);
            map.put("GreaterThan", GREATER_THAN_OPERATOR);
            map.put("GreaterThanEqual", GREATER_THAN_EQUAL_OPERATOR);
            map.put("GreaterThanDateEnd", GREATER_THAN_DATE_END_OPERATOR);
            map.put("GreaterThanEqualDateStart", GREATER_THAN_EQUAL_DATE_START_OPERATOR);
            map.put("In", IN_OPERATOR);
            map.put("IsNull", IS_NULL_OPERATOR);
            map.put("LessThan", LESS_THAN_OPERATOR);
            map.put("LessThanEqual", LESS_THAN_EQUAL_OPERATOR);
            map.put("LessThanDateStart", LESS_THAN_DATE_START_OPERATOR);
            map.put("LessThanEqualDateEnd", LESS_THAN_EQUAL_DATE_END_OPERATOR);
            map.put("Like", LIKE_OPERATOR);
            map.put("NotEqual", NOT_EQUAL_OPERATOR);
            map.put("Or", OR_OPERATOR);
            map.put("Put", PUT_OPERATOR);
            map.put("Some", SOME_OPERATOR);
            map.put("UPCASE", UPCASE_OPERATOR);
            map.put("TRIM", TRIM_OPERATOR);
            operatorMap = map;
        }
        return operatorMap;
    }

    public static List getNumericComparisonOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"=", (Object)EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)">", (Object)GREATER_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<", (Object)LESS_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)">=", (Object)GREATER_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<=", (Object)LESS_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"!=", (Object)NOT_EQUAL_OPERATOR));
        return valueItemList;
    }

    public static List getCharComparisonOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"Contains", (Object)CONTAINS_OPERATOR));
        valueItemList.add(new ValueItem((Object)"Equal", (Object)EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"Like", (Object)LIKE_OPERATOR));
        valueItemList.add(new ValueItem((Object)"Not Equal", (Object)NOT_EQUAL_OPERATOR));
        return valueItemList;
    }

    public static List getRangeOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"Between (inclusive)", (Object)BETWEEN_OPERATOR));
        valueItemList.add(new ValueItem((Object)"Not between (inclusive)", (Object)NOT_BETWEEN_OPERATOR_INCLUSIVE));
        valueItemList.add(new ValueItem((Object)"Between (exclusive)", (Object)BETWEEN_OPERATOR_EXCLUSIVE));
        valueItemList.add(new ValueItem((Object)"Not between (exclusive)", (Object)NOT_BETWEEN_OPERATOR));
        return valueItemList;
    }

    public static List getIQSupportedRangeOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"Between (inclusive)", (Object)BETWEEN_OPERATOR));
        valueItemList.add(new ValueItem((Object)"Not between (inclusive)", (Object)NOT_BETWEEN_OPERATOR_INCLUSIVE));
        return valueItemList;
    }

    public FormattedOperator() {
    }

    public FormattedOperator(String format, int fixedOperandCount, int maxOperandCount, String separator) {
        this.format = format;
        this.fixedOperandCount = fixedOperandCount;
        this.maxOperandCount = maxOperandCount;
        this.separator = separator;
    }

    public FormattedOperator(String format, int fixedOperandCount, int maxOperandCount) {
        this(format, fixedOperandCount, maxOperandCount, null);
    }

    public FormattedOperator(String format, int fixedOperandCount, int maxOperandCount, String charMissingFormat, String numericMissingFormat) {
        this(format, fixedOperandCount, maxOperandCount, null);
        this.charMissingFormat = charMissingFormat;
        this.numericMissingFormat = numericMissingFormat;
    }

    public FormattedOperator(String format, int fixedOperandCount, int maxOperandCount, String charMissingFormat, String numericMissingFormat, boolean trimStringOperands) {
        this(format, fixedOperandCount, maxOperandCount, charMissingFormat, numericMissingFormat);
        this.trimStringOperands = trimStringOperands;
    }

    public String getFormat() {
        return this.format;
    }

    public String getCharMissingValueFormat() {
        if (this.charMissingFormat != null) {
            return this.charMissingFormat;
        }
        return this.getFormat();
    }

    public String getNumericMissingValueFormat() {
        if (this.numericMissingFormat != null) {
            return this.numericMissingFormat;
        }
        return this.getFormat();
    }

    public int getMaxOperandCount() {
        return this.maxOperandCount;
    }

    public int getFixedOperandCount() {
        return this.fixedOperandCount;
    }

    @Override
    public String formatOperands(List operands, Map context) {
        int operandCount;
        ValidateArg.notNull((Object)operands, (String)"operands");
        ValidateArg.notNull((Object)context, (String)"context");
        operands = this.expandOperands(operands, context);
        if (this.getFixedOperandCount() > operands.size()) {
            throw new IllegalStateException("Too few operands.  Expecting " + this.fixedOperandCount);
        }
        if (FormattedOperator.isAllOperandInList(operands)) {
            return "1";
        }
        if (FormattedOperator.isOtherOperandInList(operands)) {
            return "0";
        }
        boolean isMissingCharOperandPresent = FormattedOperator.isMissingValueOperandInList(operands);
        boolean nottedOperandPresent = FormattedOperator.isNotFlagOperandInList(operands);
        HashMap tempContext = context;
        if (context != null && this.trimStringOperands) {
            tempContext = new HashMap(context.size());
            tempContext.putAll(context);
            tempContext.put("_SAS_CONTEXT_TRIM_STRINGS", Boolean.TRUE);
        }
        if ((operandCount = this.getMaxOperandCount()) == -1) {
            operandCount = this.getFixedOperandCount() + 1;
        }
        Object[] formattedOperands = new Object[operandCount];
        int n = this.fixedOperandCount;
        for (int i = 0; i < n; ++i) {
            OperandInterface operand = (OperandInterface)operands.get(i);
            formattedOperands[i] = operand.getOperandAsString(tempContext);
        }
        if (this.getMaxOperandCount() == -1) {
            StringBuffer variableOperandString = new StringBuffer();
            int n2 = operands.size();
            for (int i = this.getFixedOperandCount(); i < n2; ++i) {
                OperandInterface operand = (OperandInterface)operands.get(i);
                variableOperandString.append(operand.getOperandAsString(tempContext));
                if (i >= n2 - 1) continue;
                variableOperandString.append(this.separator);
            }
            formattedOperands[operandCount - 1] = variableOperandString.toString();
        }
        String output = isMissingCharOperandPresent ? MessageFormat.format(this.getCharMissingValueFormat(), formattedOperands) : MessageFormat.format(this.getFormat(), formattedOperands);
        if (nottedOperandPresent) {
            StringOperand toBeNottedOperand = new StringOperand(output, false);
            ArrayList<StringOperand> toBeNottedOperands = new ArrayList<StringOperand>(1);
            toBeNottedOperands.add(toBeNottedOperand);
            output = NOT_OPERATOR.formatOperands(toBeNottedOperands, tempContext);
        }
        return output;
    }

    public final String getSeparator() {
        return this.separator;
    }

    static boolean isAllOperandInList(List operands) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Object value;
            OperandInterface operand = (OperandInterface)operands.get(i);
            if (!(operand instanceof ValueOperandInterface) || (value = ((ValueOperandInterface)((Object)operand)).getValue()) != SpecialValues.ALL) continue;
            return true;
        }
        return false;
    }

    static boolean isOtherOperandInList(List operands) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Object value;
            OperandInterface operand = (OperandInterface)operands.get(i);
            if (!(operand instanceof ValueOperandInterface) || (value = ((ValueOperandInterface)((Object)operand)).getValue()) != SpecialValues.OTHER) continue;
            return true;
        }
        return false;
    }

    static boolean isMissingValueOperandInList(List operands) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Object value;
            OperandInterface operand = (OperandInterface)operands.get(i);
            if (!(operand instanceof ValueOperandInterface) || (value = ((ValueOperandInterface)((Object)operand)).getValue()) != MissingValues._BLANK_) continue;
            return true;
        }
        return false;
    }

    static boolean isNotFlagOperandInList(List operands) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            OperandInterface operand = (OperandInterface)operands.get(i);
            if (operand != NOT_FLAG_OPERAND) continue;
            operands.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public String getDefinitionElementName() {
        return "FormattedOperator";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.format = provider.consumeAttr("format");
        this.separator = provider.consumeAttr("separator");
        this.fixedOperandCount = provider.consumeIntAttr("fixedOperandCount", -1);
        this.maxOperandCount = provider.consumeIntAttr("maxOperandCount", -1);
        this.charMissingFormat = provider.consumeAttr("charMisingValueFormat");
        this.getLogger2().debug("Ran consumeAttributes().");
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getFormat()) {
            XmlUtil.setAttr(element, "format", this.getFormat());
        }
        if (null != this.separator) {
            XmlUtil.setAttr(element, "separator", this.separator);
        }
        XmlUtil.setIntAttr(element, "fixedOperandCount", this.getFixedOperandCount());
        XmlUtil.setIntAttr(element, "maxOperandCount", this.getMaxOperandCount());
        if (null != this.charMissingFormat) {
            XmlUtil.setAttr(element, "charMisingValueFormat", this.getCharMissingValueFormat());
        }
    }

    @Override
    public boolean evaluateOperandsAsBoolean(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        ValidateArg.notNull(list, (String)"list");
        CommonLoggerInterface logger = this.getLogger2();
        ValueOperandV2Interface v0 = list.get(0);
        ValueOperandV2Interface v1 = list.get(1);
        if (null == v0.getValue() || null == v1.getValue()) {
            logger.error("One of the supplied ValueOperands contained a null value.");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
            logger.debug("Evaluate this:", v0.getValue().toString());
            logger.debug("Against this:", v1.getValue().toString());
        }
        if (v0.getClass() != v1.getClass()) {
            logger.debug("Operands are different classes so return false.");
            return false;
        }
        if (list.size() == 2) {
            if (this == EQUAL_OPERATOR && v0.compareTo(v1, locale) == 0) {
                logger.debug("Equals test returns true");
                return true;
            }
            if (this == NOT_EQUAL_OPERATOR && v0.compareTo(v1, locale) != 0) {
                logger.debug("Not equals test returns true.");
                return true;
            }
            if ((this == GREATER_THAN_OPERATOR || this == GREATER_THAN_DATE_END_OPERATOR) && v0.compareTo(v1, locale) == 1) {
                logger.debug("'Greater than' test returns true.");
                return true;
            }
            if ((this == LESS_THAN_OPERATOR || this == LESS_THAN_DATE_START_OPERATOR) && v0.compareTo(v1, locale) == -1) {
                logger.debug("'Less than' test returns true.");
                return true;
            }
            if ((this == LESS_THAN_EQUAL_OPERATOR || this == LESS_THAN_EQUAL_DATE_END_OPERATOR) && v0.compareTo(v1, locale) <= 0) {
                logger.debug("'Less than-Equal' test returns true.");
                return true;
            }
            if ((this == GREATER_THAN_EQUAL_OPERATOR || this == GREATER_THAN_EQUAL_DATE_START_OPERATOR) && v0.compareTo(v1, locale) >= 0) {
                logger.debug("'Greater than-Equal' test returns true.");
                return true;
            }
            if (this == LIKE_OPERATOR && v0 instanceof StringOperand && ((String)v1.getValue()).indexOf((String)v0.getValue()) >= 0) {
                logger.debug("Like test returns true");
                return true;
            }
            if (this == AND_OPERATOR && v0 instanceof BooleanOperand && v1 instanceof BooleanOperand) {
                boolean b0 = ((BooleanOperand)v0).getValueAsBoolean();
                boolean b1 = ((BooleanOperand)v1).getValueAsBoolean();
                return b0 && b1;
            }
            if (this == OR_OPERATOR && v0 instanceof BooleanOperand && v1 instanceof BooleanOperand) {
                boolean b0 = ((BooleanOperand)v0).getValueAsBoolean();
                boolean b1 = ((BooleanOperand)v1).getValueAsBoolean();
                return b0 || b1;
            }
        }
        if (list.size() == 3) {
            ValueOperandInterface v2 = list.get(2);
            if (null == v2.getValue()) {
                logger.error("One of the supplied ValueOperands contained a null value.");
                return false;
            }
            logger.debug("And against this:", v2.getValue().toString());
            if (this == BETWEEN_OPERATOR && v0.compareTo(v1, locale) >= 0 && v0.compareTo(v2, locale) <= 0) {
                logger.debug("Between test returns true.");
                return true;
            }
            if (this == NOT_BETWEEN_OPERATOR && (v0.compareTo(v1, locale) == -1 || v0.compareTo(v2, locale) == 1)) {
                logger.debug("Not-Between test returns true.");
                return true;
            }
            if (this == BETWEEN_OPERATOR_EXCLUSIVE && v0.compareTo(v1, locale) == 1 && v0.compareTo(v2, locale) == -1) {
                logger.debug("Between-exclusive test returns true.");
                return true;
            }
            if (this == NOT_BETWEEN_OPERATOR_INCLUSIVE && (v0.compareTo(v1, locale) <= 0 || v0.compareTo(v2, locale) >= 0)) {
                logger.debug("Not-Between Inclusive returns true.");
                return true;
            }
        }
        return false;
    }

    @Override
    public Object evaluateOperands(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        if (this == NOT_OPERATOR) {
            ValueOperandV2Interface v0 = list.get(0);
            return !v0.evaluateOperandAsBoolean(locale, context);
        }
        return this.evaluateOperandsAsBoolean(list, locale, context);
    }

    public String toString() {
        return this.format;
    }
}

