/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.PublicClonable;
import com.sas.storage.simplesqlmodel.BooleanOperand;
import com.sas.storage.simplesqlmodel.Evaluator;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.OperatorFactory;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Expression
extends AbstractPersistence
implements OperandInterface,
PublicClonable,
ResourceReferencesInterface,
Evaluator {
    private List operands;
    private OperatorInterface operator;

    public Expression() {
        this.operands = new ArrayList(2);
    }

    public Expression(OperatorInterface operator, OperandInterface leftSide, OperandInterface rightSide) {
        this.operator = operator;
        this.operands = new ArrayList(2);
        this.addOperand(leftSide);
        this.addOperand(rightSide);
    }

    public Expression(OperatorInterface operator, List operands) {
        this.operator = operator;
        this.operands = new ArrayList(operands.size());
        this.operands.addAll(operands);
    }

    @Override
    public String getDefinitionElementName() {
        return "Expression";
    }

    public OperatorInterface getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorInterface operator) {
        this.operator = operator;
        if (null != this.operator) {
            this.getLogger2().debug("setOperator to:", this.operator.toString());
        }
    }

    @Override
    public String getOperandAsString(Map context) {
        String retVal = null;
        if (null != this.operator) {
            retVal = this.operator.formatOperands(this.operands, context);
            this.getLogger2().debug("Operand string is:", retVal);
        }
        return retVal;
    }

    public List getOperands() {
        return this.operands;
    }

    public void setOperands(List operands) {
        this.operands = operands;
    }

    public void addOperand(OperandInterface operand) {
        this.operands.add(operand);
        if (null != operand) {
            this.getLogger2().debug("addOperand() for:", operand.toString());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Expression clone = (Expression)super.clone();
        clone.operands = (List)((ArrayList)this.operands).clone();
        clone.operator = this.operator;
        return clone;
    }

    public String toString() {
        return "Expression with operands size= " + this.operands.size();
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.getLogger2().debug("consumeRelObjects, ");
        ArrayList list = roHolder.consumeObjects("Operands");
        if (!list.isEmpty()) {
            Iterator iter = list.iterator();
            this.operands = new ArrayList(list.size());
            this.getLogger2().debug("consuming Operands:", Integer.toString(list.size()));
            while (iter.hasNext()) {
                OperandInterface operand = (OperandInterface)iter.next();
                this.operands.add(operand);
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String operatorString = provider.consumeAttr("operator");
        if (operatorString != null) {
            OperatorInterface operatorObj = OperatorFactory.getOperatorByType(operatorString);
            this.setOperator(operatorObj);
        } else {
            this.getLogger2().debug("consumeAttributes: no operator for expression");
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (this.operator != null) {
            String operatorString = OperatorFactory.getOperatorType(this.operator);
            if (operatorString != null) {
                XmlUtil.setAttr(element, "operator", operatorString);
            } else {
                this.getLogger2().debug("writeDefinition: operator not converted to simple string");
            }
        }
        if (!this.operands.isEmpty()) {
            this.getLogger2().debug("Writing operands.");
            Expression.writeRelatedObjects(this.operands, element, writingContext, "Operands");
        }
    }

    public static final Expression newAndedExpression(List input, LoggerFactoryInterface factory) {
        ValidateArg.notNull((Object)input, (String)"input");
        CommonLoggerInterface logger = LoggerRepository2.getLogger(Expression.class.getName(), factory);
        Expression andExp = null;
        Expression[] expArray = new Expression[input.size()];
        logger.debug("Size of input list:", Integer.toString(input.size()));
        if (input.size() < 2) {
            throw new IllegalStateException("Size of input list was less than 2.");
        }
        for (int i = 0; i < input.size(); ++i) {
            OperandInterface element = (OperandInterface)input.get(i);
            if (!(element instanceof Expression)) continue;
            if (i == 0) {
                andExp = Expression.newExpression(factory);
                andExp.addOperand(element);
                continue;
            }
            if (i == 1) {
                andExp.addOperand(element);
                expArray[i] = andExp;
                continue;
            }
            expArray[i] = Expression.newExpression(factory);
            expArray[i].addOperand(expArray[i - 1]);
            expArray[i].addOperand(element);
        }
        return expArray[input.size() - 1];
    }

    public static final List getListFromAndedExpression(Expression input, LoggerFactoryInterface factory) {
        ArrayList retVal = new ArrayList();
        ValidateArg.notNull((Object)input, (String)"input");
        CommonLoggerInterface logger = LoggerRepository2.getLogger(Expression.class.getName(), factory);
        Expression.process(retVal, input, logger);
        return retVal;
    }

    private static void processTwo(List masterList, Expression input, CommonLoggerInterface logger) {
        if (input.getOperands().size() == 2 && input.getOperator().equals(FormattedOperator.AND_OPERATOR)) {
            OperandInterface op1;
            List list = input.getOperands();
            OperandInterface op0 = (OperandInterface)list.get(0);
            if (op0 instanceof Expression) {
                Expression.process(masterList, (Expression)op0, logger);
            }
            if ((op1 = (OperandInterface)list.get(1)) instanceof Expression) {
                Expression.process(masterList, (Expression)op1, logger);
            }
        } else {
            masterList.add(input);
            logger.debug("Returning list with just input Expression because there are not 2 operands.", Integer.toString(input.getOperands().size()));
        }
    }

    private static void process(List list, Expression expression, CommonLoggerInterface logger) {
        if (null != expression.getOperator() && expression.getOperator().equals(FormattedOperator.AND_OPERATOR)) {
            logger.debug("process()- Found expression with AND_Operator", expression.toString());
            Expression.processTwo(list, expression, logger);
        } else if (null != expression.getOperator() && !expression.getOperator().equals(FormattedOperator.OR_OPERATOR)) {
            logger.debug("process()- Found expression without OR_Operator", expression.toString());
            list.add(expression);
        }
    }

    private static Expression newExpression(LoggerFactoryInterface factory) {
        Expression andExp = new Expression();
        andExp.setOperator(FormattedOperator.AND_OPERATOR);
        return andExp;
    }

    public List getReferencedResources(Class type, boolean recursive) {
        if (recursive) {
            ArrayList retVal = new ArrayList();
            for (OperandInterface element : this.operands) {
                if (!(element instanceof ResourceReferencesInterface)) continue;
                retVal.addAll(((ResourceReferencesInterface)element).getReferencedResources(type, recursive));
            }
            return retVal;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean evaluateOperandsAsBoolean(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        boolean result = false;
        if (this.operator == FormattedOperator.AND_OPERATOR || this.operator == FormattedOperator.OR_OPERATOR) {
            FormattedOperator formattedOperator = (FormattedOperator)this.operator;
            if (this.operator == FormattedOperator.AND_OPERATOR) {
                result = true;
            } else if (this.operator == FormattedOperator.OR_OPERATOR) {
                result = false;
            }
            ArrayList<ValueOperandV2Interface> resultOperands = new ArrayList<ValueOperandV2Interface>(2);
            for (Object operandObject : this.operands) {
                boolean partialResult;
                if (operandObject instanceof Expression) {
                    Expression operandExpression = (Expression)operandObject;
                    partialResult = operandExpression.evaluateOperandsAsBoolean(operandExpression.getOperands(), locale, context);
                } else if (operandObject instanceof BooleanOperand) {
                    partialResult = ((BooleanOperand)operandObject).getValueAsBoolean();
                } else {
                    partialResult = false;
                    this.getLogger2().debug("Unsupported operand:", operandObject.toString());
                }
                resultOperands.clear();
                resultOperands.add(new BooleanOperand(result));
                resultOperands.add(new BooleanOperand(partialResult));
                result = formattedOperator.evaluateOperandsAsBoolean(resultOperands, locale, context);
            }
        } else if (this.operator instanceof FormattedOperator) {
            List expandedOperands = ((FormattedOperator)this.operator).expandOperands(this.operands, context);
            result = ((FormattedOperator)this.operator).evaluateOperandsAsBoolean(expandedOperands, locale, context);
        } else {
            result = false;
            this.getLogger2().debug("Unsupported operator:", this.operator.toString());
        }
        return result;
    }

    @Override
    public Object evaluateOperands(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        return this.evaluateOperandsAsBoolean(list, locale, context);
    }
}

