/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.BaseValueOperand;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import java.util.Locale;
import java.util.Map;

public class DoubleOperand
extends BaseValueOperand {
    public DoubleOperand() {
        this(0.0);
    }

    public DoubleOperand(double value) {
        this.setValue(value);
    }

    @Override
    public String getOperandAsString(Map context) {
        return "" + this.getValue();
    }

    public double getValueAsDouble() {
        Double d = (Double)this.getValue();
        return d;
    }

    public void setValue(double value) {
        this.setValue((Object)value);
    }

    @Override
    public boolean evaluateOperandAsBoolean(Locale locale, Map context) {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValueAsDouble() != 0.0;
    }

    @Override
    public String getDefinitionElementName() {
        return "DoubleOperand";
    }

    @Override
    public int compareTo(ValueOperandInterface o, Locale locale) {
        if (this.getValue() == null && o.getValue() == null) {
            return 0;
        }
        if (this.getValue() == null) {
            return -1;
        }
        if (o.getValue() == null) {
            return 1;
        }
        Double d = this.getValueAsDouble();
        Double od = ((DoubleOperand)o).getValueAsDouble();
        return d.compareTo(od);
    }

    public String toString() {
        return this.getOperandAsString(null);
    }
}

