/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.codepolicy.SASScope;
import com.sas.storage.simplesqlmodel.BaseValueOperand;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import java.util.Locale;
import java.util.Map;

@SASScope
public class BooleanOperand
extends BaseValueOperand {
    public BooleanOperand() {
        this(false);
    }

    public BooleanOperand(boolean value) {
        this.setValue(value);
    }

    @Override
    public String getOperandAsString(Map context) {
        return "" + this.getValue();
    }

    public boolean getValueAsBoolean() {
        Boolean b = (Boolean)this.getValue();
        return b;
    }

    public void setValue(boolean value) {
        this.setValue(value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public String getDefinitionElementName() {
        return "BooleanOperand";
    }

    @Override
    public int compareTo(ValueOperandInterface o, Locale locale) {
        if (this.getValue() == null && o.getValue() == null) {
            return 0;
        }
        if (this.getValue() == null) {
            return -1;
        }
        if (o.getValue() == null) {
            return 1;
        }
        Boolean b = (Boolean)this.getValue();
        Boolean ob = (Boolean)((BooleanOperand)o).getValue();
        return b.compareTo(ob);
    }

    public String toString() {
        return this.getOperandAsString(null);
    }

    @Override
    public boolean evaluateOperandAsBoolean(Locale locale, Map context) {
        return this.getValueAsBoolean();
    }
}

