/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever.dto.search;

import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.storage.retriever.dto.QueryItemInterface;
import com.sas.storage.retriever.dto.ValueDataType;
import com.sas.storage.retriever.dto.search.SearchCriteriaInterface;
import com.sas.storage.retriever.dto.search.SearchOperator;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.util.ListFactory;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Deprecated
public class QueryItemSearchCriteria
extends BaseAbstractPersistence
implements SearchCriteriaInterface {
    private static final long serialVersionUID = -1210334623609365546L;
    private QueryItemInterface _queryItem;
    private SearchOperator _operator;
    private Object _rightExpression;
    private ValueDataType _dataType;
    private boolean _opValidated;
    private boolean _isCaseSensitiveSearch;

    public QueryItemSearchCriteria() {
    }

    public QueryItemSearchCriteria(QueryItemInterface qi, SearchOperator op, Object compareValue) {
        this.setLeftExpression(qi);
        this.setOperator(op);
        this.setRightExpression(compareValue);
    }

    @Override
    public Object getLeftExpression() {
        return this._queryItem;
    }

    @Override
    public void setLeftExpression(Object qi) throws IllegalArgumentException {
        ValidateArg.notNull((Object)qi, (String)"QueryItem");
        if (qi instanceof QueryItemInterface) {
            this._queryItem = (QueryItemInterface)qi;
            ValidateArg.notNull((Object)((Object)this._queryItem.getDataType()), (String)"QueryItem");
            this.setDataTypeFromQueryItem(this._queryItem);
            if (!this._opValidated) {
                this.setOperator(this._operator);
                this.setRightExpression(this._rightExpression);
            }
        } else {
            throw new IllegalArgumentException("Search criteria cannot be created without a QueryItem, please set the queryitem as a left expression");
        }
    }

    private void setDataTypeFromQueryItem(QueryItemInterface qi) {
        boolean formatting = false;
        ValueDataType dt = qi.getDataType();
        if (qi.isFormattedValues() && qi.getFormat() != null && qi.getFormat().length() > 0) {
            formatting = true;
        }
        this._dataType = formatting && (ValueDataType.DATE.equals((Object)dt) || ValueDataType.TIME.equals((Object)dt) || ValueDataType.TIME_STAMP.equals((Object)dt)) ? ValueDataType.STRING : dt;
    }

    @Override
    public Object getRightExpression() {
        return this._rightExpression;
    }

    @Override
    public void setRightExpression(Object exp) {
        this._rightExpression = exp != null && exp instanceof List && ((List)exp).size() > 0 ? ListFactory.newList((Collection)((List)exp)) : exp;
    }

    @Override
    public SearchOperator getOperator() {
        return this._operator;
    }

    @Override
    public void setOperator(SearchOperator op) {
        this._operator = op;
        if (!this._opValidated && this._dataType != null) {
            SearchOperator[] soa = null;
            if (this._dataType.equals((Object)ValueDataType.STRING)) {
                soa = this.getStringOperators();
            } else if (this._dataType.equals((Object)ValueDataType.NUMBER) || this._dataType.equals((Object)ValueDataType.DOUBLE) || this._dataType.equals((Object)ValueDataType.INTEGER)) {
                soa = this.getNumericOperators();
            } else if (this._dataType.equals((Object)ValueDataType.DATE)) {
                soa = this.getDateOperators();
            }
            if (soa != null && Arrays.asList(soa).contains((Object)op)) {
                this._opValidated = true;
            }
        } else {
            this._opValidated = false;
        }
    }

    public ValueDataType getDataType() {
        return this._dataType;
    }

    public void setDataType(ValueDataType dt) {
        this._dataType = dt;
    }

    public SearchOperator[] getOperators() {
        SearchOperator[] validOperators = null;
        if (this._dataType == null) {
            this._dataType = this._queryItem.getDataType();
        }
        if (this._dataType == ValueDataType.STRING) {
            validOperators = this.getStringOperators();
        } else if (this._dataType.equals((Object)ValueDataType.NUMBER) || this._dataType.equals((Object)ValueDataType.DOUBLE) || this._dataType.equals((Object)ValueDataType.INTEGER)) {
            validOperators = this.getNumericOperators();
        } else if (this._dataType == ValueDataType.DATE) {
            validOperators = this.getDateOperators();
        }
        return validOperators;
    }

    private SearchOperator[] getStringOperators() {
        return new SearchOperator[]{SearchOperator.LIKE_OPERATOR, SearchOperator.STARTS_WITH_OPERATOR, SearchOperator.ENDS_WITH_OPERATOR, SearchOperator.EQUAL_OPERATOR, SearchOperator.CONTAINS_OPERATOR, SearchOperator.BETWEEN_OPERATOR};
    }

    private SearchOperator[] getNumericOperators() {
        return new SearchOperator[]{SearchOperator.LESS_THAN_OPERATOR, SearchOperator.EQUAL_OPERATOR, SearchOperator.LESS_THAN_EQUAL_OPERATOR, SearchOperator.GREATER_THAN_OPERATOR, SearchOperator.NOT_EQUAL_OPERATOR, SearchOperator.GREATER_THAN_EQUAL_OPERATOR, SearchOperator.BETWEEN_OPERATOR};
    }

    private SearchOperator[] getDateOperators() {
        return new SearchOperator[]{SearchOperator.LESS_THAN_DATE_START_OPERATOR, SearchOperator.LESS_THAN_EQUAL_DATE_START_OPERATOR, SearchOperator.GREATER_THAN_EQUAL_DATE_START_OPERATOR, SearchOperator.LESS_THAN_EQUAL_DATE_END_OPERATOR, SearchOperator.GREATER_THAN_DATE_END_OPERATOR};
    }

    public FormattedOperator getFormattedOperator() {
        switch (this._operator) {
            case LIKE_OPERATOR: {
                return FormattedOperator.LIKE_OPERATOR;
            }
            case STARTS_WITH_OPERATOR: {
                return FormattedOperator.LIKE_OPERATOR;
            }
            case ENDS_WITH_OPERATOR: {
                return FormattedOperator.LIKE_OPERATOR;
            }
            case MATCH_PATTERN: {
                return FormattedOperator.LIKE_OPERATOR;
            }
            case BETWEEN_OPERATOR: {
                return FormattedOperator.BETWEEN_OPERATOR;
            }
            case NOT_BETWEEN_OPERATOR: {
                return FormattedOperator.NOT_BETWEEN_OPERATOR;
            }
            case BETWEEN_OPERATOR_EXCLUSIVE: {
                return FormattedOperator.BETWEEN_OPERATOR_EXCLUSIVE;
            }
            case NOT_BETWEEN_OPERATOR_INCLUSIVE: {
                return FormattedOperator.NOT_BETWEEN_OPERATOR_INCLUSIVE;
            }
            case IS_NULL_OPERATOR: {
                return FormattedOperator.IS_NULL_OPERATOR;
            }
            case AND_OPERATOR: {
                return FormattedOperator.AND_OPERATOR;
            }
            case OR_OPERATOR: {
                return FormattedOperator.OR_OPERATOR;
            }
            case LESS_THAN_OPERATOR: {
                return FormattedOperator.LESS_THAN_OPERATOR;
            }
            case GREATER_THAN_OPERATOR: {
                return FormattedOperator.GREATER_THAN_OPERATOR;
            }
            case LESS_THAN_EQUAL_OPERATOR: {
                return FormattedOperator.LESS_THAN_EQUAL_OPERATOR;
            }
            case GREATER_THAN_EQUAL_OPERATOR: {
                return FormattedOperator.GREATER_THAN_EQUAL_OPERATOR;
            }
            case NOT_EQUAL_OPERATOR: {
                return FormattedOperator.NOT_EQUAL_OPERATOR;
            }
            case CONTAINS_OPERATOR: {
                return FormattedOperator.CONTAINS_OPERATOR;
            }
            case LESS_THAN_DATE_START_OPERATOR: {
                return FormattedOperator.LESS_THAN_DATE_START_OPERATOR;
            }
            case GREATER_THAN_EQUAL_DATE_START_OPERATOR: {
                return FormattedOperator.GREATER_THAN_EQUAL_DATE_START_OPERATOR;
            }
            case GREATER_THAN_DATE_END_OPERATOR: {
                return FormattedOperator.GREATER_THAN_DATE_END_OPERATOR;
            }
            case NOT_OPERATOR: {
                return FormattedOperator.NOT_OPERATOR;
            }
            case ANY_OPERATOR: {
                return FormattedOperator.ANY_OPERATOR;
            }
            case ALL_OPERATOR: {
                return FormattedOperator.ALL_OPERATOR;
            }
            case SOME_OPERATOR: {
                return FormattedOperator.SOME_OPERATOR;
            }
            case IN_OPERATOR: {
                return FormattedOperator.IN_OPERATOR;
            }
            case AVG_OPERATOR: {
                return FormattedOperator.AVG_OPERATOR;
            }
            case PUT_OPERATOR: {
                return FormattedOperator.PUT_OPERATOR;
            }
            case UPCASE_OPERATOR: {
                return FormattedOperator.UPCASE_OPERATOR;
            }
            case TRIM_OPERATOR: {
                return FormattedOperator.TRIM_OPERATOR;
            }
        }
        return FormattedOperator.EQUAL_OPERATOR;
    }

    public MultiValueFormattedOperator getMultiValueFormattedOperator() {
        switch (this._operator) {
            case DATE_EQUAL_OPERATOR: {
                return MultiValueFormattedOperator.DATE_EQUAL_OPERATOR;
            }
            case DATE_LESS_THAN_OPERATOR: {
                return MultiValueFormattedOperator.DATE_LESS_THAN_OPERATOR;
            }
            case DATE_GREATER_THAN_OPERATOR: {
                return MultiValueFormattedOperator.DATE_GREATER_THAN_OPERATOR;
            }
            case DATE_LESS_THAN_EQUAL_OPERATOR: {
                return MultiValueFormattedOperator.DATE_LESS_THAN_EQUAL_OPERATOR;
            }
            case DATE_GREATER_THAN_EQUAL_OPERATOR: {
                return MultiValueFormattedOperator.DATE_GREATER_THAN_EQUAL_OPERATOR;
            }
            case DATE_NOT_EQUAL_OPERATOR: {
                return MultiValueFormattedOperator.DATE_NOT_EQUAL_OPERATOR;
            }
        }
        return null;
    }

    public boolean isCaseSensitiveSearch() {
        return this._isCaseSensitiveSearch;
    }

    public void setCaseSensitiveSearch(boolean caseSensitive) {
        this._isCaseSensitiveSearch = caseSensitive;
    }

    public Object clone() throws CloneNotSupportedException {
        QueryItemSearchCriteria clone = (QueryItemSearchCriteria)super.clone();
        clone.setLeftExpression(this.getLeftExpression());
        clone.setOperator(this.getOperator());
        clone.setRightExpression(this.getRightExpression());
        clone.setDataType(this.getDataType());
        clone.setCaseSensitiveSearch(this.isCaseSensitiveSearch());
        return clone;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.setRightExpression(roHolder.consumeObject("textToMatch"));
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String op;
        super.consumeAttributes(provider);
        this.getLogger2().debug("Running consumeAttributes().");
        String dtString = provider.consumeAttr("dataType");
        if (null != dtString) {
            this.setDataType(ValueDataType.valueOf(dtString));
        }
        if (null != (op = provider.consumeAttr("operator"))) {
            this.setOperator(SearchOperator.valueOf(op));
        }
        this.setCaseSensitiveSearch(provider.consumeBooleanAttr("isCaseSensitiveSearch", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        ValueDataType dt = this.getDataType();
        XmlUtil.setAttr(element, "dataType", dt.toString());
        XmlUtil.setAttr(element, "operator", this.getOperator().toString());
        ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
        list.add(ValueUtil.getPersistableValue(this.getRightExpression()));
        QueryItemSearchCriteria.writeRelatedObjects(list, element, writingContext, "textToMatch");
    }
}

