/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever;

import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.retriever.BaseLocalizableColumn;
import com.sas.storage.retriever.LocaleToListMap;
import com.sas.storage.retriever.dto.ColumnValueItem;
import com.sas.storage.retriever.dto.ValueDataType;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedLabels;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class LocalizableColumnLabel
extends BaseLocalizableColumn {
    private static final long serialVersionUID = 1L;
    private LocaleToListMap rowData = new LocaleToListMap();
    private int sizeOfRowData;

    @Override
    public String getDefinitionElementName() {
        return "LocalizableColumnLabel";
    }

    @Override
    public void setData(ColumnValueItem item) {
        super.setData(item);
        this.sizeOfRowData = item.getRowData().size();
        this.rowData.clear();
        if (item.getDataType().equals((Object)ValueDataType.STRING)) {
            Locale locale = XmlUtil.xmlToLocale(item.getLocale());
            if (locale != null) {
                this.rowData.put(locale, item.getRowData());
                item.getRowData().clear();
            } else {
                throw new IllegalArgumentException("An item whose data type is string must also contain a locale.");
            }
        }
    }

    public ColumnValueItem getDataSubset(Locale locale, int fromIndex, int count) {
        ColumnValueItem retVal = this.copyColumnValueItem(locale);
        if (fromIndex >= 0 && count > 0) {
            int toIndex = fromIndex + count;
            if (this.item.getDataType().equals((Object)ValueDataType.STRING)) {
                Object list = this.rowData.get(locale);
                retVal.setRowData(list.subList(fromIndex, toIndex));
                this.getLogger2().debug("returning subset of localized label strings");
            } else {
                retVal.setRowData(this.item.getRowData().subList(fromIndex, toIndex));
            }
            this.getLogger2().debug("returning subset of label objects");
        } else if (this.item.getDataType().equals((Object)ValueDataType.STRING)) {
            if (null != this.getResourceBundleDelegate()) {
                Object textList = this.rowData.get(locale);
                if (!textList.isEmpty()) {
                    ArrayList<Object> modifiedText = new ArrayList<Object>();
                    Iterator iterator = textList.iterator();
                    while (iterator.hasNext()) {
                        Object text = iterator.next();
                        String delText = this.getResourceBundleDelegate().getText((String)text, locale);
                        if (null != delText) {
                            modifiedText.add(delText);
                            continue;
                        }
                        modifiedText.add(text);
                    }
                    retVal.setRowData(modifiedText);
                    this.getLogger2().debug("returning all localized label strings using resource bundle delegate");
                }
            } else {
                retVal.setRowData((List<Object>)this.rowData.get(locale));
                this.getLogger2().debug("returning all localized label strings");
            }
        } else {
            retVal.setRowData(this.item.getRowData());
            this.getLogger2().debug("returning all label objects");
        }
        return retVal;
    }

    public boolean addLabels(Locale locale, List<Object> labelStrings) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull(labelStrings, (String)"labelStrings");
        if (this.item.getDataType() != null && this.item.getDataType().equals((Object)ValueDataType.STRING)) {
            if (this.sizeOfRowData != labelStrings.size()) {
                throw new IllegalArgumentException("The size of labelStrings list does not match the size of the row data already supplied via setData().");
            }
            this.rowData.put(locale, labelStrings);
            this.getLogger2().debug("addLabels success for:", this.item.getName() + " locale: " + locale.toString());
            return true;
        }
        this.getLogger2().debug("addLabels failed for:", this.item.getName() + " locale: " + locale.toString());
        return false;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList labelsList = roHolder.consumeObjects("Labels");
        if (!labelsList.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setting labels.");
            for (LocalizedLabels element : labelsList) {
                Locale locale = element.getLocale();
                Map<String, String> labelsMap = element.getLabelsMap();
                Set<Map.Entry<String, String>> set = labelsMap.entrySet();
                LinkedList<Object> list = new LinkedList<Object>();
                for (Map.Entry<String, String> entry : set) {
                    list.add(Integer.parseInt(entry.getValue()), entry.getKey());
                }
                this.rowData.put(locale, (List<Object>)list);
            }
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (!this.rowData.isEmpty()) {
            this.getLogger2().debug("writeDefinition(), writing this many localized labels:", Integer.toString(this.rowData.size()));
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
            Set<Map.Entry<Locale, List<Object>>> set = this.rowData.entrySet();
            Iterator<Map.Entry<Locale, List<Object>>> it = set.iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<Locale, List<Object>> entry = it.next();
                LinkedHashMap<String, String> labelsMap = new LinkedHashMap<String, String>();
                List<Object> labelList = entry.getValue();
                for (Object obj : labelList) {
                    labelsMap.put(obj.toString(), Integer.toString(i));
                    ++i;
                }
                i = 0;
                LocalizedLabels t = new LocalizedLabels();
                t.setLocale(entry.getKey());
                t.setLabelsMap(labelsMap);
                list.add(t);
            }
            LocalizableColumnLabel.writeRelatedObjects(list, element, writingContext, "Labels");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LocalizableColumnLabel retVal = (LocalizableColumnLabel)super.clone();
        this.configureClone(retVal);
        retVal.rowData.putAll(this.rowData);
        return retVal;
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        Object rowLabels;
        PropertyList list = super.getLocalizableProperties(locale);
        if (!this.rowData.containsKey(locale)) {
            this.getLogger2().warn("getLocalizableProperties(), row data does not contain an exact locale match for ", locale.toString());
        }
        if (null != (rowLabels = this.rowData.get(locale)) && !rowLabels.isEmpty()) {
            int i = 0;
            Iterator iterator = rowLabels.iterator();
            while (iterator.hasNext()) {
                Object label = iterator.next();
                list.addProperty("rowLabel", i, (String)label);
                ++i;
            }
            this.getLogger2().debug("getLocalizableProperties(), added row labels for ", this.item.getName());
        }
        return list;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        super.setLocalizableProperties(locale, map);
        int[] indexes = map.getPropertyIndexes("rowLabel");
        if (indexes.length > 0) {
            ArrayList<Object> input = new ArrayList<Object>();
            for (int i = 0; i < indexes.length; ++i) {
                input.add(map.getProperty("rowLabel", i));
            }
            this.rowData.put(locale, (List<Object>)input);
            this.getLogger2().debug("setting row labels for locale", locale.toString());
        }
    }
}

