/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever;

import com.sas.storage.retriever.ValueRetrieverConfiguration;
import com.sas.storage.retriever.dto.MetadataItemInterface;
import com.sas.storage.retriever.dto.QueryItemInterface;
import com.sas.storage.retriever.dto.QueryProperties;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DynamicValueRetrieverConfiguration
extends ValueRetrieverConfiguration {
    private static final long serialVersionUID = 1L;
    private static String RB_KEY = "DynamicValueRetrieverConfiguration.";
    public static String CONFIG_ATTRIBUTE_QUERY_ITEM_LIST = RB_KEY + "CONFIG_ATTRIBUTE_QUERY_ITEM_LIST";
    public static String CONFIG_ATTRIBUTE_QUERY_PROPERTIES = RB_KEY + "CONFIG_ATTRIBUTE_QUERY_PROPERTIES";
    public static String CONFIG_ATTRIBUTE_METADATA_ITEM_LIST = RB_KEY + "CONFIG_ATTRIBUTE_METADATA_ITEM_LIST";
    private List<MetadataItemInterface> _metadataItemList;
    private QueryProperties _properties;
    private List<QueryItemInterface> _queryList;

    public DynamicValueRetrieverConfiguration() {
    }

    public DynamicValueRetrieverConfiguration(List<QueryItemInterface> qli, QueryProperties qp) {
        if (qli != null && qli.size() > 0) {
            this.setQueryItems(qli);
        }
        this._properties = qp;
    }

    public DynamicValueRetrieverConfiguration(List<MetadataItemInterface> qli) {
        if (qli != null && qli.size() > 0) {
            this.setMetadataItems(qli);
        }
    }

    public void setQueryProperties(QueryProperties properties) {
        this._properties = properties;
    }

    public QueryProperties getQueryProperties() {
        return this._properties;
    }

    public List<QueryItemInterface> getQueryItems() {
        if (null == this._queryList) {
            return Collections.emptyList();
        }
        return this._queryList;
    }

    public void setQueryItems(List<QueryItemInterface> list) {
        if (Util.unequal(list, this._queryList)) {
            this._queryList = new ArrayList<QueryItemInterface>();
            if (null != list) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        QueryItemInterface qi = (QueryItemInterface)list.get(i).clone();
                        qi.setVrConfigId(String.valueOf(i));
                        this._queryList.add(qi);
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this._metadataItemList = null;
        }
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        if (options.containsKey(CONFIG_ATTRIBUTE_QUERY_PROPERTIES)) {
            this.setQueryProperties((QueryProperties)options.get(CONFIG_ATTRIBUTE_QUERY_PROPERTIES));
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_QUERY_ITEM_LIST)) {
            this.setQueryItems((List)options.get(CONFIG_ATTRIBUTE_QUERY_ITEM_LIST));
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_METADATA_ITEM_LIST)) {
            this.setMetadataItems((List)options.get(CONFIG_ATTRIBUTE_METADATA_ITEM_LIST));
        }
    }

    public List<MetadataItemInterface> getMetadataItems() {
        if (null == this._metadataItemList) {
            return Collections.emptyList();
        }
        return this._metadataItemList;
    }

    public void setMetadataItems(List<MetadataItemInterface> list) {
        if (Util.unequal(list, this._metadataItemList)) {
            this._metadataItemList = new ArrayList<MetadataItemInterface>();
            if (null != list) {
                this._metadataItemList.addAll(list);
            }
            this._queryList = null;
            this._properties = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CopyOnWriteArrayList<QueryItemInterface> list;
        DynamicValueRetrieverConfiguration clone = (DynamicValueRetrieverConfiguration)super.clone();
        if (this._queryList != null && !this._queryList.isEmpty()) {
            list = new CopyOnWriteArrayList<QueryItemInterface>();
            for (QueryItemInterface queryItemInterface : this._queryList) {
                list.add((QueryItemInterface)queryItemInterface.clone());
            }
            clone.setQueryItems(list);
        }
        if (this._metadataItemList != null && !this._metadataItemList.isEmpty()) {
            list = new CopyOnWriteArrayList();
            for (MetadataItemInterface metadataItemInterface : this._metadataItemList) {
                list.add((QueryItemInterface)((Object)((MetadataItemInterface)metadataItemInterface.clone())));
            }
            clone.setMetadataItems(list);
        }
        if (null != this._properties) {
            clone.setQueryProperties((QueryProperties)this._properties.clone());
        }
        return clone;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getDefinitionElementName() {
        return null;
    }
}

