/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;

public class MeasureNode
extends MetadataEntityTreeNode {
    private MeasureInterface measure;

    public MeasureNode() {
        this.childCount = 0;
    }

    public MeasureNode(MeasureInterface measure) {
        this.measure = measure;
        this.userObject = measure;
        this.childCount = 0;
    }

    public MeasureNode(MetadataInterface metadata, String cubeName, String measureUniqueName) {
        if (this.findLevel(metadata, cubeName, measureUniqueName) == null) {
            this.createDummyNode(measureUniqueName);
        }
        this.childCount = 0;
    }

    @Override
    public int getChildCount() {
        return this.childCount;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    protected synchronized boolean populateChildren() {
        return true;
    }

    private MeasureInterface findLevel(MetadataInterface metadata, String cubeName, String uniqueName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            filter.setUniqueMeasureName(uniqueName);
            this.measure = metadata.getMeasure(filter);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.measure;
    }
}

