/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.IMDDataSet;
import com.sas.models.CacheException;
import com.sas.models.SparseCache;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.sasmdx.DataCache;
import com.sas.storage.olap.sasmdx.RB;
import com.sas.storage.olap.sasmdx.ResultSetMetadata;

@SASScope(value="ALL")
public class ResultSet
implements ResultSetInterface {
    @SASScope
    protected String queryStatement;
    @SASScope
    protected ResultSetMetadataInterface resultSetMetadata;
    @SASScope
    protected DataCache cache;
    protected IMDDataSet _mdDataSet;
    @SASScope
    protected long cellCount;

    @SASScope
    public ResultSet() throws OLAPException {
        this(null, null, null);
    }

    @SASScope
    public ResultSet(DataCache cache, String queryStatement, IMDDataSet _mdDataSet) throws OLAPException {
        this.cache = cache;
        this.queryStatement = queryStatement;
        this._mdDataSet = _mdDataSet;
        this.resultSetMetadata = new ResultSetMetadata(cache, this);
        this.cellCount = -1L;
    }

    @Override
    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this.resultSetMetadata;
    }

    @Override
    public String getQueryStatement() throws OLAPException {
        return this.queryStatement;
    }

    @Override
    public boolean isReadOnly() throws OLAPException {
        return true;
    }

    @Override
    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        try {
            long cnt = this.getCellCount();
            if (cnt == 0L) {
                return OLAPUtil.EMPTY_OBJECT_ARRAY;
            }
            if (endCell == -1L) {
                endCell = cnt - 1L;
            }
            if (startCell < 0L || endCell > cnt - 1L || endCell < startCell) {
                throw new IllegalArgumentException(RB.getStringResource("DataCache.", "invalidOrdinal.ex.txt"));
            }
            SparseCache sc = this.cache.getUnformattedCellCache();
            Object[] c = sc.getFromCache(startCell, endCell, false);
            if (sc.cacheContainsKey(startCell) && sc.cacheContainsKey(endCell)) {
                return sc.getFromCache(startCell, endCell, true);
            }
            return c;
        }
        catch (CacheException ce) {
            throw new OLAPException(ce, OLAPUtil.getExceptionMessage(ce));
        }
    }

    @Override
    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        try {
            long cnt = this.getCellCount();
            if (cnt == 0L) {
                return OLAPUtil.EMPTY_STRING_ARRAY;
            }
            if (endCell == -1L) {
                endCell = this.getCellCount() - 1L;
            }
            if (startCell < 0L || endCell > cnt - 1L || endCell < startCell) {
                throw new IllegalArgumentException(RB.getStringResource("DataCache.", "invalidOrdinal.ex.txt"));
            }
            SparseCache sc = this.cache.getFormattedCellCache();
            Object[] c = sc.getFromCache(startCell, endCell, false);
            String[] cells = null;
            if (sc.cacheContainsKey(startCell) && sc.cacheContainsKey(endCell)) {
                Object[] nc = sc.getFromCache(startCell, endCell, true);
                cells = new String[nc.length];
                for (int i = 0; i < nc.length; ++i) {
                    cells[i] = (String)nc[i];
                }
            } else {
                cells = new String[c.length];
                for (int i = 0; i < c.length; ++i) {
                    cells[i] = (String)c[i];
                }
            }
            return cells;
        }
        catch (CacheException ce) {
            throw new OLAPException(ce, OLAPUtil.getExceptionMessage(ce));
        }
    }

    @Override
    public long getCellCount() throws OLAPException {
        if (this.cellCount == -1L) {
            this.cache.getCellCount();
        }
        return this.cellCount;
    }

    @Override
    public void setCells(long startCell, long endCell, Object[] cellValues) {
        throw new IllegalStateException("setCells not supported");
    }

    @Override
    public void setFormattedCells(long startCell, long endCell, String[] cellValues) {
        throw new IllegalStateException("setFormattedCells not supported");
    }

    @Override
    public void close() throws OLAPException {
        try {
            this._mdDataSet.Close();
            this.cache.flush();
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
    }

    void setCellCount(long cellCount) {
        this.cellCount = cellCount;
    }
}

