/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.IMDDataSet;
import com.sas.iom.SASMDX.IMDDataSet_1_2;
import com.sas.iom.SASMDX.IMDDataSet_1_2Helper;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iom.SASMDX.ResultSetTypeSeqHolder;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.sasmdx.DataCache;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.RB;
import com.sas.storage.olap.sasmdx.ResultSet;
import com.sas.util.Strings;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
public class OLAPDataSet
implements OLAPDataSetInterface {
    @SASScope
    public static final String RB_KEY = "OLAPDataSet.";
    @SASScope
    protected IMDXServer _connection;
    @SASScope
    protected ISession _session;
    @SASScope
    protected Locale locale;
    @SASScope
    protected IMDDataSet _mdDataSet;
    @SASScope
    protected String queryStatement;
    @SASScope
    protected String host;
    @SASScope
    protected int port;
    @SASScope
    protected String username;
    @SASScope
    protected String password;
    @SASScope
    protected boolean isConnected = false;
    @SASScope
    protected boolean initialized;
    @SASScope
    protected int contextType;
    @SASScope
    protected DataCache cache;
    @SASScope
    protected boolean close = false;
    private String cubeName;
    private ResultSetInterface resultSet;
    private PerformanceTuning performanceTuning;
    private MetadataInterface metadata;
    private String _queryId;
    private String _normalizedQueryId;
    private static final char[] cubeChars = new char[]{'{', '}', '[', ']', '(', ')', '\r', '\n'};
    private static final String[] replaceChars = new String[]{"", "", "", "", "", "", "", ""};
    private String totalLabel = null;
    private Map<String, String> measureLabelMap;

    public OLAPDataSet() throws OLAPException {
        this(null, null);
    }

    public OLAPDataSet(java.lang.Object connection) throws OLAPException {
        this(connection, null);
    }

    public OLAPDataSet(java.lang.Object connection, String queryStatement) throws OLAPException {
        this.setConnection(connection);
        this.contextType = 0;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    public OLAPDataSet(java.lang.Object connection, String queryStatement, String queryId) throws OLAPException {
        this.setConnection(connection);
        this.contextType = 0;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement, queryId);
        } else {
            this.executeQuery(queryStatement, queryId);
        }
    }

    public OLAPDataSet(String host, int port, String username, String password) throws OLAPException {
        this(host, port, username, password, null);
    }

    public OLAPDataSet(String host, int port, String username, String password, String queryStatement) throws OLAPException {
        this.contextType = 0;
        this.setConnection(null);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    public OLAPDataSet(java.lang.Object connection, Locale locale, String queryStatement) throws OLAPException {
        this.setConnection(connection);
        this.locale = locale;
        this.contextType = 0;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    public OLAPDataSet(String host, int port, String username, String password, Locale locale, String queryStatement) throws OLAPException {
        this.contextType = 0;
        this.setConnection(null);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.locale = locale;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    public OLAPDataSet(java.lang.Object connection, Locale locale, String queryStatement, int contextType) throws OLAPException {
        this.setConnection(connection);
        this.locale = locale;
        this.contextType = contextType;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    public OLAPDataSet(java.lang.Object connection, String queryStatement, int contextType) throws OLAPException {
        this.setConnection(connection);
        this.contextType = contextType;
        if (queryStatement == null) {
            this.setQueryStatement(queryStatement);
        } else {
            this.executeQuery(queryStatement);
        }
    }

    @Override
    public void setContextType(int contextType) throws OLAPException {
        this.contextType = contextType;
        this.executeQuery();
    }

    @Override
    public int getContextType() throws OLAPException {
        return this.contextType;
    }

    @Override
    public void setLocale(Locale locale) throws OLAPException {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() throws OLAPException {
        return this.locale;
    }

    @Override
    public java.lang.Object getConnection() throws OLAPException {
        if (this._connection == null) {
            return this._session;
        }
        return this._connection;
    }

    @Override
    public void setConnection(java.lang.Object connection) throws OLAPException {
        if (connection != null && connection instanceof ISession) {
            this._session = (ISession)connection;
            this._connection = null;
        } else {
            this._connection = (IMDXServer)connection;
            this._session = null;
        }
        this.initialized = false;
    }

    public String getQueryId() {
        return this._queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMeasureLabelMap(Map<String, String> measureMap) throws OLAPException {
        if (measureMap != null && measureMap.size() > 0) {
            Map<String, String> map = measureMap;
            synchronized (map) {
                this.measureLabelMap = new ConcurrentHashMap<String, String>();
                Set<Map.Entry<String, String>> set = measureMap.entrySet();
                for (Map.Entry<String, String> e : set) {
                    if (e.getKey() == null || e.getValue() == null) {
                        throw new OLAPException(RB.getStringResource(RB_KEY, "invalidLabel.txt"));
                    }
                    this.measureLabelMap.put(e.getKey().toUpperCase(this.locale), e.getValue());
                }
            }
        } else {
            this.measureLabelMap = null;
        }
    }

    Map<String, String> getMeasureLabelMap() {
        return this.measureLabelMap;
    }

    private void setQueryId(String queryId) {
        if (queryId != null && queryId.length() > 0) {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            this._queryId = queryId;
            this._normalizedQueryId = queryId.toUpperCase(this.locale);
        } else {
            this._normalizedQueryId = queryId;
        }
    }

    public void executeQuery(String queryStatement, String queryId) throws OLAPException {
        this.setQueryId(queryId);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (!queryStatement.toUpperCase(this.locale).contains(this._queryId)) {
            System.out.println(RB.getStringResource(RB_KEY, "missingQueryId.txt"));
        }
        this.setMeasureLabelMap(null);
        this.executeQuery(queryStatement);
    }

    @Override
    public void executeQuery(String queryStatement) throws OLAPException {
        this.establishConnection();
        this.queryStatement = queryStatement;
        if (queryStatement == null) {
            this.resultSet = null;
            this.initialized = false;
            this.measureLabelMap = null;
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "resultSetCleared.ex.txt"));
        }
        int nAxes = 0;
        try {
            IntHolder _numAxes = new IntHolder();
            IMDDataSet _oldDataSet = this._mdDataSet;
            this._mdDataSet = this._session.MDXQuery(queryStatement, _numAxes);
            if (_oldDataSet != null) {
                _oldDataSet.Close();
            }
            nAxes = _numAxes.value;
            if (this.cache == null) {
                this.cache = new DataCache(this, this._mdDataSet, this.performanceTuning);
            } else {
                this.cache.flush(this, this._mdDataSet);
            }
        }
        catch (Exception ex) {
            this.close();
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        this.cubeName = null;
        this.totalLabel = null;
        this.resultSet = new ResultSet(this.cache, queryStatement, this._mdDataSet);
        this.initialized = true;
    }

    public void setTotalLabel(String label) {
        this.totalLabel = label;
    }

    public String getTotalLabel() {
        return this.totalLabel;
    }

    @Override
    public String getCubeName() throws OLAPException {
        if (this._mdDataSet != null && this.cubeName == null) {
            try {
                IMDDataSet_1_2 _mdDataSet_2 = IMDDataSet_1_2Helper.narrow((Object)this._mdDataSet);
                this.cubeName = _mdDataSet_2.CubeName();
            }
            catch (Exception e) {
                System.out.println("Unable to resolve cube name from server, using client parsing");
                this.cubeName = null;
            }
        }
        return this.getCubeNameHint();
    }

    @SASScope
    public String getCubeNameHint() {
        if (this.cubeName == null) {
            this.parseQuery();
        }
        return this.cubeName;
    }

    @SASScope
    public void setCubeNameHint(String cubeNameHint) {
        this.cubeName = cubeNameHint;
    }

    private void parseQuery() {
        int pindex;
        StringBuffer query = new StringBuffer(this.queryStatement.toUpperCase());
        int i = query.indexOf("/*");
        if (i >= 0) {
            query = query.delete(i, query.toString().indexOf("*/") + 2);
        }
        int index = query.indexOf("FROM ");
        int nindex = -1;
        while (index > 0 && (nindex = query.indexOf("]", index + 1)) > 0 && ((pindex = query.indexOf("[", index + 1)) <= 0 || pindex >= nindex)) {
            index = query.indexOf("FROM ", nindex + 1);
        }
        String s = query.substring(index + 5);
        if ((index = s.indexOf(" ")) < 0) {
            index = s.length();
        }
        this.cubeName = s.substring(0, index);
        if (this.cubeName.indexOf(91) >= 0) {
            this.cubeName = s.substring(0, s.indexOf(93));
        }
        this.cubeName = Strings.replace((String)this.cubeName, (char[])cubeChars, (String[])replaceChars);
    }

    @Override
    public void executeQuery() throws OLAPException {
        this.executeQuery(this.queryStatement);
    }

    @Override
    public void setQueryStatement(String queryStatement) throws OLAPException {
        this.setQueryStatement(queryStatement, null, null);
    }

    public void setQueryStatement(String queryStatement, String queryID) throws OLAPException {
        this.setQueryStatement(queryStatement, queryID, null);
    }

    public void setQueryStatement(String queryStatement, String queryID, Map<String, String> measureLabelMap) throws OLAPException {
        this.queryStatement = queryStatement;
        this.setQueryId(queryID);
        this.setMeasureLabelMap(measureLabelMap);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws OLAPException {
        if (!readOnly) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "readOnly.ex.txt"));
        }
    }

    @Override
    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        return this.resultSet.getResultSetMetadata();
    }

    @Override
    public String getQueryStatement() throws OLAPException {
        return this.queryStatement;
    }

    @Override
    public boolean isReadOnly() throws OLAPException {
        return true;
    }

    @Override
    public java.lang.Object[] getCells(long startCell, long endCell) throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        return this.resultSet.getCells(startCell, endCell);
    }

    @Override
    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        return this.resultSet.getFormattedCells(startCell, endCell);
    }

    @Override
    public long getCellCount() throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        return this.resultSet.getCellCount();
    }

    @Override
    public void setCells(long startCell, long endCell, java.lang.Object[] cellValues) throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        this.resultSet.setCells(startCell, endCell, cellValues);
    }

    @Override
    public void setFormattedCells(long startCell, long endCell, String[] cellValues) throws OLAPException {
        this.init();
        if (this.resultSet == null) {
            OLAPDataSet.throwIllegalStateException();
        }
        this.resultSet.setFormattedCells(startCell, endCell, cellValues);
    }

    @Override
    public void close() throws OLAPException {
        if (!this.close) {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this._connection != null) {
                    Metadata.clearCache(null, this._session, 2);
                    this._session.Close();
                    this._session = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initialized = false;
            this.close = true;
        }
    }

    @Override
    public PerformanceTuning getPerformanceTuning() throws OLAPException {
        return this.performanceTuning;
    }

    @Override
    public void setPerformanceTuning(PerformanceTuning performanceTuning) throws OLAPException {
        try {
            if (performanceTuning != null) {
                OLAPDataSetInterface model = performanceTuning.getModel();
                this.performanceTuning = model == null || model == this ? performanceTuning : (PerformanceTuning)performanceTuning.clone();
                if (this.cache != null) {
                    this.cache.setPerformanceTuning(this.performanceTuning);
                }
                this.performanceTuning.setModel(this);
            }
        }
        catch (CloneNotSupportedException ce) {
            throw new OLAPException(ce);
        }
    }

    @Override
    public MetadataInterface getDatabaseMetadata() throws OLAPException {
        this.init();
        return this.metadata;
    }

    @SASScope
    protected void init() throws OLAPException {
        if (this.initialized) {
            return;
        }
        this.executeQuery(this.queryStatement);
    }

    @SASScope
    protected void establishConnection() throws OLAPException {
        if (this.isConnected) {
            return;
        }
        try {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this._connection == null && this._session == null) {
                if (this.host == null || this.port == 0) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidConnection.ex.txt"));
                }
                String classID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
                BridgeServer server = new BridgeServer(classID, this.host, this.port);
                ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
                String loggerName = ConnectionFactoryManager.getConnectionFactoryLoggerName((ConnectionFactoryConfiguration)cxfConfig);
                Logger logger = Logger.getLogger(loggerName);
                logger.setLevel(Level.OFF);
                ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                ConnectionInterface cx = cxf.getConnection(this.username, this.password);
                Object obj = cx.getObject();
                this._connection = IMDXServerHelper.narrow((Object)obj);
            }
            if (this._session == null) {
                if (this.locale == null) {
                    this.locale = Locale.getDefault();
                }
                this._session = this._connection.CreateSession(this.locale.toString());
            }
            this.metadata = new Metadata(this._session);
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        this.isConnected = true;
        this.initialized = false;
    }

    @SASScope
    public DataCache getDataCache() {
        return this.cache;
    }

    @SASScope
    protected void finalize() {
        try {
            this.close();
        }
        catch (OLAPException oLAPException) {
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
        }
    }

    private static IllegalStateException throwIllegalStateException() {
        return new IllegalStateException(RB.getStringResource(RB_KEY, "invalidResultSet.ex.txt"));
    }

    void setCellCount(int cellCount) {
        ((ResultSet)this.resultSet).setCellCount(cellCount);
    }

    public void cancelQuery() throws OLAPException {
        if (this._queryId == null) {
            throw new OLAPException(RB.getStringResource(RB_KEY, "cancelquery.ex.txt"));
        }
        this.establishConnection();
        try {
            if (this._session instanceof ISession_1_1) {
                UUIDSeqHolder queryIDHolder = new UUIDSeqHolder();
                StringSeqHolder queryHolder = new StringSeqHolder();
                ResultSetTypeSeqHolder typeHolder = new ResultSetTypeSeqHolder();
                StringSeqHolder lastUpdateTimeHolder = new StringSeqHolder();
                LongSeqHolder sizeHolder = new LongSeqHolder();
                LongSeqHolder totalCellsHolder = new LongSeqHolder();
                LongSeqHolder readCellsHolder = new LongSeqHolder();
                ((ISession_1_1)this._session).ListQueries_2(queryIDHolder, queryHolder, typeHolder, lastUpdateTimeHolder, sizeHolder, totalCellsHolder, readCellsHolder);
                String[] query = queryHolder.value;
                UUID[] queryId = queryIDHolder.value;
                if (this.locale == null) {
                    this.locale = Locale.getDefault();
                }
                for (int i = 0; i < query.length; ++i) {
                    if (!query[i].toUpperCase(this.locale).contains(this._normalizedQueryId)) continue;
                    ((ISession_1_1)this._session).CloseResultSet(queryId[i]);
                }
            }
        }
        catch (GenericError ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        finally {
            this.close();
            System.out.println("query closed=" + this._queryId);
        }
    }
}

