/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.RB;
import java.util.Date;

@SASScope(value="ALL")
public class Dimension
implements DimensionInterface {
    @SASScope
    public static final String RB_KEY = "Dimension.";
    @SASScope
    protected ISession _session;
    @SASScope
    protected String catalogName;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected String uniqueName;
    @SASScope
    protected String cubeName;
    @SASScope
    protected String description;
    @SASScope
    protected int type;
    @SASScope
    protected int nMems;
    @SASScope
    protected String defaultHierName;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected Filter filter;
    private CubeInterface cube;
    private HierarchyInterface hierarchy;
    private boolean isShared;

    public Dimension(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String name, String uniqueName, String label, int type, int nMems, String defaultHier, String description) throws OLAPException {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.name = name;
        this.uniqueName = uniqueName;
        this.label = label;
        this.type = type;
        this.description = description;
        this.nMems = nMems;
        this.defaultHierName = defaultHier;
        this.metadata = metadata;
        this._session = _session;
        this.description = description;
        this.filter = null;
        if (this.cubeName == null || this.cubeName.length() == 0) {
            this.isShared = true;
        }
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getUniqueName() throws OLAPException {
        return this.uniqueName;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.description;
    }

    @Override
    public synchronized CubeInterface getCube() throws OLAPException {
        if (this.isShared) {
            return null;
        }
        if (this.cube == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource("nullMetadata.ex.txt"));
            }
            Filter inFilter = new Filter();
            inFilter.setCatalogName(this.catalogName);
            inFilter.setSchemaName(this.schemaName);
            inFilter.setCubeName(this.cubeName);
            this.cube = this.metadata.getCube(inFilter);
        }
        return this.cube;
    }

    @Override
    public MemberInterface[] getMembers() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("noCube.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueName);
        return this.metadata.getMembers(inFilter, 0, -1);
    }

    @Override
    public int getType() throws OLAPException {
        return this.type;
    }

    @Override
    public int getMemberCount() throws OLAPException {
        return this.nMems;
    }

    @Override
    public synchronized HierarchyInterface getDefaultHierarchy() throws OLAPException {
        if (this.hierarchy == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource("nullMetadata.ex.txt"));
            }
            Filter inFilter = new Filter();
            inFilter.setCatalogName(this.catalogName);
            inFilter.setSchemaName(this.schemaName);
            inFilter.setCubeName(this.cubeName);
            inFilter.setIncludeSharedDimensions(this.isShared);
            inFilter.setDimensionName(this.name);
            inFilter.setUniqueDimensionName(this.uniqueName);
            inFilter.setUniqueHierarchyName(this.defaultHierName);
            this.hierarchy = this.metadata.getHierarchy(inFilter);
        }
        return this.hierarchy;
    }

    @Override
    public HierarchyInterface[] getHierarchies() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("nullMetadata.ex.txt"));
        }
        return this.metadata.getHierarchies(this.getFilter());
    }

    @Override
    public synchronized Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCatalogName(this.catalogName);
            this.filter.setSchemaName(this.schemaName);
            this.filter.setCubeName(this.cubeName);
            this.filter.setIncludeSharedDimensions(this.isShared);
            this.filter.setDimensionName(this.name);
            this.filter.setUniqueDimensionName(this.uniqueName);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }

    @Override
    public Date getCreationDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }

    @Override
    public Date getUpdateDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }
}

