/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASMDX.ISession;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.StaticCacheInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Axis;
import com.sas.storage.olap.sasmdx.DataCache;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.olap.sasmdx.RB;
import com.sas.storage.olap.sasmdx.Tuple;
import com.sas.storage.olap.sasmdx.TupleCache;
import com.sas.storage.olap.sasmdx.TupleElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

@SASScope
public class AxisCache {
    public static final String RB_KEY = "AxisCache.";
    private static String TOTAL_LABEL = RB.getStringResource("AxisCache.TotalLabel.txt");
    private static String SUBTOTAL_LABEL = "Subtotal";
    private static String LABEL_SEPARATOR = ":";
    private static String MULTILABEL_MARKER = "#";
    static String TOTAL_PROPERTY_KEY = "ORIGINAL_UNIQUE_NAME";
    static String GROUP_PROPERTY_KEY = "GROUP";
    private TupleCache tupleCache;
    private DataCache dataCache;
    private AxisInterface axis;
    private int baseTupleDepth;
    private String[][] propertyNames;
    TupleInterface[] cTuples;
    int tupleCount;
    private static final int INVALID_TYPE = -2;

    @SASScope
    public AxisCache(DataCache dataCache, int axisIndex, int tupleCount, int tupleDepth, String[] hierarchyNames, String[] dimensionNames, String[][] propertyNames) throws OLAPException {
        int lookAhead;
        this.dataCache = dataCache;
        OLAPDataSetInterface olapDataSet = dataCache.getOLAPDataSet();
        this.axis = new Axis(this, axisIndex, tupleCount, tupleDepth, hierarchyNames, dimensionNames, olapDataSet.getResultSetMetadata());
        this.baseTupleDepth = tupleDepth;
        this.tupleCount = tupleCount;
        this.propertyNames = propertyNames;
        PerformanceTuning pf = dataCache.getPerformanceTuning();
        int cacheType = this.getType();
        int bufferSize = pf.getBufferSize(cacheType);
        if (bufferSize == PerformanceTuning.MAX_VALUE) {
            bufferSize = tupleCount;
        }
        if ((lookAhead = pf.getLookAhead(cacheType)) == PerformanceTuning.MAX_VALUE) {
            lookAhead = tupleCount;
        }
        MetadataInterface metadata = olapDataSet.getDatabaseMetadata();
        int contextType = olapDataSet.getContextType();
        this.tupleCache = new TupleCache(new TupleReader(), bufferSize, lookAhead, this.axis, propertyNames, olapDataSet);
        if (!pf.isLookAheadEnabled(cacheType)) {
            this.tupleCache.disableLookAhead();
        }
    }

    private ISession getSession(MetadataInterface metadata) {
        ISession _session = null;
        try {
            Object o = metadata.getConnection();
            if (o instanceof ISession) {
                _session = (ISession)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _session;
    }

    private TupleInterface[] getCachedTuples(int index, int count) throws OLAPException {
        TupleInterface[] cachedTuples = new TupleInterface[]{};
        try {
            if (this.tupleCache.count() > 0) {
                int cnt;
                long[] keys = this.tupleCache.getCacheKeys();
                long start = index == -12 ? keys[0] : (long)index;
                long endIndex = start + (long)(cnt = count == -18 || count == -1 ? (int)(keys[keys.length - 1] - start + 1L) : count) - 1L;
                if (endIndex > 0L && endIndex > (long)(this.tupleCount - 1)) {
                    endIndex = this.tupleCount - 1;
                }
                Object[] temp = this.tupleCache.getFromCache(start, endIndex, true);
                int si = (int)start;
                for (int i = 0; i < temp.length; ++i) {
                    if (start != (long)((TupleInterface)temp[i]).getTupleIndex()) continue;
                    si = i;
                    break;
                }
                cachedTuples = new TupleInterface[cnt];
                System.arraycopy(temp, si, cachedTuples, 0, cnt);
            }
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
        return cachedTuples;
    }

    public TupleInterface[] getTuples(int index, int count) throws OLAPException {
        if (count == 0 || this.tupleCount == 0) {
            return new TupleInterface[0];
        }
        if (index == -12 || count == -18) {
            if (this.cTuples != null && this.cTuples.length > 0 && index == -12 && count == -18) {
                return this.cTuples;
            }
            this.cTuples = this.tupleCache.getTuplesWithContext(this.getCachedTuples(index, count));
            OLAPUtil.calculateSpan(this.cTuples);
            OLAPUtil.calculateMinMaxCoordinates(this.cTuples);
            return this.cTuples;
        }
        if (count == -1 || index + count > this.tupleCount) {
            count = this.tupleCount - index;
        }
        int endIndex = index + count - 1;
        TupleInterface[] returnTuples = new TupleInterface[count];
        if (this.cTuples != null && this.cTuples.length > 0) {
            for (int i = 0; i < this.cTuples.length; ++i) {
                if (index != this.cTuples[i].getTupleIndex()) continue;
                if (this.cTuples.length < i + count || this.cTuples[i + count - 1].getTupleIndex() != endIndex) break;
                System.arraycopy(this.cTuples, i, returnTuples, 0, count);
                return returnTuples;
            }
        }
        this.cTuples = null;
        try {
            Object[] temp = this.tupleCache.getFromCache(index, endIndex, false);
            TupleInterface[] ct = this.getCachedTuples(-12, -18);
            if (ct.length > temp.length || temp.length > ct.length && this.tupleCache.getCacheCapacity() > temp.length && ct.length == count) {
                temp = new TupleInterface[ct.length];
                System.arraycopy(ct, 0, temp, 0, ct.length);
            }
            int si = index;
            for (int i = 0; i < temp.length; ++i) {
                if (index != ((TupleInterface)temp[i]).getTupleIndex()) continue;
                si = i;
                break;
            }
            if (this.dataCache.getOLAPDataSet().getContextType() == 1) {
                System.arraycopy(temp, si, returnTuples, 0, returnTuples.length);
                OLAPUtil.calculateMinMaxCoordinates(returnTuples);
            } else {
                this.tupleCache.setAxisHeaders(null, null);
                this.cTuples = this.tupleCache.getTuplesWithContext(temp);
                OLAPUtil.calculateSpan(this.cTuples);
                OLAPUtil.calculateMinMaxCoordinates(this.cTuples);
                System.arraycopy(this.cTuples, si, returnTuples, 0, returnTuples.length);
            }
        }
        catch (CacheException ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
        return returnTuples;
    }

    public SequentialCache getTupleCache() {
        return this.tupleCache;
    }

    public void setAxis(AxisInterface axis) {
        this.axis = axis;
        this.tupleCache.setAxis(axis);
    }

    public AxisInterface getAxis() {
        return this.axis;
    }

    public String[] getAxisHeaders() throws OLAPException {
        return this.tupleCache.getAxisHeaders();
    }

    public String[] getUniqueLevelNames() throws OLAPException {
        return this.tupleCache.getUniqueLevelNames();
    }

    public String[] getDimensionNames() throws OLAPException {
        return this.tupleCache.getDimensionNames();
    }

    public String[] getHierarchyNames() throws OLAPException {
        return this.tupleCache.getHierarchyNames();
    }

    public int getMaximumTupleDepth() throws OLAPException {
        return this.tupleCache.getMaximumTupleDepth();
    }

    private int getType() throws OLAPException {
        int type;
        int axisNumber = this.axis.getAxisNumber();
        switch (axisNumber) {
            case 0: {
                type = PerformanceTuning.COLUMNS_AXIS_TYPE;
                break;
            }
            case 1: {
                type = PerformanceTuning.ROWS_AXIS_TYPE;
                break;
            }
            case 2: {
                type = PerformanceTuning.PAGES_AXIS_TYPE;
                break;
            }
            case 3: {
                type = PerformanceTuning.SECTIONS_AXIS_TYPE;
                break;
            }
            case 4: {
                type = PerformanceTuning.CHAPTERS_AXIS_TYPE;
                break;
            }
            case -1: {
                type = PerformanceTuning.SLICERS_AXIS_TYPE;
                break;
            }
            default: {
                type = -2;
            }
        }
        return type;
    }

    public int getDirection() {
        return ((TupleReader)this.tupleCache.getSecondaryCache()).direction;
    }

    @SASScope
    public class TupleReader
    implements StaticCacheInterface {
        int direction = 256;

        public Object getFromCache(long key) throws CacheException {
            Object[] tuples = this.getFromCache(key, key, false);
            return tuples.length > 0 ? tuples[0] : null;
        }

        public Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
            return this.getFromCache(keys[0], keys[keys.length - 1], readFully);
        }

        public Object[] getFromCache(long startKey, long endKey, boolean readFully) throws CacheException {
            try {
                if (startKey >= 0L && endKey < (long)AxisCache.this.tupleCount) {
                    return this.getTuplesWithoutContext((int)startKey, (int)endKey);
                }
            }
            catch (OLAPException oe) {
                throw new CacheException(OLAPUtil.getExceptionMessage(oe));
            }
            return OLAPUtil.EMPTY_OBJECT_ARRAY;
        }

        private TupleInterface[] getTuplesWithoutContext(int startKey, int endKey) throws OLAPException {
            TupleInterface[] tuples = null;
            int axisCount = AxisCache.this.dataCache.getAxesCount();
            int[] firstTuple = new int[axisCount];
            Arrays.fill(firstTuple, 0);
            int[] maxTuples = new int[axisCount];
            Arrays.fill(maxTuples, 0);
            int axisNumber = AxisCache.this.axis.getAxisNumber();
            if (axisNumber == -1) {
                axisNumber = axisCount - 1;
            }
            firstTuple[axisNumber] = startKey;
            maxTuples[axisNumber] = Math.min(endKey - startKey + 1, AxisCache.this.tupleCount);
            boolean[] tuplePropInclusionMask = OLAPUtil.EMPTY_BOOLEAN_ARRAY;
            StringSeqHolder axisTupleProps = new StringSeqHolder();
            LongSeqHolder axisNumRead = new LongSeqHolder();
            try {
                AxisCache.this.dataCache.getIMDDataSet().ReadTuples(firstTuple, maxTuples, tuplePropInclusionMask, axisTupleProps, axisNumRead);
            }
            catch (Exception ex) {
                throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
            }
            int[] numTuples = axisNumRead.value;
            int cnt = Math.min(numTuples[axisNumber], Math.abs(endKey - startKey + 1));
            tuples = new TupleInterface[cnt];
            int groupIndex = -1;
            int axisTuplePropsOffset = 0;
            String[] axisTupleProperties = axisTupleProps.value;
            ArrayList<String> uniqueLevelHeaders = new ArrayList<String>(AxisCache.this.baseTupleDepth);
            for (int i = 0; i < tuples.length; ++i) {
                String[] memberUniqueNames = new String[AxisCache.this.baseTupleDepth];
                String[] memberLabels = new String[AxisCache.this.baseTupleDepth];
                String[] levelUniqueNames = new String[AxisCache.this.baseTupleDepth];
                String[] levelDepths = new String[AxisCache.this.baseTupleDepth];
                String[] displayInfos = new String[AxisCache.this.baseTupleDepth];
                LinkedHashMap[] properties = new LinkedHashMap[AxisCache.this.baseTupleDepth];
                TupleElementType[] types = new TupleElementType[AxisCache.this.baseTupleDepth];
                for (int j = 0; j < AxisCache.this.baseTupleDepth; ++j) {
                    String label;
                    memberUniqueNames[j] = axisTupleProperties[axisTuplePropsOffset];
                    memberLabels[j] = axisTupleProperties[axisTuplePropsOffset + 1];
                    levelUniqueNames[j] = axisTupleProperties[axisTuplePropsOffset + 2];
                    types[j] = this.getMeasureType(levelUniqueNames[j]);
                    if (types[j] == TupleElementType.MEASURE && (label = this.getMemberLabelIfPresent(memberUniqueNames[j])) != null) {
                        memberLabels[j] = label;
                    }
                    if (memberLabels[j].length() > 1 && memberLabels[j].startsWith("&")) {
                        char c = memberLabels[j].charAt(1);
                        if (c == 'T') {
                            types[j] = TupleElementType.TOTAL;
                            memberLabels[j] = memberLabels[j].substring(2, memberLabels[j].length());
                        } else if (c == 'S') {
                            types[j] = TupleElementType.SUBTOTAL;
                            memberLabels[j] = memberLabels[j].substring(2, memberLabels[j].length());
                        } else if (Character.isDigit(c) && types[j] == TupleElementType.MEASURE) {
                            memberUniqueNames[j] = memberUniqueNames[j].replaceFirst(memberLabels[j].substring(0, 2), "");
                            memberLabels[j] = memberLabels[j].substring(2, memberLabels[j].length());
                        }
                    }
                    levelDepths[j] = axisTupleProperties[axisTuplePropsOffset + 3];
                    displayInfos[j] = axisTupleProperties[axisTuplePropsOffset + 4];
                    properties[j] = new LinkedHashMap(AxisCache.this.propertyNames[j].length);
                    for (int k = 0; k < AxisCache.this.propertyNames[j].length; ++k) {
                        if (AxisCache.this.propertyNames[j][k].toUpperCase().indexOf(TOTAL_PROPERTY_KEY) >= 0) {
                            String propValue = axisTupleProps.value[axisTuplePropsOffset + 5 + k];
                            if (propValue == null || propValue.length() <= 0) continue;
                            int poundIndex = memberLabels[j].lastIndexOf(MULTILABEL_MARKER);
                            if (poundIndex >= 0) {
                                memberLabels[j] = memberLabels[j].substring(0, poundIndex);
                            }
                            memberUniqueNames[j] = propValue;
                            types[j] = TupleElementType.SUBTOTAL;
                            properties[j].clear();
                            continue;
                        }
                        if (AxisCache.this.propertyNames[j][k].toUpperCase().indexOf(GROUP_PROPERTY_KEY) >= 0) {
                            String value = axisTupleProps.value[axisTuplePropsOffset + 5 + k];
                            if (types[j] != TupleElementType.MEASURE) continue;
                            types[j] = TupleElementType.GROUP;
                            groupIndex = j;
                            properties[j].put(AxisCache.this.propertyNames[j][k], value);
                            continue;
                        }
                        if (types[j] == TupleElementType.SUBTOTAL) continue;
                        properties[j].put(AxisCache.this.propertyNames[j][k], axisTupleProps.value[axisTuplePropsOffset + 5 + k]);
                    }
                    axisTuplePropsOffset += 5 + AxisCache.this.propertyNames[j].length;
                }
                tuples[i] = new Tuple(AxisCache.this.axis, startKey++);
                TupleElementInterface[] tupleElements = new TupleElementInterface[AxisCache.this.baseTupleDepth];
                for (int j = 0; j < AxisCache.this.baseTupleDepth; ++j) {
                    if (j > 0 && (types[j - 1] == TupleElementType.TOTAL || types[j - 1] == TupleElementType.SUBTOTAL) && Integer.parseInt(levelDepths[j]) == 0 && types[j] != TupleElementType.MEASURE && types[j] != TupleElementType.GROUP) {
                        memberLabels[j] = "";
                        types[j] = TupleElementType.SUBTOTAL;
                        properties[j].clear();
                    }
                    tupleElements[j] = new TupleElement(tuples[i], j, memberUniqueNames[j], memberLabels[j], levelUniqueNames[j], levelDepths[j], displayInfos[j], properties[j], types[j]);
                    if (i != 0) continue;
                    uniqueLevelHeaders.add(levelUniqueNames[j]);
                }
                ((Tuple)tuples[i]).setElements(tupleElements);
                ((Tuple)tuples[i]).setTupleDepth(tupleElements.length);
                if (i != 0) continue;
                AxisCache.this.tupleCache.setMaximumTupleDepth(tuples[i].getElements(0, -1).length);
            }
            if (AxisCache.this.dataCache.getOLAPDataSet().getContextType() == 1) {
                if (groupIndex >= 0) {
                    AxisCache.this.tupleCache.processGroupedMeasures(tuples, groupIndex, uniqueLevelHeaders, null);
                }
                AxisCache.this.tupleCache.setAxisHeaders(uniqueLevelHeaders, null);
            }
            this.calculateTotal(tuples);
            return tuples;
        }

        String getMemberLabelIfPresent(String uniqueMemberName) throws OLAPException {
            OLAPDataSetInterface olapDataSet = AxisCache.this.dataCache.getOLAPDataSet();
            Map<String, String> m = ((OLAPDataSet)olapDataSet).getMeasureLabelMap();
            if (m != null && m.containsKey(uniqueMemberName.toUpperCase())) {
                return m.get(uniqueMemberName.toUpperCase(olapDataSet.getLocale()));
            }
            return null;
        }

        private TupleElementType getMeasureType(String levelName) throws OLAPException {
            Filter f = new Filter();
            OLAPDataSetInterface olapDataSet = AxisCache.this.dataCache.getOLAPDataSet();
            f.setCubeName(olapDataSet.getCubeName());
            f.setUniqueLevelName(levelName);
            LevelInterface level = null;
            level = olapDataSet.getDatabaseMetadata().getLevel(f);
            DimensionInterface d = level.getHierarchy().getDimension();
            if (d.getType() == 2) {
                return TupleElementType.MEASURE;
            }
            return TupleElementType.UNSPECIFIED;
        }

        public void calculateTotal(TupleInterface[] tuples) throws OLAPException {
            TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel(0, tuples, true, -1);
            TupleElementInterface element = null;
            int minimumLevelDepth = -1;
            if (elements.length > 0) {
                if (elements[0].getType() == TupleElementType.MEASURE || elements[0].getType() == TupleElementType.GROUP) {
                    elements = OLAPUtil.getTupleElementsForLevel(1, tuples, true, -1);
                }
                if (elements == null || elements.length == 0) {
                    return;
                }
                minimumLevelDepth = elements[0].getLevelDepth();
            }
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].getType() != TupleElementType.SUBTOTAL) continue;
                if (minimumLevelDepth > elements[i].getLevelDepth()) {
                    minimumLevelDepth = elements[i].getLevelDepth();
                    element = elements[i];
                    continue;
                }
                if (minimumLevelDepth != elements[i].getLevelDepth()) continue;
                if (element == null) {
                    element = elements[i];
                    continue;
                }
                if (elements[i] == null || elements[i].getLevelDepth() != 0) continue;
                ((TupleElement)elements[i]).setType(TupleElementType.TOTAL);
                String totalLabel = ((OLAPDataSet)AxisCache.this.dataCache.getOLAPDataSet()).getTotalLabel();
                String label = totalLabel != null ? totalLabel : TOTAL_LABEL;
                ((TupleElement)elements[i]).setLabel(label);
            }
            if (element != null && element.getLevelDepth() == 0) {
                ((TupleElement)element).setType(TupleElementType.TOTAL);
                String totalLabel = ((OLAPDataSet)AxisCache.this.dataCache.getOLAPDataSet()).getTotalLabel();
                String label = totalLabel != null ? totalLabel : TOTAL_LABEL;
                ((TupleElement)element).setLabel(label);
            }
        }

        public long[] computeCacheKeyRange(long startKey, long endKey, int lookAhead) throws CacheException {
            long[] keys;
            int count = AxisCache.this.tupleCount;
            if (endKey == -1L || endKey > (long)count) {
                endKey = count - 1;
            }
            if (AxisCache.this.tupleCache.cacheContainsKey((int)startKey) && AxisCache.this.tupleCache.cacheContainsKey((int)endKey)) {
                keys = SequentialCache.computeSequentialKeyRange((long)startKey, (long)endKey, (int)0);
            } else {
                int range = (int)(endKey - startKey);
                if (lookAhead > 0 && range > lookAhead) {
                    if (range > count) {
                        endKey = count - 1;
                    }
                } else if (lookAhead > 0 && range < lookAhead) {
                    endKey = startKey + (long)lookAhead > (long)count ? (long)(count - 1) : startKey + (long)lookAhead - 1L;
                    lookAhead = 0;
                }
                keys = SequentialCache.computeSequentialKeyRange((long)startKey, (long)endKey, (int)lookAhead);
            }
            return keys;
        }

        public long[] getCacheKeys() throws CacheException {
            return null;
        }

        public boolean cacheContainsKey(long key) throws CacheException {
            return false;
        }

        public int getCacheKeyUse() {
            return 0;
        }

        public void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int threshholdVale, int accessType) throws CacheException {
        }

        public void useBufferHints(BufferHints hints) {
            while (hints != null) {
                if (hints.what == 16384) {
                    this.direction = hints.how;
                }
                hints = hints.moreHints;
            }
        }

        public int count() {
            return 0;
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }

        public void setAncestorInfo(String tupleElementName, int ancestor, Map cachedProp) throws OLAPException {
            AxisCache.this.dataCache.setAncestorInfo(tupleElementName, ancestor, cachedProp);
        }

        public Map getAncestorInfo(String tupleElementName, int ancestor) throws OLAPException {
            return AxisCache.this.dataCache.getAncestorInfo(tupleElementName, ancestor);
        }

        public void setCubeNameHint(String cubeName) {
            AxisCache.this.dataCache.setCubeNameHint(cubeName);
        }

        public String getCubeNameHint() {
            return AxisCache.this.dataCache.getCubeNameHint();
        }
    }
}

