/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.embedded;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.Map;

@SASScope(value="ALL")
public class TupleElement
implements TupleElementInterface {
    private String label;
    private String name;
    private String levelName;
    private boolean isDrilledDown;
    private boolean sameParent;
    private int childCount;
    private Map properties;
    private int minimumCoordinate;
    private int maximumCoordinate;
    private int levelDepth;
    private boolean isContextual;
    private TupleInterface parentTuple;
    private int elementIndex;
    private int span;
    private int spanDepth;
    private TupleElementType type;

    public TupleElement() {
        this("");
    }

    public TupleElement(String name) {
        this.name = name != null ? name : "";
        this.minimumCoordinate = -1;
        this.maximumCoordinate = -1;
        this.span = 1;
        this.spanDepth = 1;
        this.type = TupleElementType.UNSPECIFIED;
    }

    public TupleElement(TupleElementInterface tupleElement) throws OLAPException {
        this.name = tupleElement.getName();
        this.label = tupleElement.getLabel();
        this.levelName = tupleElement.getUniqueLevelName();
        this.minimumCoordinate = tupleElement.getMinimumCoordinate();
        this.maximumCoordinate = tupleElement.getMaximumCoordinate();
        this.span = tupleElement.getSpan();
        this.spanDepth = tupleElement.getSpanDepth();
        this.parentTuple = tupleElement.getTuple();
        this.type = tupleElement.getType();
    }

    public void setType(TupleElementType elementType) throws OLAPException {
        this.type = elementType;
    }

    @Override
    public TupleElementType getType() throws OLAPException {
        return this.type;
    }

    public void setLabel(String label) throws OLAPException {
        this.label = label;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label == null ? this.name : this.label;
    }

    public void setName(String name) throws OLAPException {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueLevelName() throws OLAPException {
        return this.levelName;
    }

    public void setUniqueLevelName(String uniqueLevelName) throws OLAPException {
        this.levelName = uniqueLevelName;
    }

    public void setDrilledDown(boolean isDrilledDown) throws OLAPException {
        this.isDrilledDown = isDrilledDown;
    }

    @Override
    public boolean isDrilledDown() throws OLAPException {
        return this.isDrilledDown;
    }

    public void setContinued(boolean isContinued) throws OLAPException {
        this.sameParent = isContinued;
    }

    @Override
    public boolean isContinued() throws OLAPException {
        return this.sameParent;
    }

    public void setChildCount(int childCount) throws OLAPException {
        this.childCount = childCount;
    }

    @Override
    public int getChildCount() throws OLAPException {
        return this.childCount;
    }

    public void setProperties(Map properties) throws OLAPException {
        this.properties = properties;
    }

    @Override
    public Map getProperties() throws OLAPException {
        return this.properties;
    }

    @Override
    public int getSpan() throws OLAPException {
        return this.span;
    }

    @Override
    public void setSpan(int span) throws OLAPException {
        this.span = span;
    }

    @Override
    public void setMinimumCoordinate(int minimumCoordinate) throws OLAPException {
        this.minimumCoordinate = minimumCoordinate;
    }

    @Override
    public int getMinimumCoordinate() throws OLAPException {
        return this.minimumCoordinate;
    }

    @Override
    public void setMaximumCoordinate(int maximumCoordinate) throws OLAPException {
        this.maximumCoordinate = maximumCoordinate;
    }

    @Override
    public int getMaximumCoordinate() throws OLAPException {
        return this.maximumCoordinate;
    }

    @Override
    public TupleInterface getTuple() throws OLAPException {
        return this.parentTuple;
    }

    public void setTuple(TupleInterface tuple) throws OLAPException {
        this.parentTuple = tuple;
    }

    @Override
    public int getTupleElementIndex() throws OLAPException {
        return this.elementIndex;
    }

    void setTupleElementIndex(int index) throws OLAPException {
        this.elementIndex = index;
    }

    @Override
    public int getLevelDepth() throws OLAPException {
        return this.levelDepth;
    }

    public void setLevelDepth(int levelDepth) throws OLAPException {
        this.levelDepth = levelDepth;
    }

    @Override
    public boolean isContextual() throws OLAPException {
        return this.isContextual;
    }

    public void setContextual(boolean isContextual) throws OLAPException {
        this.isContextual = isContextual;
    }

    @Override
    public String getFormat() throws OLAPException {
        return null;
    }

    @Override
    public int getSpanDepth() throws OLAPException {
        return this.spanDepth;
    }

    @Override
    public void setSpanDepth(int depth) {
        this.spanDepth = depth;
    }

    public String toString() {
        try {
            return this.getLabel();
        }
        catch (OLAPException oe) {
            return super.toString();
        }
    }
}

