/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class OLAPUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final TupleInterface[] EMPTY_TUPLE_ARRAY = new TupleInterface[0];

    private OLAPUtil() {
    }

    public static int calculateCellOrdinal(ResultSetMetadataInterface resultSetMetadata, int[] coordinates) throws OLAPException {
        AxisInterface[] axes = resultSetMetadata.getAxes(0, -1);
        int cellOrdinal = coordinates[0];
        int multiplier = 1;
        for (int i = 1; i < coordinates.length; ++i) {
            cellOrdinal += coordinates[i] * (multiplier *= axes[i - 1].getTupleCount());
        }
        return cellOrdinal;
    }

    public static int[] calculateTupleCoordinates(ResultSetMetadataInterface resultSetMetadata, int cellOrdinal) throws OLAPException {
        int numAxes;
        AxisInterface[] axes = resultSetMetadata.getAxes(0, -1);
        if (axes[(numAxes = axes.length) - 1].getAxisNumber() == -1 && numAxes > 1) {
            --numAxes;
        }
        int[] coordinates = new int[numAxes];
        int[] axisSizes = new int[numAxes];
        if (numAxes > 0) {
            axisSizes[0] = 1;
            for (int i = 1; i < numAxes; ++i) {
                axisSizes[i] = axisSizes[i - 1] * axes[i - 1].getTupleCount();
            }
        }
        int computedOrdinal = cellOrdinal;
        for (int i = numAxes - 1; i > 0; --i) {
            coordinates[i] = computedOrdinal / axisSizes[i];
            computedOrdinal %= axisSizes[i];
        }
        coordinates[0] = computedOrdinal;
        return coordinates;
    }

    @SASScope
    public static int getMaximumTupleDepth(TupleInterface[] tuples) throws OLAPException {
        int maximumTupleDepth = 0;
        for (int i = 0; i < tuples.length; ++i) {
            if (tuples[i].getTupleDepth() <= maximumTupleDepth) continue;
            maximumTupleDepth = tuples[i].getTupleDepth();
        }
        return maximumTupleDepth;
    }

    @SASScope
    public static String[] getInitialHeaders(TupleInterface[] tuples) throws OLAPException {
        return null;
    }

    public static void calculateMinMaxCoordinates(TupleInterface[] tuples) throws OLAPException {
        if (tuples != null && tuples.length > 0) {
            int j;
            int i;
            AxisInterface a = tuples[0].getAxis();
            int tupleDepth = a.getMaximumTupleDepth();
            if (a instanceof Axis) {
                tupleDepth = ((Axis)a).getTupleDepth();
            }
            for (int i2 = 0; i2 < tuples.length; ++i2) {
                tupleDepth = Math.max(tupleDepth, tuples[i2].getTupleDepth());
            }
            int[] minimumCoordinates = new int[tupleDepth];
            int maximumCoordinate = -1;
            for (int j2 = 0; j2 < tupleDepth; ++j2) {
                minimumCoordinates[j2] = tuples[0].getTupleIndex();
            }
            TupleElementInterface[][] tupleElements = new TupleElementInterface[tuples.length][];
            for (i = 0; i < tuples.length; ++i) {
                tupleElements[i] = tuples[i].getElements(0, -1);
                tupleDepth = tupleElements[i].length;
                for (j = 0; j < tupleDepth; ++j) {
                    int previousMinimumCoordinate;
                    int newMaximumCoordinate;
                    int previousMaximumCoordinate;
                    int l;
                    int k;
                    boolean isSameName = false;
                    if (i > 0 && j < tupleElements[i - 1].length) {
                        isSameName = OLAPUtil.isSameName(tupleElements[i - 1][j], tupleElements[i][j]);
                    }
                    if (!isSameName || isSameName && tupleElements[i][j].getSpan() != tupleElements[i - 1][j].getSpan() || isSameName && j == tupleElements[i - 1].length - 1) {
                        for (k = minimumCoordinates[j]; k < tuples[i].getTupleIndex(); ++k) {
                            l = k - tuples[0].getTupleIndex();
                            if (j == 0) {
                                tupleElements[l][j].setMaximumCoordinate(tuples[i - 1].getTupleIndex());
                                continue;
                            }
                            if (j >= tupleElements[l].length) continue;
                            previousMaximumCoordinate = tupleElements[l][j - 1].getMaximumCoordinate();
                            newMaximumCoordinate = previousMaximumCoordinate != -1 && previousMaximumCoordinate < tuples[i - 1].getTupleIndex() ? previousMaximumCoordinate : tuples[i - 1].getTupleIndex();
                            tupleElements[l][j].setMaximumCoordinate(newMaximumCoordinate);
                            previousMinimumCoordinate = tupleElements[l][j - 1].getMinimumCoordinate();
                            if (previousMinimumCoordinate <= tupleElements[l][j].getMinimumCoordinate()) continue;
                            tupleElements[l][j].setMinimumCoordinate(previousMinimumCoordinate);
                        }
                        minimumCoordinates[j] = tuples[i].getTupleIndex();
                    }
                    if ((i == tuples.length - 1 || j >= tuples[i + 1].getTupleDepth()) && minimumCoordinates[j] != tuples[i].getTupleIndex()) {
                        for (k = minimumCoordinates[j]; k <= tuples[i].getTupleIndex(); ++k) {
                            l = k - tuples[0].getTupleIndex();
                            if (j == 0) {
                                tupleElements[l][j].setMaximumCoordinate(tuples[i].getTupleIndex());
                                continue;
                            }
                            previousMaximumCoordinate = tupleElements[l][j - 1].getMaximumCoordinate();
                            newMaximumCoordinate = previousMaximumCoordinate != -1 && previousMaximumCoordinate < tuples[i].getTupleIndex() ? previousMaximumCoordinate : tuples[i].getTupleIndex();
                            tupleElements[l][j].setMaximumCoordinate(newMaximumCoordinate);
                            previousMinimumCoordinate = tupleElements[l][j - 1].getMinimumCoordinate();
                            if (previousMinimumCoordinate <= tupleElements[l][j].getMinimumCoordinate()) continue;
                            tupleElements[l][j].setMinimumCoordinate(previousMinimumCoordinate);
                        }
                    }
                    maximumCoordinate = -1;
                    if (i == tuples.length - 1 || j >= tuples[i + 1].getTupleDepth()) {
                        maximumCoordinate = tuples[i].getTupleIndex();
                        if (j > 0 && minimumCoordinates[j - 1] > minimumCoordinates[j]) {
                            minimumCoordinates[j] = minimumCoordinates[j - 1];
                        }
                    }
                    tupleElements[i][j].setMinimumCoordinate(minimumCoordinates[j]);
                    tupleElements[i][j].setMaximumCoordinate(maximumCoordinate);
                }
            }
            for (i = 0; i < tuples.length; ++i) {
                for (j = 0; j < tuples[i].getTupleDepth(); ++j) {
                    if (j >= tupleElements[i].length - 1) continue;
                    int nextMaxCoordinate = tupleElements[i][j + 1].getMaximumCoordinate();
                    int maxCoordinate = tupleElements[i][j].getMaximumCoordinate();
                    if (maxCoordinate < nextMaxCoordinate) {
                        tupleElements[i][j + 1].setMaximumCoordinate(maxCoordinate);
                    }
                    if (tupleElements[i][j].getMinimumCoordinate() <= tupleElements[i][j + 1].getMinimumCoordinate()) continue;
                    tupleElements[i][j + 1].setMinimumCoordinate(tupleElements[i][j].getMinimumCoordinate());
                }
            }
        }
    }

    private static boolean isSameName(TupleElementInterface prevElement, TupleElementInterface currentElement) throws OLAPException {
        boolean isSameType;
        boolean isSame = false;
        if (prevElement == null) {
            isSame = true;
        }
        boolean bl = isSameType = prevElement.getType() == currentElement.getType();
        if (isSameType && prevElement.getName().equalsIgnoreCase(currentElement.getName())) {
            isSame = true;
        }
        return isSame;
    }

    @SASScope
    public static String getExceptionMessage(Throwable exception) {
        String msg = exception.getMessage();
        return msg == null ? exception.toString() : msg;
    }

    @SASScope
    public static Object[] getTupleElementsForLevel(int level, TupleInterface[] tuples) throws OLAPException {
        int nTuples = tuples.length;
        ArrayList<TupleElementInterface> elements = new ArrayList<TupleElementInterface>(nTuples);
        if (level == 0) {
            for (int i = 0; i < nTuples; ++i) {
                elements.add(tuples[i].getElement(0));
            }
            return elements.toArray();
        }
        block1: for (int i = 0; i < nTuples; ++i) {
            TupleElementInterface[] tupleElements = tuples[i].getElements(0, -1);
            int nElements = tupleElements.length;
            int relativeIndex = 0;
            int oldSpan = 0;
            for (int index = 0; index < nElements; ++index) {
                oldSpan = tupleElements[index].getSpan() - tupleElements[index].getSpanDepth();
                if ((relativeIndex += oldSpan + tupleElements[index].getSpanDepth()) == level + 1) {
                    elements.add(tupleElements[index]);
                    continue block1;
                }
                if (relativeIndex > level) continue block1;
            }
        }
        return elements.toArray();
    }

    public static TupleElementInterface[] getTupleElementsForLevel(int level, TupleInterface[] tuples, boolean includeDuplicates, int count) throws OLAPException {
        int nTuples = tuples.length;
        ArrayList<TupleElementInterface> elements = new ArrayList<TupleElementInterface>(nTuples);
        TupleElementInterface[] tupleElements = new TupleElementInterface[nTuples];
        ArrayList<String> elemNames = new ArrayList<String>(nTuples);
        if (level == 0) {
            if (count != -1 && count < nTuples) {
                nTuples = count;
            }
            for (int i = 0; i < nTuples; ++i) {
                TupleElementInterface tElement = tuples[i].getElement(0);
                if (!includeDuplicates && (includeDuplicates || elemNames.contains(tElement.getName()))) continue;
                elements.add(tElement);
                elemNames.add(tElement.getName());
            }
            tupleElements = new TupleElementInterface[elements.size()];
            System.arraycopy(elements.toArray(), 0, tupleElements, 0, elements.size());
            return tupleElements;
        }
        int currentCount = count == -1 ? nTuples * -1 : 0;
        block1: for (int i = 0; i < nTuples; ++i) {
            tupleElements = tuples[i].getElements(0, -1);
            int nElements = tupleElements.length;
            int relativeIndex = 0;
            int oldSpan = 0;
            for (int index = 0; index < nElements && currentCount <= count; ++index) {
                oldSpan = tupleElements[index].getSpan() - tupleElements[index].getSpanDepth();
                if ((relativeIndex += oldSpan + tupleElements[index].getSpanDepth()) == level + 1) {
                    if (includeDuplicates || !includeDuplicates && !elemNames.contains(tupleElements[index].getName())) {
                        elements.add(tupleElements[index]);
                        elemNames.add(tupleElements[index].getName());
                    }
                    ++currentCount;
                    continue block1;
                }
                if (relativeIndex > level) continue block1;
            }
        }
        tupleElements = new TupleElementInterface[elements.size()];
        System.arraycopy(elements.toArray(new TupleElementInterface[0]), 0, tupleElements, 0, elements.size());
        return tupleElements;
    }

    @SASScope
    public static boolean isAllLevel(LevelInterface level) throws OLAPException {
        if (level != null) {
            int memberCount = level.getMemberCount();
            int depth = level.getDepth();
            int type = level.getType();
            if (memberCount == 1 && depth == 0 && type == 2) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAllElement(TupleElementInterface element) throws OLAPException {
        if (element != null) {
            int memberCount = element.getChildCount();
            int depth = element.getLevelDepth();
            TupleElementType type = element.getType();
            if (memberCount == 1 && depth == 0 && type != TupleElementType.MEASURE) {
                return true;
            }
        }
        return false;
    }

    private static boolean isTotalElement(TupleElementInterface element) throws OLAPException {
        return element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL;
    }

    private static boolean isMeasureElement(TupleElementInterface element) throws OLAPException {
        return element.getType() == TupleElementType.MEASURE;
    }

    private static boolean isGroupElement(TupleElementInterface element) throws OLAPException {
        return element.getType() == TupleElementType.GROUP;
    }

    public static void calculateSpan(TupleInterface[] tuples) throws OLAPException {
        if (tuples == null || tuples.length == 0) {
            return;
        }
        AxisInterface axis = tuples[0].getAxis();
        String[] uniqueLevelNames = axis.getUniqueLevelNames();
        String[] hierArray = axis.getHierarchyNames();
        if (!OLAPUtil.isValid(uniqueLevelNames) || !OLAPUtil.isValid(hierArray)) {
            return;
        }
        Map dimMap = OLAPUtil.getHierarchyMap(axis);
        for (int row = 0; row < tuples.length; ++row) {
            boolean totalSpan = false;
            TupleInterface tuple = tuples[row];
            TupleElementInterface[] elements = tuple.getElements(0, -1);
            String hierarchyName = hierArray[elements[0].getTupleElementIndex()];
            int[] minMaxArray = (int[])dimMap.get(hierarchyName);
            int minIndex = minMaxArray[0];
            int maxIndex = minMaxArray[1];
            int col = 0;
            int levelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[col].getUniqueLevelName());
            if (levelElementIndex < 0) {
                levelElementIndex = minIndex;
            }
            int nextLevelElementIndex = maxIndex;
            if (elements.length > 1) {
                nextLevelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[col + 1].getUniqueLevelName());
                if (nextLevelElementIndex < 0 && (elements[col + 1].getLevelDepth() == 0 || OLAPUtil.isTotalElement(elements[col + 1]))) {
                    if (OLAPUtil.isTotalElement(elements[0]) && !OLAPUtil.isMeasureElement(elements[col + 1]) && !OLAPUtil.isGroupElement(elements[col + 1])) {
                        for (int k = col + 1; k < elements.length; ++k) {
                            if (!OLAPUtil.isMeasureElement(elements[k]) && !OLAPUtil.isGroupElement(elements[k])) continue;
                            nextLevelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[k].getUniqueLevelName());
                            if (OLAPUtil.isMeasureElement(elements[k]) && elements[k].getSpan() > 1) {
                                --nextLevelElementIndex;
                            }
                            ++col;
                            while (col < k) {
                                elements[col].setSpan(0);
                                elements[col].setSpanDepth(0);
                                ++col;
                            }
                            col = k - 1;
                            break;
                        }
                        if (nextLevelElementIndex < 0) {
                            nextLevelElementIndex = axis.getMaximumTupleDepth();
                            totalSpan = true;
                        }
                    } else {
                        nextLevelElementIndex = maxIndex;
                    }
                } else if (nextLevelElementIndex < 0) {
                    nextLevelElementIndex = minIndex;
                } else if (nextLevelElementIndex > maxIndex) {
                    nextLevelElementIndex = maxIndex;
                }
            }
            int spanDepth = levelElementIndex + 1;
            int span = nextLevelElementIndex - levelElementIndex + spanDepth - 1;
            if (nextLevelElementIndex - levelElementIndex > 1 && elements[col].isContextual()) {
                span = spanDepth;
            }
            elements[0].setSpan(span);
            elements[0].setSpanDepth(spanDepth);
            ++col;
            while (col < elements.length) {
                if (OLAPUtil.isMeasureElement(elements[col]) || OLAPUtil.isGroupElement(elements[col])) {
                    if (elements[col].getSpan() != elements[col].getSpanDepth()) {
                        elements[col].setSpan(1);
                        elements[col].setSpanDepth(1);
                    }
                } else if (totalSpan) {
                    elements[col].setSpan(0);
                    elements[col].setSpanDepth(0);
                } else {
                    int prevLevelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[col - 1].getUniqueLevelName());
                    if (prevLevelElementIndex < 0) {
                        prevLevelElementIndex = levelElementIndex;
                    }
                    if ((levelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[col].getUniqueLevelName())) < 0) {
                        levelElementIndex = nextLevelElementIndex;
                    }
                    hierarchyName = hierArray[levelElementIndex];
                    minMaxArray = (int[])dimMap.get(hierarchyName);
                    minIndex = minMaxArray[0];
                    nextLevelElementIndex = maxIndex = minMaxArray[1];
                    if (col + 1 < elements.length) {
                        nextLevelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[col + 1].getUniqueLevelName());
                        if (nextLevelElementIndex < 0 && (elements[col + 1].getLevelDepth() == 0 || OLAPUtil.isTotalElement(elements[col + 1]))) {
                            if (OLAPUtil.isTotalElement(elements[col]) && !OLAPUtil.isMeasureElement(elements[col + 1]) && !OLAPUtil.isGroupElement(elements[col + 1])) {
                                for (int k = col + 1; k < elements.length; ++k) {
                                    if (!OLAPUtil.isMeasureElement(elements[k]) && !OLAPUtil.isGroupElement(elements[k])) continue;
                                    nextLevelElementIndex = OLAPUtil.elemBelongsTo(uniqueLevelNames, elements[k].getUniqueLevelName());
                                    break;
                                }
                                if (nextLevelElementIndex < 0) {
                                    nextLevelElementIndex = axis.getMaximumTupleDepth();
                                    totalSpan = true;
                                }
                            } else {
                                nextLevelElementIndex = maxIndex;
                            }
                        } else if (nextLevelElementIndex < 0) {
                            nextLevelElementIndex = minIndex;
                        } else if (nextLevelElementIndex > maxIndex) {
                            nextLevelElementIndex = maxIndex;
                        }
                    }
                    spanDepth = levelElementIndex - prevLevelElementIndex - (elements[col - 1].getSpan() - elements[col - 1].getSpanDepth());
                    span = nextLevelElementIndex - levelElementIndex;
                    if (nextLevelElementIndex - levelElementIndex > 1 && elements[col].isContextual()) {
                        span = spanDepth;
                    } else if (levelElementIndex - prevLevelElementIndex > 1 && (elements[col - 1].isContextual() || levelElementIndex - minIndex > 0)) {
                        spanDepth = levelElementIndex - prevLevelElementIndex;
                        span = nextLevelElementIndex - prevLevelElementIndex - (elements[col - 1].getSpan() - elements[col - 1].getSpanDepth()) - 1;
                    }
                    elements[col].setSpan(span);
                    elements[col].setSpanDepth(spanDepth);
                }
                ++col;
            }
        }
    }

    private static int elemBelongsTo(String[] levelHeaders, String name) throws OLAPException {
        if (levelHeaders != null) {
            for (int i = 0; i < levelHeaders.length; ++i) {
                if (!name.equals(levelHeaders[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static Map getHierarchyMap(AxisInterface axis) throws OLAPException {
        int[] v;
        int i;
        HashMap<String, int[]> hierMap = new HashMap<String, int[]>();
        String[] h = axis.getHierarchyNames();
        String currentHier = h[0];
        int min = 0;
        for (i = 1; i < h.length; ++i) {
            if (!currentHier.equals(h[i])) {
                v = new int[]{min, i};
                hierMap.put(currentHier, v);
                min = i;
            }
            currentHier = h[i];
        }
        if (i - 1 == h.length - 1) {
            v = new int[]{min, i};
            hierMap.put(currentHier, v);
        }
        return hierMap;
    }

    private static boolean isValid(String[] nameArray) {
        if (nameArray != null && nameArray.length > 0) {
            for (int i = 0; i < nameArray.length; ++i) {
                if (nameArray[i] != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

