/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc.export;

import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.storage.jdbc.export.SAStoExcelUtil;
import com.sas.table.FormattedInterface;
import com.sas.util.UncheckedException;
import com.sas.util.transforms.ObjectToStringTransform;
import java.io.Writer;
import java.util.Locale;
import javax.swing.table.TableModel;

public class RelationalTableModelExporter {
    protected static final String TABLE_MODEL_RELATIONAL_QUERY_RUNNER_CLASS_NAME = "TableModelRelationalQueryRunner";

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter) {
        RelationalTableModelExporter.writeToStream(model, writer, exporter, RelationalTableModelExporter.getColumnIndexes(model), 0, -1);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int startRow, int rowCount, boolean isRawData) {
        RelationalTableModelExporter.writeToStream(model, writer, exporter, startRow, rowCount, isRawData, null);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int startRow, int rowCount, boolean isRawData, Locale locale) {
        if (!isRawData && !(model instanceof FormattedInterface)) {
            isRawData = true;
        }
        RelationalTableModelExporter.writeToStream(model, writer, exporter, RelationalTableModelExporter.getColumnIndexes(model), startRow, rowCount, isRawData, locale);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int[] columns, int startRow, int rowCount) {
        RelationalTableModelExporter.writeToStream(model, writer, exporter, columns, startRow, rowCount, false);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int[] columns, int startRow, int rowCount, boolean isRawData) {
        RelationalTableModelExporter.writeToStream(model, writer, exporter, columns, startRow, rowCount, isRawData, null);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int[] columns, int startRow, int rowCount, boolean isRawData, Locale locale) {
        RelationalTableModelExporter.writeToStream(model, writer, exporter, startRow, rowCount, isRawData, locale, columns, null, null);
    }

    public static void writeToStream(TableModel model, Writer writer, RelationalExportInterface exporter, int startRow, int rowCount, boolean isRawData, Locale locale, int[] ocolumns, String[] headers, String[] footers) {
        int[] columns = ocolumns;
        if (columns == null) {
            columns = RelationalTableModelExporter.getColumnIndexes(model);
        }
        try {
            int nAvailableRows;
            int firstRow;
            int i;
            Object[] rowValues = new Object[columns.length];
            writer.write(exporter.getFileHeader());
            if (headers != null) {
                for (i = 0; i < headers.length; ++i) {
                    writer.write(exporter.getLine(headers[i], null));
                }
            }
            int cc = columns.length;
            for (i = 0; i < cc; ++i) {
                rowValues[i] = model.getColumnName(columns[i]);
            }
            writer.write(exporter.getColumnHeaderLine(rowValues));
            boolean isFormattedDataWanted = false;
            if (model instanceof FormattedInterface && !isRawData) {
                isFormattedDataWanted = true;
            }
            Object value = null;
            ObjectToStringTransform objectTransform = null;
            if (!isFormattedDataWanted) {
                objectTransform = locale != null ? new ObjectToStringTransform(locale) : ObjectToStringTransform.defaultInstance;
            }
            int n = firstRow = startRow >= (nAvailableRows = model.getRowCount()) ? 0 : startRow;
            int lastRow = rowCount == -1 ? nAvailableRows : (startRow + rowCount > nAvailableRows ? nAvailableRows : startRow + rowCount);
            boolean isVADSeparatedExport = model.getClass().getName().indexOf(TABLE_MODEL_RELATIONAL_QUERY_RUNNER_CLASS_NAME) != -1;
            for (int r = firstRow; r < lastRow; ++r) {
                int cc2 = columns.length;
                for (int c = 0; c < cc2; ++c) {
                    if (isFormattedDataWanted) {
                        rowValues[c] = ((FormattedInterface)model).getFormattedValueAt(r, columns[c]);
                    } else if (model instanceof FormattedInterface) {
                        try {
                            Object rawValue = ((FormattedInterface)model).getUnformattedValueAt(r, columns[c]);
                            Class unformattedClass = ((FormattedInterface)model).getUnformattedColumnClass(columns[c]);
                            String format = ((FormattedInterface)model).getFormat(columns[c]);
                            int dataType = SAStoExcelUtil.getDataType(locale, unformattedClass, format);
                            if (rawValue instanceof Double && ((Double)rawValue).isNaN()) {
                                value = "";
                            } else {
                                if (isVADSeparatedExport && Double.class == unformattedClass) {
                                    dataType = 3;
                                }
                                value = dataType == -1 ? objectTransform.transform(model.getValueAt(r, columns[c])) : (dataType == 3 ? objectTransform.transform(rawValue) : objectTransform.transform((Object)SAStoExcelUtil.getSASDateTimeValue(rawValue, dataType)));
                            }
                            rowValues[c] = value;
                        }
                        catch (Exception e) {
                            rowValues[c] = value = objectTransform.transform(model.getValueAt(r, columns[c]));
                        }
                    } else {
                        rowValues[c] = value = objectTransform.transform(model.getValueAt(r, columns[c]));
                    }
                    rowValues[c] = rowValues[c].toString().trim();
                }
                writer.write(exporter.getColumnHeaderLine(rowValues));
            }
            if (footers != null) {
                for (int i2 = 0; i2 < footers.length; ++i2) {
                    writer.write(exporter.getLine(footers[i2], null));
                }
            }
            writer.write(exporter.getFileTrailer());
            writer.flush();
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new UncheckedException((Throwable)e, null);
        }
    }

    private static int[] getColumnIndexes(TableModel model) {
        int[] columns = null;
        if (model != null) {
            int cc = model.getColumnCount();
            columns = new int[cc];
            for (int i = 0; i < cc; ++i) {
                columns[i] = i;
            }
        }
        return columns;
    }
}

