/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.storage.jdbc.RB;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;

public class JDBCDataAccessor {
    public static final String RB_KEY = "JDBCDataAccessor.";
    protected Connection dataSource;
    protected Statement statement;
    protected Statement secondaryStatement;
    protected ResultSet results;
    protected HashMap propertyMap;
    protected String queryStatement;
    protected String updateStatement;
    public static int PROPERTYMAP_PROPERTY_NAME = 0;
    public static int PROPERTYMAP_COLUMN_NAME = 1;
    public static int PROPERTYMAP_COLUMN_TYPE = 2;
    public static int PROPERTYMAP_COLUMN_INDEX = 3;
    public static int PROPERTYMAP_JDBCDATAACCESSOR_FUTURES = 4;
    public static int PROPERTYMAP_USERBASE = 5;

    public JDBCDataAccessor() {
    }

    public JDBCDataAccessor(Connection dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCDataAccessor(Connection dataSource, String queryStatement) {
        this(dataSource);
        this.queryStatement = queryStatement;
    }

    public JDBCDataAccessor(Connection dataSource, String queryStatement, String updateStatement) {
        this(dataSource, queryStatement);
        this.updateStatement = updateStatement;
    }

    public void setDataSource(Connection dataSource) throws SQLException {
        this.close();
        this.statement = null;
        this.secondaryStatement = null;
        this.results = null;
        this.dataSource = dataSource;
    }

    public Connection getDataSource() {
        return this.dataSource;
    }

    public void setStatement(Statement statement) throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        this.results = null;
        if (this.statement != null) {
            this.statement.close();
        }
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setSecondaryStatement(Statement secondaryStatement) throws SQLException {
        if (this.secondaryStatement != null) {
            this.secondaryStatement.close();
        }
        this.secondaryStatement = secondaryStatement;
    }

    public Statement getSecondaryStatement() {
        return this.secondaryStatement;
    }

    public void setResults(ResultSet results) throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        this.results = results;
    }

    public ResultSet getResults() {
        return this.results;
    }

    public void setQueryStatement(String queryStatement) {
        this.queryStatement = queryStatement;
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public void setUpdateStatement(String updateStatement) {
        this.updateStatement = updateStatement;
    }

    public String getUpdateStatement() {
        return this.updateStatement;
    }

    public HashMap getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(HashMap propertyMap) throws SQLException {
        Iterator keys = propertyMap.keySet().iterator();
        while (keys.hasNext()) {
            this.setColumnInfo((Object[])propertyMap.get(keys.next()));
        }
    }

    public void setPropertyMap(Object[][] propertyMap) throws SQLException {
        this.propertyMap = new HashMap();
        for (int i = 0; i < propertyMap.length; ++i) {
            Object[] columnInfo = new Object[]{propertyMap[i][0], propertyMap[i][1], null, -1, null};
            this.setColumnInfo(columnInfo);
            this.propertyMap.put(columnInfo[PROPERTYMAP_PROPERTY_NAME], columnInfo);
        }
    }

    public void init(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException(RB.getStringResource(RB_KEY, "connNull.ex.txt"), "08003");
        }
        if (this.statement == null) {
            this.statement = this.dataSource.createStatement(resultSetType, resultSetConcurrency);
            if (this.queryStatement == null) {
                this.queryStatement = "";
            }
            this.executeQuery(this.queryStatement);
        }
    }

    public void init() throws SQLException {
        this.init(1003, 1007);
    }

    public void executeQuery() throws SQLException {
        if (this.statement == null) {
            this.init();
        }
        this.results = this.statement.executeQuery(this.queryStatement);
    }

    public void executeQuery(String queryStatement) throws SQLException {
        this.queryStatement = queryStatement;
        this.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        if (this.statement == null) {
            this.init();
        }
        return this.statement.executeUpdate(this.updateStatement);
    }

    public int executeUpdate(String updateStatement) throws SQLException {
        this.updateStatement = updateStatement;
        return this.executeUpdate();
    }

    public void resubmitQuery() throws SQLException {
        this.executeQuery();
    }

    public void setRowValues(String[] columns, Object[] values) throws SQLException {
        if (columns.length != values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < columns.length; ++i) {
            Object[] columnInfo = (Object[])this.propertyMap.get(columns[i]);
            int columnIndex = (Integer)columnInfo[PROPERTYMAP_COLUMN_INDEX];
            int columnType = (Integer)columnInfo[PROPERTYMAP_COLUMN_TYPE];
            this.updateColumn(columnIndex, columnType, values[i]);
        }
    }

    public void setRowValues(Object[][] values) throws SQLException {
        this.setRowValues((String[])values[0], values[1]);
    }

    public Object[] getRowValues(String[] columns) throws SQLException {
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Object[] columnInfo = (Object[])this.propertyMap.get(columns[i]);
            int columnIndex = (Integer)columnInfo[PROPERTYMAP_COLUMN_INDEX];
            int columnType = (Integer)columnInfo[PROPERTYMAP_COLUMN_TYPE];
            values[i] = this.getColumnValue(columnType, columnIndex);
        }
        return values;
    }

    public Object[][] getRowValues() throws SQLException {
        Object[][] values = new Object[this.propertyMap.size()][2];
        Iterator keys = this.propertyMap.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            Object[] columnInfo = (Object[])this.propertyMap.get(keys.next());
            values[i][0] = (String)columnInfo[PROPERTYMAP_PROPERTY_NAME];
            int columnIndex = (Integer)columnInfo[PROPERTYMAP_COLUMN_INDEX];
            int columnType = (Integer)columnInfo[PROPERTYMAP_COLUMN_TYPE];
            values[i][1] = this.getColumnValue(columnType, columnIndex);
            ++i;
        }
        return values;
    }

    public void close() throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.secondaryStatement != null) {
            this.secondaryStatement.close();
        }
    }

    protected void setColumnInfo(Object[] columnInfo) throws SQLException {
        int columnIndex = this.results.findColumn((String)columnInfo[PROPERTYMAP_COLUMN_NAME]);
        ResultSetMetaData resultsMetaData = this.results.getMetaData();
        int SQLDataType = resultsMetaData.getColumnType(columnIndex);
        columnInfo[JDBCDataAccessor.PROPERTYMAP_COLUMN_TYPE] = SQLDataType;
        columnInfo[JDBCDataAccessor.PROPERTYMAP_COLUMN_INDEX] = columnIndex;
    }

    protected Object getColumnValue(int columnType, int columnIndex) throws SQLException {
        Object columnValue = null;
        if (columnType == 12) {
            columnValue = this.results.getString(columnIndex);
        } else if (columnType == 8) {
            columnValue = this.results.getDouble(columnIndex);
        } else if (columnType == 2003) {
            columnValue = this.results.getArray(columnIndex);
        } else if (columnType == -5) {
            columnValue = this.results.getLong(columnIndex);
        } else if (columnType == -2) {
            columnValue = this.results.getBytes(columnIndex);
        } else if (columnType == -7) {
            columnValue = this.results.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
        } else if (columnType == 2004) {
            columnValue = this.results.getBlob(columnIndex);
        } else if (columnType == 1) {
            columnValue = this.results.getString(columnIndex);
        } else if (columnType == 2005) {
            columnValue = this.results.getClob(columnIndex);
        } else if (columnType == 91) {
            columnValue = this.results.getDate(columnIndex);
        } else if (columnType == 3) {
            columnValue = this.results.getBigDecimal(columnIndex);
        } else {
            if (columnType == 2001) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeGetNotSupported.txt"));
            }
            if (columnType == 6) {
                columnValue = this.results.getDouble(columnIndex);
            } else if (columnType == 4) {
                columnValue = this.results.getInt(columnIndex);
            } else if (columnType == 2000) {
                columnValue = this.results.getObject(columnIndex);
            } else if (columnType == -4) {
                columnValue = this.results.getBytes(columnIndex);
            } else if (columnType == -1) {
                columnValue = this.results.getString(columnIndex);
            } else {
                if (columnType == 0) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeGetNotSupported.txt"));
                }
                if (columnType == 2) {
                    columnValue = this.results.getBigDecimal(columnIndex);
                } else {
                    if (columnType == 1111) {
                        throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeGetNotSupported.txt"));
                    }
                    if (columnType == 7) {
                        columnValue = Float.valueOf(this.results.getFloat(columnIndex));
                    } else if (columnType == 2006) {
                        columnValue = this.results.getRef(columnIndex);
                    } else if (columnType == 5) {
                        columnValue = this.results.getShort(columnIndex);
                    } else {
                        if (columnType == 2002) {
                            throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeGetNotSupported.txt"));
                        }
                        if (columnType == 92) {
                            columnValue = this.results.getTime(columnIndex);
                        } else if (columnType == 93) {
                            columnValue = this.results.getTimestamp(columnIndex);
                        } else if (columnType == -6) {
                            columnValue = this.results.getByte(columnIndex);
                        } else if (columnType == -3) {
                            columnValue = this.results.getBytes(columnIndex);
                        }
                    }
                }
            }
        }
        return columnValue;
    }

    protected void updateColumn(int columnIndex, int columnType, Object value) throws SQLException {
        if (columnType == 12) {
            this.results.updateString(columnIndex, (String)value);
        } else if (columnType == 8) {
            this.results.updateDouble(columnIndex, (double)((Double)value));
        } else {
            if (columnType == 2003) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
            }
            if (columnType == -5) {
                this.results.updateLong(columnIndex, (long)((Long)value));
            } else if (columnType == -2) {
                this.results.updateBytes(columnIndex, (byte[])value);
            } else if (columnType == -7) {
                this.results.updateBoolean(columnIndex, (boolean)((Boolean)value));
            } else {
                if (columnType == 2004) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                }
                if (columnType == 1) {
                    this.results.updateString(columnIndex, (String)value);
                } else {
                    if (columnType == 2005) {
                        throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                    }
                    if (columnType == 91) {
                        this.results.updateDate(columnIndex, (Date)value);
                    } else if (columnType == 3) {
                        this.results.updateBigDecimal(columnIndex, (BigDecimal)value);
                    } else {
                        if (columnType == 2001) {
                            throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                        }
                        if (columnType == 6) {
                            this.results.updateDouble(columnIndex, (double)((Double)value));
                        } else if (columnType == 4) {
                            this.results.updateInt(columnIndex, (int)((Integer)value));
                        } else if (columnType == 2000) {
                            this.results.updateObject(columnIndex, value);
                        } else if (columnType == -4) {
                            this.results.updateBytes(columnIndex, (byte[])value);
                        } else if (columnType == -1) {
                            this.results.updateString(columnIndex, (String)value);
                        } else {
                            if (columnType == 0) {
                                throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                            }
                            if (columnType == 2) {
                                this.results.updateBigDecimal(columnIndex, (BigDecimal)value);
                            } else {
                                if (columnType == 1111) {
                                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                                }
                                if (columnType == 7) {
                                    this.results.updateFloat(columnIndex, ((Float)value).floatValue());
                                } else {
                                    if (columnType == 2006) {
                                        throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                                    }
                                    if (columnType == 5) {
                                        this.results.updateShort(columnIndex, (short)((Short)value));
                                    } else {
                                        if (columnType == 2002) {
                                            throw new IllegalStateException(RB.getStringResource(RB_KEY, "JDBCTypeUpdateNotSupported.txt"));
                                        }
                                        if (columnType == 92) {
                                            this.results.updateTime(columnIndex, (Time)value);
                                        } else if (columnType == 93) {
                                            this.results.updateTimestamp(columnIndex, (Timestamp)value);
                                        } else if (columnType == -6) {
                                            this.results.updateByte(columnIndex, (byte)((Byte)value));
                                        } else if (columnType == -3) {
                                            this.results.updateBytes(columnIndex, (byte[])value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

