/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class JDBCColumnValuesAdapter
extends JDBCAdapter {
    protected TransformInterface columnValuesTransform;
    protected boolean retrieveAllColumnValues;

    public JDBCColumnValuesAdapter(ResultSet result) {
        super(result);
    }

    public JDBCColumnValuesAdapter(Connection conn, String queryStatement) {
        super(conn, queryStatement);
    }

    public void setRetrieveAllColumnValues(boolean value) {
        if (this.retrieveAllColumnValues == value) {
            return;
        }
        this.retrieveAllColumnValues = value;
        this.initialized = false;
        this.spcs.firePropertyChange("retrieveAllColumnValues", this.retrieveAllColumnValues ? Boolean.FALSE : Boolean.TRUE, this.retrieveAllColumnValues ? Boolean.TRUE : Boolean.FALSE);
        this.fireModelEvent();
    }

    public boolean isRetrieveAllColumnValues() {
        return this.retrieveAllColumnValues;
    }

    public void setColumnValuesTransform(TransformInterface transform) {
        TransformInterface old = this.getColumnValuesTransform();
        if (old != transform) {
            this.columnValuesTransform = transform;
            this.initialized = false;
            this.spcs.firePropertyChange("columnValuesTransform", old, this.columnValuesTransform);
            this.fireModelEvent();
        }
    }

    public TransformInterface getColumnValuesTransform() {
        return this.columnValuesTransform;
    }

    @Override
    protected Object retrieveValueAt(int col, ResultSet resultSet) throws SQLException {
        if (this.isRetrieveAllColumnValues()) {
            Map values = this.getColumnValuesMap(resultSet);
            if (this.columnValuesTransform != null) {
                try {
                    return this.columnValuesTransform.transform((Object)values);
                }
                catch (TransformException te) {
                    throw new IllegalStateException(te.getMessage());
                }
            }
            return values;
        }
        return super.retrieveValueAt(col, resultSet);
    }

    protected Map getColumnValuesMap(ResultSet resultSet) throws SQLException {
        HashMap<String, Object> map = null;
        if (resultSet != null) {
            ResultSetMetaData meta = resultSet.getMetaData();
            int columnCount = meta.getColumnCount();
            map = new HashMap<String, Object>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String key = meta.getColumnName(i + 1).toUpperCase();
                Object value = super.retrieveValueAt(i + 1, resultSet);
                if (value instanceof String && this.isTrimUsed()) {
                    value = ((String)value).trim();
                }
                map.put(key, value);
            }
        }
        return map;
    }

    protected Object retrieveColumnValueAt(int col, ResultSet result) throws SQLException {
        return super.retrieveValueAt(col, result);
    }
}

