/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.MissingValues;
import com.sas.storage.jdbc.RB;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.TableException;
import com.sas.util.Classes;
import com.sas.util.NumberUtil;
import com.sas.util.UncheckedException;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.StringToBooleanTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EventObject;
import javax.sql.RowSet;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class JDBCAdapter
implements DisplayTransformInterface,
StaticColumnInfoInterface {
    public static final String RB_KEY = "JDBCAdapter.";
    public static final String NAME = "NAME";
    public static final String LABEL = "LABEL";
    public static final String CLASS_NAME = "CLASS_NAME";
    protected boolean initialized;
    protected boolean readOnly;
    protected int resultSetType;
    protected boolean autoCommit;
    protected boolean printWarnings;
    protected boolean forwardOnly;
    protected boolean resultSetRequeryUsed;
    protected boolean trimUsed;
    protected boolean resultSetUsed;
    protected Connection conn;
    protected Statement stmt;
    protected ResultSet result;
    protected ResultSetMetaData meta;
    protected String queryStatement;
    protected TransformInterface displayTransform;
    protected boolean designTime;
    protected SwingPropertyChangeSupport spcs;
    protected String columnInfoUsed;
    protected String rowCountQueryString;
    protected boolean queryRowCountDisabled;
    protected boolean isRowCountKnown;
    protected int rowNumber;
    protected int rowCount;
    protected boolean retrieveNumericTypesAsDouble;

    public JDBCAdapter() {
        this(null, null);
    }

    public JDBCAdapter(ResultSet result) {
        if (result == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "resultNull.ex.txt"));
        }
        this.initializeData();
        this.resultSetUsed = true;
        this.resultSetRequeryUsed = result instanceof RowSet;
        this.result = result;
    }

    public JDBCAdapter(Connection conn, String queryStatement) {
        this.initializeData();
        this.readOnly = true;
        this.resultSetType = 1005;
        this.resultSetRequeryUsed = true;
        this.conn = conn;
        this.queryStatement = queryStatement;
    }

    protected void initializeData() {
        this.designTime = com.sas.beans.Util.isDesignTime();
        this.spcs = new SwingPropertyChangeSupport(this);
        this.columnInfoUsed = LABEL;
        this.autoCommit = true;
        this.retrieveNumericTypesAsDouble = true;
        this.rowNumber = 0;
        this.rowCount = -1;
        this.isRowCountKnown = false;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        try {
            if (!this.resultSetUsed) {
                if (this.conn == null) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "connNull.ex.txt"));
                }
                if (this.queryStatement == null) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "queryNull.ex.txt"));
                }
                if (this.stmt == null) {
                    this.stmt = this.conn.createStatement(this.getResultSetType(), this.getResultSetConcurrency());
                }
                if (this.stmt != null) {
                    this.result = this.stmt.executeQuery(this.queryStatement);
                }
                if (this.stmt == null || this.result == null) {
                    this.initialized = false;
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "statementNotExecute.ex.txt"));
                }
                this.printSQLWarning(this.conn.getWarnings());
                this.printSQLWarning(this.stmt.getWarnings());
                this.printSQLWarning(this.result.getWarnings());
            } else if (this.result instanceof RowSet) {
                ((RowSet)this.result).execute();
            }
            this.meta = this.result.getMetaData();
            this.forwardOnly = this.result.getType() == 1003;
            this.readOnly = this.result.getConcurrency() == 1007;
            this.resultSetType = this.result.getType();
            this.rowNumber = 0;
            this.rowCount = -1;
            this.isRowCountKnown = false;
            this.initialized = true;
        }
        catch (SQLException se) {
            this.initialized = false;
            IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "initialization.ex.txt"));
            ise.initCause(se);
            throw ise;
        }
    }

    protected int getResultSetConcurrency() {
        return this.isReadOnly() ? 1007 : 1008;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly == readOnly || this.resultSetUsed && !(this.result instanceof RowSet)) {
            return;
        }
        this.readOnly = readOnly;
        if (this.resultSetUsed && this.result instanceof RowSet) {
            int concur = readOnly ? 1007 : 1008;
            try {
                ((RowSet)this.result).setConcurrency(concur);
            }
            catch (SQLException se) {
                IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "setConcurrency.ex.txt"));
                ise.initCause(se);
                throw ise;
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException se) {
                IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "closeStatement.ex.txt"));
                ise.initCause(se);
                throw ise;
            }
        }
        this.initialized = false;
        if (!this.designTime && (this.resultSetUsed || this.queryStatement != null && this.getModel() != null)) {
            this.init();
        }
        this.spcs.firePropertyChange("readOnly", readOnly ? Boolean.FALSE : Boolean.TRUE, readOnly ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setResultSetType(int type) {
        if (type == 1003 || type == 1004 || type == 1005) {
            int oldType = this.getResultSetType();
            if (oldType != type) {
                this.resultSetType = type;
                if (this.resultSetUsed && this.result instanceof RowSet) {
                    try {
                        ((RowSet)this.result).setType(type);
                    }
                    catch (SQLException se) {
                        throw new IllegalStateException(se.getMessage());
                    }
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException se) {
                        throw new IllegalStateException(se.getMessage());
                    }
                }
                this.initialized = false;
                if (!this.designTime && (this.resultSetUsed || this.queryStatement != null && this.getModel() != null)) {
                    this.init();
                }
                this.spcs.firePropertyChange("resultSetType", (Object)oldType, (Object)this.resultSetType);
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidResultSetType.ex.txt"));
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.autoCommit = autoCommit;
        this.spcs.firePropertyChange("autoCommit", autoCommit ? Boolean.FALSE : Boolean.TRUE, autoCommit ? Boolean.TRUE : Boolean.FALSE);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection conn) {
        Connection oldModel = this.conn;
        if (oldModel != conn) {
            try {
                this.conn = conn;
                this.initialized = false;
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.spcs.firePropertyChange("model", oldModel, conn);
                this.fireModelEvent();
            }
            catch (SQLException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
    }

    public Connection getModel() {
        return this.getConnection();
    }

    public void setModel(Connection conn) {
        this.setConnection(conn);
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public void setQueryStatement(String queryStatement) {
        String oldQueryStatement = this.queryStatement;
        if (Util.equal((Object)oldQueryStatement, (Object)queryStatement) || this.resultSetUsed && !(this.result instanceof RowSet)) {
            return;
        }
        this.queryStatement = queryStatement;
        if (this.resultSetUsed && this.result instanceof RowSet) {
            try {
                ((RowSet)this.result).setCommand(queryStatement);
            }
            catch (SQLException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
        this.initialized = false;
        this.spcs.firePropertyChange("queryStatement", oldQueryStatement, queryStatement);
        this.fireModelEvent();
    }

    public boolean isResultSetRequeryUsed() {
        return this.resultSetRequeryUsed;
    }

    public void setResultSetRequeryUsed(boolean resultSetRequeryUsed) {
        if (this.resultSetRequeryUsed == resultSetRequeryUsed) {
            return;
        }
        if (resultSetRequeryUsed && this.resultSetUsed && !(this.result instanceof RowSet)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "requery.ex.txt"));
        }
        this.resultSetRequeryUsed = resultSetRequeryUsed;
        this.spcs.firePropertyChange("resultSetRequeryUsed", resultSetRequeryUsed ? Boolean.FALSE : Boolean.TRUE, resultSetRequeryUsed ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTrimUsed() {
        return this.trimUsed;
    }

    public void setTrimUsed(boolean trimUsed) {
        if (this.trimUsed == trimUsed) {
            return;
        }
        this.trimUsed = trimUsed;
        this.initialized = false;
        this.spcs.firePropertyChange("trimUsed", trimUsed ? Boolean.FALSE : Boolean.TRUE, trimUsed ? Boolean.TRUE : Boolean.FALSE);
        this.fireModelEvent();
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newTransform) {
        if (this.displayTransform != newTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = newTransform;
            this.initialized = false;
            this.spcs.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
            this.fireModelEvent();
        }
    }

    public void setRetrieveNumericTypesAsDouble(boolean retrieveAsDouble) {
        if (this.retrieveNumericTypesAsDouble != retrieveAsDouble) {
            this.retrieveNumericTypesAsDouble = retrieveAsDouble;
            this.spcs.firePropertyChange("retrieveNumericTypesAsDouble", this.retrieveNumericTypesAsDouble ? Boolean.FALSE : Boolean.TRUE, this.retrieveNumericTypesAsDouble ? Boolean.TRUE : Boolean.FALSE);
            this.fireModelEvent();
        }
    }

    public boolean isRetrieveNumericTypesAsDouble() {
        return this.retrieveNumericTypesAsDouble;
    }

    protected boolean doAbsolute(int index) throws SQLException {
        if (this.rowNumber == index) {
            return true;
        }
        if (!this.forwardOnly) {
            boolean rc = this.result.absolute(index);
            this.rowNumber = index;
            return rc;
        }
        if (index < this.rowNumber) {
            if (!this.resultSetRequeryUsed) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "forwardOnly.ex.txt"));
            }
            int oldRowCount = this.rowCount;
            boolean oldIsRowCountKnown = this.isRowCountKnown;
            this.initialized = false;
            this.init();
            this.rowCount = oldRowCount;
            this.isRowCountKnown = oldIsRowCountKnown;
        }
        while (this.rowNumber < index) {
            boolean b = this.result.next();
            if (!b && !this.resultSetRequeryUsed) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "endOfResultSet.ex.txt"));
            }
            ++this.rowNumber;
        }
        return true;
    }

    protected String retrieveColumnInfoUsed() {
        return this.columnInfoUsed;
    }

    protected void putColumnInfoUsed(String info) {
        if (info.equalsIgnoreCase(NAME) || info.equalsIgnoreCase(LABEL)) {
            String oldInfo = this.columnInfoUsed;
            if (!oldInfo.equalsIgnoreCase(info)) {
                this.columnInfoUsed = info;
                this.spcs.firePropertyChange("columnInfoUsed", oldInfo, info);
                this.fireModelEvent();
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidInfo.ex.txt"));
        }
    }

    protected String retrieveColumnLabel(int index) throws SQLException {
        this.init();
        String label = null;
        if (this.columnInfoUsed.equalsIgnoreCase(LABEL)) {
            label = this.meta.getColumnLabel(index);
            if (label == null || label.length() == 0) {
                label = this.meta.getColumnName(index);
            }
        } else {
            label = this.meta.getColumnName(index);
        }
        return label;
    }

    protected int retrieveColumnIndex(String name) throws SQLException {
        this.init();
        int index = this.result.findColumn(name);
        return index;
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.initialized = false;
            this.fireModelEvent();
        }
        catch (SQLException se) {
            throw new IllegalStateException(se.getMessage());
        }
    }

    public void refresh() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.initialized = false;
            this.init();
            this.fireModelEvent();
        }
        catch (SQLException se) {
            throw new IllegalStateException(se.getMessage());
        }
    }

    protected void finalize() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (SQLException se) {
            throw new IllegalStateException(se.getMessage());
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable e) {
                LoggerRepository2.getLogger(this.getClass().getName(), null).error(e.getMessage(), e);
            }
        }
    }

    protected Class retrieveColumnClass(int index) throws SQLException, ClassNotFoundException {
        this.init();
        try {
            String className = this.meta.getColumnClassName(index);
            return Classes.loadClass((String)className, null, (Object)this);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
    }

    protected int doCountColumns(int maxCount) throws SQLException {
        return this.retrieveColumnCount();
    }

    protected int retrieveColumnCount() throws SQLException {
        if (this.designTime) {
            return 0;
        }
        this.init();
        int cols = this.meta.getColumnCount();
        return cols;
    }

    protected int calculateRowCount() throws SQLException {
        if (this.designTime) {
            return 0;
        }
        this.init();
        if (!this.initialized) {
            return -1;
        }
        if (this.isRowCountKnown) {
            return this.rowCount;
        }
        if (!this.resultSetUsed && !this.queryRowCountDisabled) {
            this.rowCount = this.getRowCountByCountFunction();
            if (this.rowCount == -1) {
                if (this.forwardOnly && !this.resultSetRequeryUsed) {
                    return -1;
                }
                this.rowCount = this.getResultSetRowCount();
            }
        } else {
            this.rowCount = this.forwardOnly && (!(this.result instanceof RowSet) || this.result instanceof RowSet && !this.resultSetRequeryUsed) ? -1 : this.getResultSetRowCount();
        }
        this.isRowCountKnown = this.rowCount != -1;
        return this.rowCount;
    }

    public String getRowCountQueryString() {
        return this.rowCountQueryString;
    }

    public void setRowCountQueryString(String rowCountQueryString) {
        if (this.rowCountQueryString != null && this.rowCountQueryString.equals(rowCountQueryString)) {
            return;
        }
        String old = this.rowCountQueryString;
        this.rowCountQueryString = rowCountQueryString;
        this.spcs.firePropertyChange("rowCountQueryString", old, rowCountQueryString);
    }

    public boolean isQueryRowCountDisabled() {
        return this.queryRowCountDisabled;
    }

    public void setQueryRowCountDisabled(boolean queryRowCountDisabled) {
        if (this.queryRowCountDisabled == queryRowCountDisabled) {
            return;
        }
        this.queryRowCountDisabled = queryRowCountDisabled;
        this.spcs.firePropertyChange("queryRowCountDisabled", queryRowCountDisabled ? Boolean.FALSE : Boolean.TRUE, queryRowCountDisabled ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRowCountByCountFunction() {
        this.init();
        if (!this.initialized) {
            return -1;
        }
        int count = -1;
        String rowCountQuery = this.getRowCountQueryString();
        if (rowCountQuery == null || rowCountQuery.length() == 0) {
            rowCountQuery = this.getCountSelectStatement(this.getQueryStatement());
        }
        if (rowCountQuery != null) {
            Statement statement = null;
            try {
                Object obj;
                statement = this.conn.createStatement();
                ResultSet rowCountResultSet = statement.executeQuery(rowCountQuery);
                if (rowCountResultSet.next() && rowCountResultSet.getMetaData().getColumnCount() == 1 && (obj = rowCountResultSet.getObject(1)) instanceof Number) {
                    count = ((Number)obj).intValue();
                }
            }
            catch (Exception e) {
                count = -1;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException se) {
                        IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "closeStatement.ex.txt"));
                        ise.initCause(se);
                        throw ise;
                    }
                }
            }
        }
        return count;
    }

    protected int getResultSetRowCount() throws SQLException {
        this.init();
        if (!this.initialized) {
            return -1;
        }
        int count = -1;
        if (this.forwardOnly) {
            count = 0;
            while (this.result.next()) {
                ++count;
            }
            this.initialized = false;
        } else {
            count = this.result.last() ? this.result.getRow() : 0;
        }
        return count;
    }

    private String getCountSelectStatement(String selectStatement) {
        if (selectStatement != null) {
            int fromIndex;
            selectStatement.trim();
            String sqlQuery = selectStatement.toLowerCase();
            if (sqlQuery.startsWith("select ") && (fromIndex = sqlQuery.indexOf(" from ")) != -1) {
                String selectPortion = sqlQuery.substring(0, fromIndex);
                String fromPortion = selectStatement.substring(fromIndex);
                int distinctIndex = selectPortion.indexOf(" distinct ");
                if (distinctIndex != -1) {
                    return "select count(" + selectPortion.substring(distinctIndex, selectPortion.length()) + ")" + fromPortion;
                }
                return "select count(*) " + fromPortion;
            }
        }
        return null;
    }

    protected void putValueAt(Object value, int rowIndex, int columnIndex) throws SQLException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "readOnly.ex.txt"));
        }
        this.init();
        try {
            this.doAbsolute(rowIndex);
            this.doUpdateCell(columnIndex, value);
            if (this.autoCommit) {
                this.result.updateRow();
                this.fireCellEvent(rowIndex, columnIndex);
            }
        }
        catch (SQLException se) {
            this.result.cancelRowUpdates();
            throw se;
        }
    }

    protected synchronized Object retrieveValueAt(int row, int col) throws SQLException {
        this.init();
        try {
            this.doAbsolute(row);
            Object value = this.retrieveValueAt(col, this.result);
            if (this.getDisplayTransform() != null) {
                return this.getDisplayTransform().transform(value);
            }
            return value;
        }
        catch (TransformException te) {
            throw new IllegalStateException(te.getMessage());
        }
    }

    protected synchronized Double retrieveRawSASNumericValue(int row, int col) throws SQLException {
        this.init();
        this.doAbsolute(row);
        return this.retrieveRawSASNumericValue(col, this.result);
    }

    protected Object retrieveValueAt(int col, ResultSet result) throws SQLException {
        int colType = this.meta.getColumnType(col);
        if (colType == 8 || colType == 6 || this.retrieveNumericTypesAsDouble && (colType == 4 || colType == -6 || colType == 5 || colType == -5 || colType == 7)) {
            double value = result.getDouble(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == 1 || colType == 12) {
            String value = result.getString(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            if (value != null && this.isTrimUsed()) {
                return value.trim();
            }
            return value;
        }
        if (colType == 4) {
            int value = result.getInt(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == 7) {
            float value = result.getFloat(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return Float.valueOf(value);
        }
        if (colType == -5) {
            long value = result.getLong(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == 5) {
            short value = result.getShort(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == -7) {
            boolean value = result.getBoolean(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == 91) {
            Date date = result.getDate(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return date;
        }
        if (colType == 92) {
            Time time = result.getTime(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return time;
        }
        if (colType == 93) {
            Timestamp timeStamp = result.getTimestamp(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return timeStamp;
        }
        if (colType == -6) {
            byte value = result.getByte(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return value;
        }
        if (colType == 2 || colType == 3) {
            BigDecimal bigDecimal = result.getBigDecimal(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return bigDecimal;
        }
        if (colType == -1) {
            Reader charStream = result.getCharacterStream(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return charStream;
        }
        if (colType == -2 || colType == -3) {
            byte[] bytes = result.getBytes(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return bytes;
        }
        if (colType == -4) {
            InputStream stream = result.getBinaryStream(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return stream;
        }
        if (colType == 2004) {
            Blob blob = result.getBlob(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return blob;
        }
        if (colType == 2005) {
            Clob clob = result.getClob(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return clob;
        }
        if (colType == 2003) {
            Array arr = result.getArray(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return arr;
        }
        if (colType == 2006) {
            Ref ref = result.getRef(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return ref;
        }
        if (colType == 2002 || colType == 2000) {
            Object obj = result.getObject(col);
            if (result.wasNull()) {
                return MissingValues.Dot;
            }
            return obj;
        }
        return RB.getStringResource(RB_KEY, "unknown.ex.txt");
    }

    protected Double retrieveRawSASNumericValue(int col, ResultSet result) throws SQLException {
        int colType = this.meta.getColumnType(col);
        switch (colType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                double value = result.getDouble(col);
                if (result.wasNull()) {
                    return Double.NaN;
                }
                return value;
            }
        }
        return Double.NaN;
    }

    protected void doUpdateCell(int col, Object value) throws SQLException {
        int colType = this.meta.getColumnType(col);
        if (value instanceof MissingValues) {
            this.result.updateObject(col, null);
        } else if (colType == 8 || colType == 6) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        double d = NumberUtil.doubleValueOf((String)val);
                        this.result.updateDouble(col, d);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                double d = ((Number)value).doubleValue();
                this.result.updateDouble(col, d);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 1 || colType == 12) {
            this.result.updateString(col, (String)value);
        } else if (colType == 4) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        int i = Integer.parseInt((String)value);
                        this.result.updateInt(col, i);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                int i = ((Number)value).intValue();
                this.result.updateInt(col, i);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 7) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        float f = NumberUtil.floatValueOf((String)((String)value));
                        this.result.updateFloat(col, f);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                float f = ((Number)value).floatValue();
                this.result.updateFloat(col, f);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == -5) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        long l = Long.parseLong((String)value);
                        this.result.updateLong(col, l);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                long l = ((Number)value).longValue();
                this.result.updateLong(col, l);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 5) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        short s = Short.parseShort((String)value);
                        this.result.updateShort(col, s);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                short s = ((Number)value).shortValue();
                this.result.updateShort(col, s);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == -7) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        Boolean b = (Boolean)StringToBooleanTransform.defaultInstance.transform(value);
                        this.result.updateBoolean(col, (boolean)b);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Boolean) {
                boolean b = (Boolean)value;
                this.result.updateBoolean(col, b);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 91) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        Date d = Date.valueOf((String)value);
                        this.result.updateDate(col, d);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Date) {
                this.result.updateDate(col, (Date)value);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 92) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        Time t = Time.valueOf((String)value);
                        this.result.updateTime(col, t);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Time) {
                this.result.updateTime(col, (Time)value);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 93) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        Timestamp ts = Timestamp.valueOf((String)value);
                        this.result.updateTimestamp(col, ts);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Timestamp) {
                this.result.updateTimestamp(col, (Timestamp)value);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == -6) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        byte b = Byte.parseByte((String)value);
                        this.result.updateByte(col, b);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                this.result.updateByte(col, ((Number)value).byteValue());
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 2 || colType == 3) {
            if (value instanceof String) {
                String val = (String)value;
                if (val.length() > 0) {
                    if (val.equals(".")) {
                        this.result.updateObject(col, null);
                    } else {
                        BigDecimal d = new BigDecimal((String)value);
                        this.result.updateBigDecimal(col, d);
                    }
                } else {
                    this.result.updateObject(col, null);
                }
            } else if (value instanceof Number) {
                BigDecimal d = new BigDecimal(((Number)value).doubleValue());
                this.result.updateBigDecimal(col, d);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == -2 || colType == -3) {
            if (value instanceof byte[]) {
                this.result.updateBytes(col, (byte[])value);
            } else {
                this.result.updateObject(col, value);
            }
        } else if (colType == 2002 || colType == 2000) {
            this.result.updateObject(col, value);
        }
    }

    public Object getColumnInfo(int index, String columnInfoName) throws TableException {
        this.init();
        try {
            if (columnInfoName.equals(NAME)) {
                return this.meta.getColumnName(index);
            }
            if (columnInfoName.equals(LABEL)) {
                return this.meta.getColumnLabel(index);
            }
            if (columnInfoName.equals(CLASS_NAME)) {
                return this.meta.getColumnTypeName(index);
            }
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnInfo.ex.txt"));
        }
        catch (SQLException sqle) {
            throw new UncheckedException((Throwable)sqle, sqle.getMessage());
        }
    }

    public String[] getColumnInfoNames() throws TableException {
        return new String[]{NAME, LABEL, CLASS_NAME};
    }

    protected void printSQLWarning(SQLWarning w) {
        if (this.printWarnings && w != null) {
            CommonLoggerInterface log = LoggerRepository2.getLogger(this.getClass().getName(), null);
            while (w != null) {
                log.warn(RB.getStringResource(RB_KEY, "sqlWarning.txt"));
                log.warn(w.getMessage());
                log.warn(w.getSQLState());
                log.warn(Integer.toString(w.getErrorCode()));
                w = w.getNextWarning();
            }
        }
    }

    public boolean getPrintWarnings() {
        return this.printWarnings;
    }

    public void setPrintWarnings(boolean printWarnings) {
        this.printWarnings = printWarnings;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(propertyName, listener);
    }

    protected abstract void fireCellEvent(int var1, int var2);

    protected abstract void fireModelEvent(EventObject var1);

    protected abstract void fireModelEvent();
}

