/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.RB;
import com.sas.text.Message;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SectionedPropertyList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String RB_KEY = "SectionedPropertyList.";
    protected Map<String, PropertyList> sections = new LinkedHashMap<String, PropertyList>();
    protected PropertyList.Comment _comment = null;
    private transient LoggerFactoryInterface loggerFactory = null;
    private transient CommonLoggerInterface logger = null;
    public static final int MAX_SECTION_NAME_LENGTH = 1024;

    public SectionedPropertyList() {
    }

    public SectionedPropertyList(String comment) {
        this._comment = new PropertyList.Comment(comment);
    }

    public void save(Writer writer) throws IOException {
        this.save(writer, null);
    }

    public void save(OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        this.save(writer, null);
    }

    public void save(OutputStream os, Charset cs) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, cs));
        this.save(writer, cs);
    }

    private void save(Writer writer, Charset cs) throws IOException {
        String newline = System.getProperty("line.separator");
        CharsetEncoder encoder = null;
        if (cs != null && cs.canEncode()) {
            encoder = cs.newEncoder();
        }
        if (this._comment != null) {
            writer.append(PropertyList.escapeString(null, encoder, this._comment, 1));
            writer.append(System.getProperty("line.separator"));
        }
        boolean firstSection = true;
        for (String name : this.sections.keySet()) {
            if (!firstSection) {
                writer.append(newline);
            }
            if (name.length() > 0 || !firstSection) {
                writer.append(PropertyList.escapeString(null, encoder, name, 5));
                writer.append(newline);
            }
            this.sections.get(name).save(writer, cs);
            firstSection = false;
        }
    }

    public void addSection(String name, PropertyList list) {
        if (name.length() > 1024) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "SectionNameTooLong.fmt"), (Object)PropertyList.escapeString(null, null, name.substring(0, 49) + "...", 5)));
        }
        if (this.sections.containsKey(name)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "SectionAlreadyDefined.fmt"), (Object)PropertyList.escapeString(null, null, name, 5)));
        }
        this.sections.put(name, list);
    }

    public boolean containsSection(String name) {
        return this.sections.containsKey(name);
    }

    public PropertyList getSection(String name) {
        return this.sections.get(name);
    }

    public Collection<String> getSections() {
        return this.sections.keySet();
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }
}

