/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util;

import com.sas.util.UserInfoInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class MapText
extends AbstractPersistence {
    private String key;
    private String text;

    public MapText() {
    }

    public MapText(String key, String text) {
        this.key = key;
        this.text = text;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getDefinitionElementName() {
        return "MapText";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setKey(provider.consumeAttr("key"));
        this.getLogger2().debug("consumeAttributes(),key was set to:", this.getKey());
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getText()) {
            XmlUtil.setAttr(element, "key", this.getKey());
            Document doc = element.getOwnerDocument();
            Text theText = doc.createTextNode(this.getText());
            element.appendChild(theText);
        }
    }

    @Override
    public void consumeElementText(String text) {
        super.consumeElementText(text);
        this.setText(text);
        this.getLogger2().debug("consumeElementText(),text is:", text);
    }

    public static List<MapText> convertUserInfoToMapTextList(UserInfoInterface userInfo) {
        List keys;
        List<MapText> mapTextList = null;
        if (userInfo != null && (keys = userInfo.getKeys()) != null && keys.size() > 0) {
            mapTextList = new ArrayList<MapText>(keys.size());
            for (String key : keys) {
                String text = userInfo.get(key);
                MapText t = new MapText();
                t.setKey(key);
                t.setText(text);
                mapTextList.add(t);
            }
        }
        if (mapTextList == null) {
            mapTextList = Collections.emptyList();
        }
        return mapTextList;
    }

    public static Map<String, String> convertMapTextListToMap(List<MapText> mapTextList) {
        if (mapTextList == null || mapTextList.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(mapTextList.size());
        for (MapText text : mapTextList) {
            map.put(text.getKey(), text.getText());
        }
        return map;
    }

    public static List<PersistenceInterface> convertMapToPersistenceList(Map<String, String> map) {
        LinkedList<PersistenceInterface> list = new LinkedList<PersistenceInterface>();
        if (!map.isEmpty()) {
            Set<Map.Entry<String, String>> entries = map.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                MapText mt = new MapText(entry.getKey(), entry.getValue());
                list.add(mt);
            }
        }
        return list;
    }
}

