/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util;

import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class AttributeValue
extends AbstractPersistence {
    private String name;
    private Object value;

    public AttributeValue() {
    }

    public AttributeValue(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getDefinitionElementName() {
        return "Attribute";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setName(provider.consumeAttr("name"));
        this.getLogger2().debug("consumeAttributes(),name was set to:", this.getName());
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList valueList = roHolder.consumeObjects("Value");
        if (valueList != null && valueList.size() > 0) {
            BasePersistedValue persistedValue = (BasePersistedValue)valueList.get(0);
            this.setValue(persistedValue.getValue());
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getValue()) {
            XmlUtil.setAttr(element, "name", this.getName());
            ArrayList<PersistenceInterface> valueList = new ArrayList<PersistenceInterface>(1);
            valueList.add(ValueUtil.getPersistableValue(this.getValue()));
            AttributeValue.writeRelatedObjects(valueList, element, writingContext, "Value");
        }
    }
}

