/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.MaskedType;
import com.sas.prompts.datatypes.values.SimplePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class MaskedValue
extends SimplePersistedValue {
    private String maskedEncoding;
    private static final String MASKED_TEXT_NO_ENCODING_XML = "None";

    public MaskedValue() {
        this.setMaskedEncoding("sas001");
    }

    public MaskedValue(String dataType) {
        this.setMaskedEncoding(dataType);
    }

    @Override
    public String getDefinitionElementName() {
        return "MaskedString";
    }

    @Override
    protected DataTypeInterface getDataType() {
        MaskedType dataType = MaskedType.DEFAULT_INSTANCE;
        if (this.maskedEncoding.equals("sas002")) {
            dataType = MaskedType.DEFAULT_INSTANCE_SAS002;
        }
        return dataType;
    }

    public String getMaskedEncoding() {
        return this.maskedEncoding;
    }

    private void setMaskedEncoding(String encoding) {
        if (encoding == null || encoding.equals("base64") || encoding.equals("sas001") || encoding.equals("sas002")) {
            this.maskedEncoding = encoding;
            return;
        }
        throw new IllegalArgumentException("Invalid masked encoding.  See encodings in com.sas.util.SasPasswordString.");
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String encoding = provider.consumeAttr("maskedTextEncoding");
        if (encoding == null) {
            this.setMaskedEncoding("sas001");
        } else if (encoding.equals(MASKED_TEXT_NO_ENCODING_XML)) {
            this.setMaskedEncoding(null);
        } else {
            this.setMaskedEncoding(encoding);
        }
        super.consumeAttributes(provider);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        String encoding = this.getMaskedEncoding();
        if (encoding == null) {
            XmlUtil.setAttr(element, "maskedTextEncoding", MASKED_TEXT_NO_ENCODING_XML);
        } else if (!encoding.equals("sas001")) {
            XmlUtil.setAttr(element, "maskedTextEncoding", encoding);
        }
    }
}

