/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.password.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class PWResourceBundle {
    protected static Hashtable m_bundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;
    protected static PWResourceBundle m_bundleMetadataTypeIcons;

    public PWResourceBundle(String strResourceFileName) {
        this.m_classLoader = ClassLoader.getSystemClassLoader();
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public PWResourceBundle(Class cls) {
        this(cls, "PropertyBundle");
    }

    public PWResourceBundle(Class cls, String strResourceFileName) {
        this.m_classLoader = cls.getClassLoader();
        String strClassName = cls.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + "." + strResourceFileName);
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.getDefault();
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale, this.m_classLoader);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale, this.m_classLoader);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public String getString(String key) {
        String retValue;
        block6: {
            retValue = "";
            if (this.m_bundle == null) {
                try {
                    throw new Throwable();
                }
                catch (Throwable throwable) {
                    break block6;
                }
            }
            if (!this.m_bResourceFileMissing) {
                try {
                    retValue = this.m_bundle.getString(key);
                }
                catch (Throwable t) {
                    retValue = "Missing resource " + key;
                    System.err.println(retValue + ". Have you copied your resources?");
                    System.err.println("Missing resource is called from the following:");
                }
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable throwable) {
            return notFoundReturnValue;
        }
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public Enumeration getKeys() {
        return this.m_bundle.getKeys();
    }
}

