/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.password.util;

import com.sas.security.password.util.InvalidFormatException;
import com.sas.security.password.util.KeyValuePair;
import com.sas.security.password.util.PWResourceBundle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class KeyValuePairParser {
    protected static final PWResourceBundle bundle = new PWResourceBundle(KeyValuePairParser.class);

    public static KeyValuePair[] parseKeyValuePairs(String inputLine) throws InvalidFormatException {
        KeyValuePair[] pairs;
        if (inputLine == null || inputLine.length() == 0) {
            throw new InvalidFormatException();
        }
        StringReader input = new StringReader(inputLine);
        ArrayList<KeyValuePair> keyValPairList = new ArrayList<KeyValuePair>();
        int ch = 0;
        StringBuffer keyword = null;
        StringBuffer value = null;
        while (ch != -1 && ch != 10) {
            keyword = new StringBuffer();
            value = new StringBuffer();
            do {
                try {
                    ch = ((Reader)input).read();
                }
                catch (IOException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            } while (ch == 32 || ch == 9);
            if (ch == 61) {
                throw new InvalidFormatException(bundle.getString("KeyValuePairParser.ParsingError.KeywordExpected.txt"));
            }
            if (ch == 10) {
                ch = 0;
                continue;
            }
            if (ch == -1) {
                pairs = new KeyValuePair[keyValPairList.size()];
                keyValPairList.toArray(pairs);
                return pairs;
            }
            while (ch != 32 && ch != 9 && ch != -1 && ch != 61 && ch != 10) {
                keyword = keyword.append((char)ch);
                try {
                    ch = ((Reader)input).read();
                }
                catch (IOException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            }
            while (ch == 32 || ch == 9) {
                try {
                    ch = ((Reader)input).read();
                }
                catch (IOException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            }
            if (ch != 61) {
                throw new InvalidFormatException(bundle.messageString("KeyValuePairParser.ParsingError.EqualSignExpected.txt", keyword));
            }
            if (ch == 10 || ch == -1) {
                throw new InvalidFormatException(bundle.messageString("KeyValuePairParser.ParsingError.UnExpectedEndOfInput.txt", keyword));
            }
            do {
                try {
                    ch = ((Reader)input).read();
                }
                catch (IOException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            } while (ch == 32 || ch == 9);
            if (ch == 10 || ch == -1) {
                throw new InvalidFormatException(bundle.messageString("KeyValuePairParser.ParsingError.UnExpectedEndOfInput.txt", keyword));
            }
            if (ch == 34) {
                boolean endofquote = false;
                try {
                    do {
                        if ((ch = ((Reader)input).read()) == 34) {
                            ch = ((Reader)input).read();
                            if (ch == 34) {
                                value = value.append((char)ch);
                                continue;
                            }
                            endofquote = true;
                            continue;
                        }
                        value = value.append((char)ch);
                    } while (!endofquote);
                }
                catch (IOException e) {
                    throw new InvalidFormatException(e.getMessage());
                }
            } else {
                while (ch != 32 && ch != 9 && ch != -1 && ch != 10) {
                    value = value.append((char)ch);
                    try {
                        ch = ((Reader)input).read();
                    }
                    catch (IOException e) {
                        throw new InvalidFormatException(e.getMessage());
                    }
                }
            }
            KeyValuePair newkp = new KeyValuePair(keyword.toString(), value.toString());
            keyValPairList.add(newkp);
        }
        pairs = new KeyValuePair[keyValPairList.size()];
        keyValPairList.toArray(pairs);
        return pairs;
    }
}

