/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.deployment.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sas.batch.deployment.backup.AbstractDeploymentBackupUtility;
import com.sas.batch.deployment.backup.JSONDecorator;
import com.sas.batch.deployment.backup.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.security.ConnectionProfile;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import com.sas.svcs.admin.backup.rest.model.BackupErrorDetailsData;
import com.sas.svcs.admin.backup.rest.model.BackupResultData;
import com.sas.svcs.admin.backup.rest.model.RecoveryDetailData;
import com.sas.svcs.admin.backup.rest.model.RecoveryOptionsMapper;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.common.impl.BackupErrorXmlLogger;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.deployment.dao.WorkflowStateHolder;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;

@SASScope
public class DeploymentRecoverUtility
extends AbstractDeploymentBackupUtility {
    public static final String OPTION_INPUTDATA = "inputdata";
    public static final String OPTION_BACKUPID = "backupid";
    private String backupName;
    private String comment;
    private String inputdataPath;

    public DeploymentRecoverUtility() {
        this.utilityName = "sas-recover-offline";
    }

    public String getBackupName() {
        return this.backupName;
    }

    public void setBackupName(String backupName) {
        this.backupName = backupName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getInputdataPath() {
        return this.inputdataPath;
    }

    public void setInputdataPath(String inputdataPath) {
        this.inputdataPath = inputdataPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        try {
            RecoveryDetails recovery;
            this.initialize();
            BackupService backupService = (BackupService)this.applicationContext.getBean("BackupService");
            WorkflowStateHolder.setProperty((String)WorkflowStateHolder.IS_OFFLINE_RECOVERY_INITIAL_PHASE_ENABLED, (Object)Boolean.TRUE);
            BackupDetails recoveryBackup = null;
            RecoveryOptions recoveryOptions = null;
            if (this.backupName != null) {
                BackupServiceResult backupServiceResult;
                if (this.inputdataPath != null) {
                    RecoveryOptionsMapper optionMapper = (RecoveryOptionsMapper)mapper.readValue(new File(this.inputdataPath), RecoveryOptionsMapper.class);
                    recoveryOptions = optionMapper.getRecoveryOptions();
                }
                if (recoveryOptions == null) {
                    recoveryOptions = new RecoveryOptions();
                }
                if (this.comment != null) {
                    recoveryOptions.setComment(this.comment);
                }
                BackupDetails backupDetails = recoveryBackup = (backupServiceResult = backupService.getBackupByName(this.backupName)) == null ? null : (BackupDetails)backupServiceResult.getActualResult();
                if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
                    BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
                    StringWriter strWriter = new StringWriter();
                    mapper.writeValue((Writer)strWriter, (Object)errorMapper);
                    String jsonString2 = ((Object)strWriter).toString();
                    new JSONDecorator().decorate(jsonString2);
                    int n = this.returnCode = 8;
                    return n;
                }
            } else {
                this.logger.error(RB.getStringResource("DeploymentRecoverUtility.NoBackups.log"));
                this.returnCode = 8;
            }
            if (recoveryBackup == null) {
                BackupErrorData error = new BackupErrorData();
                error.setErrorMessage(RB.getStringResource("DeploymentRecoverUtility.no.backup.found.txt"));
                error.setRemedyMessage(RB.getStringResource("DeploymentRecoverUtility.submit.valid.backup.name.txt"));
                error.setStatusCode(404);
                StringWriter strWriter = new StringWriter();
                mapper.writeValue((Writer)strWriter, (Object)error);
                String jsonString = ((Object)strWriter).toString();
                new JSONDecorator().decorate(jsonString);
                int jsonString2 = this.returnCode;
                return jsonString2;
            }
            BackupServiceResult recoveryResult = backupService.recover(recoveryBackup, recoveryOptions);
            RecoveryDetails recoveryDetails = recovery = recoveryResult == null ? null : (RecoveryDetails)recoveryResult.getActualResult();
            if (recovery == null || recovery.getStatus() != OperationDetails.OperationStatus.SUCCESS) {
                this.returnCode = 8;
            }
            if (recovery == null) return this.returnCode;
            RecoveryDetailData recoveryData = new RecoveryDetailData((OperationDetails)recovery);
            BackupResultData recoveryResultData = new BackupResultData(recoveryResult, (Object)recoveryData);
            StringWriter strWriter = new StringWriter();
            mapper.writeValue((Writer)strWriter, (Object)recoveryResultData);
            String jsonString = ((Object)strWriter).toString();
            new JSONDecorator().decorate(jsonString);
            return this.returnCode;
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = ((BackupErrorXmlLogger)this.applicationContext.getBean("BackupErrorXmlLogger")).getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                StringWriter strWriter = new StringWriter();
                mapper.writeValue((Writer)strWriter, (Object)errorMapper);
                String jsonString = ((Object)strWriter).toString();
                new JSONDecorator().decorate(jsonString);
                int n = this.returnCode = 8;
                return n;
            }
            catch (Throwable t) {
                BackupErrorData errorData = new BackupErrorData();
                errorData.setStatusCode(500);
                errorData.setErrorMessage(Message.format((String)RB.getStringResource("DeploymentRecoverUtility.internal.server.error.fmt"), (Object)e.getMessage()));
                errorData.setRemedyMessage(RB.getStringResource("DeploymentRecoverUtility.find.detail.cause.in.logs.txt"));
                StringWriter strWriter = new StringWriter();
                mapper.writeValue((Writer)strWriter, (Object)errorData);
                String jsonString = ((Object)strWriter).toString();
                new JSONDecorator().decorate(jsonString);
                return this.returnCode;
            }
        }
        catch (Exception e) {
            BackupErrorData errorData = new BackupErrorData();
            errorData.setStatusCode(500);
            errorData.setErrorMessage(Message.format((String)RB.getStringResource("DeploymentRecoverUtility.internal.server.error.fmt"), (Object)e.getMessage()));
            errorData.setRemedyMessage(RB.getStringResource("DeploymentRecoverUtility.find.detail.cause.in.logs.txt"));
            StringWriter strWriter = new StringWriter();
            mapper.writeValue((Writer)strWriter, (Object)errorData);
            String jsonString = ((Object)strWriter).toString();
            new JSONDecorator().decorate(jsonString);
            return this.returnCode;
        }
        finally {
            try {
                BackupServiceUtils.deleteTempDir();
                this.terminate();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void main(String[] args) {
        DeploymentRecoverUtility utility = new DeploymentRecoverUtility();
        try {
            DeploymentRecoverUtility.clearAppHomeBeforeRecovery();
            utility.extractCredentials(args);
        }
        catch (Exception e) {
            utility.returnCode = 8;
            utility.logException(e);
            utility.logCompletion();
            System.exit(8);
        }
        utility.executeBatch(args);
    }

    private static void clearAppHomeBeforeRecovery() {
        try {
            File appHomeDir;
            String baseTempPath = System.getProperty("java.io.tmpdir");
            File tempDir = new File(baseTempPath + File.separator + "SASDeploymentBackup_APPHOME");
            String appHomePath = tempDir.getAbsolutePath();
            if (appHomePath != null && (appHomeDir = new File(appHomePath)).exists()) {
                FileUtils.deleteQuietly((File)appHomeDir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void extractCredentials(String[] args) throws FileNotFoundException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            if ("user".equals(param.trim().substring(1))) {
                this.username = args[i + 1];
                continue;
            }
            if ("password".equals(param.trim().substring(1))) {
                try {
                    this.password = SasPasswordString.encode((String)args[i + 1]);
                }
                catch (SasPasswordEncodingException e) {
                    this.password = args[i + 1];
                }
                continue;
            }
            if (!"profile".equals(param.trim().substring(1))) continue;
            this.initProfile(args[i + 1]);
        }
    }

    private void initProfile(String profileFile) throws FileNotFoundException, IOException {
        Properties properties = null;
        File file = new File(DeploymentRecoverUtility.getFullPath(profileFile));
        this.logger.info("Loading profile from " + file.getCanonicalPath());
        if (file.exists()) {
            properties = new Properties();
            properties.load(new FileInputStream(file));
            if (properties.getProperty("userid") != null && !properties.getProperty("userid").isEmpty()) {
                this.username = properties.getProperty("userid").trim();
            }
            if (properties.getProperty("password") != null && !properties.getProperty("password").isEmpty()) {
                this.password = properties.getProperty("password").trim();
            }
        } else {
            this.logger.error(Message.format((String)RB.getStringResource("DeploymentRecoverUtility.profile.file.not.found.fmt"), (Object)profileFile));
            throw new IllegalStateException(RB.getStringResource("DeploymentRecoverUtility.profile.file.not.found.fmt") + profileFile);
        }
    }

    private static String getFullPath(String file) {
        String profileExtension = ".swa";
        if (!file.endsWith(".swa")) {
            file = file + ".swa";
        }
        String fullpath = file;
        String separator = System.getProperty("file.separator");
        if (file.lastIndexOf(separator) < 0) {
            fullpath = separator.equals("/") ? ConnectionProfile.getAppDataPath() + "/.SASAppData/MetadataServerProfiles/" + file : ConnectionProfile.getAppDataPath() + separator + "SAS" + separator + "MetadataServerProfiles" + separator + file;
        }
        return fullpath;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_BACKUPID, true, RB.getStringResource("DeploymentRecoverUtility.Backupid.Option.txt"));
        option.setArgName(RB.getStringResource("DeploymentRecoverUtility.Backupid.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_INPUTDATA, true, RB.getStringResource("DeploymentRecoverUtility.Inputdata.Option.txt"));
        option.setArgName(RB.getStringResource("DeploymentRecoverUtility.Inputdata.ArgName.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        String backupId = this.commandLine.getOptionValue(OPTION_BACKUPID);
        if (backupId == null) {
            throw new ParseException(RB.getStringResource("DeploymentRecoverUtility.NameRequired.log"));
        }
        this.setBackupName(backupId);
        this.setInputdataPath(this.commandLine.getOptionValue(OPTION_INPUTDATA));
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("DeploymentRecoverUtility.HelpUsage1.txt")});
    }
}

