/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.deployment.backup;

import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.services.ServiceException;
import com.sas.svcs.authentication.helper.SettableUserSessionFactory;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public abstract class AbstractDeploymentBackupUtility
extends LocalServicesBatchUtility2 {
    protected volatile String username;
    protected volatile String password;
    public static final String SPRING_CONFIG_RESOURCE_NAME = "autowire-context.xml";
    protected String springConfigResource = "autowire-context.xml";
    protected ApplicationContext applicationContext;

    protected void initializeBatchLogging() {
        super.initializeBatchLogging();
        if (this.debug) {
            Configurator.setLevel((String)"com.sas.svcs.backup", (Level)Level.DEBUG);
        }
    }

    protected void initialize() throws ServiceException {
        super.initialize();
        SettableUserSessionFactory userSessionFactory = new SettableUserSessionFactory();
        userSessionFactory.setSessionContext(this.session);
        GenericApplicationContext parent = new GenericApplicationContext();
        parent.getBeanFactory().registerSingleton("userSessionFactory", (Object)userSessionFactory);
        PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
        Properties properties = new Properties();
        properties.setProperty("omr_user", this.username);
        properties.setProperty("omr_password", this.password);
        configurer.setProperties(properties);
        parent.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
        parent.refresh();
        this.applicationContext = new ClassPathXmlApplicationContext(new String[]{this.springConfigResource}, ((Object)((Object)this)).getClass(), (ApplicationContext)parent);
    }
}

