/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.FunctionFormat;
import com.sas.expressions.visuals.OperationInterface;
import com.sas.expressions.visuals.RB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class Operation
implements OperationInterface {
    public static final String RB_KEY = "Operation.";
    String _operationLabel = RB.getStringResource("Operation.", "OperationLabel.txt");
    String _formatString = null;
    String _name = null;
    String _symbol = null;
    String _toolTip = null;
    String _displayName = null;
    Icon _imageIcon = null;
    List _argList = null;
    static String dummyArg = RB.getStringResource("Operation.", "OperationDefaultArgText.txt");
    static String[] dummyArgs = new String[]{dummyArg, dummyArg, dummyArg, dummyArg, dummyArg, dummyArg, dummyArg, dummyArg, dummyArg, dummyArg};

    public Operation(String name, String displayName, String symbol, String toolTip, String fmtString) {
        this(name, displayName, symbol, toolTip, fmtString, (Icon)null);
    }

    public Operation(String name, String displayName, String symbol, String toolTip, String fmtString, Icon imageIcon) {
        this(name, displayName, symbol, toolTip, fmtString, Arrays.asList(dummyArgs), imageIcon);
    }

    public Operation(String name, String displayName, String symbol, String toolTip, String fmtString, List argList) {
        this(name, displayName, symbol, toolTip, fmtString, argList, null);
    }

    public Operation(String name, String displayName, String symbol, String toolTip, String fmtString, List argList, Icon imageIcon) {
        this._name = name;
        this._symbol = symbol;
        this._toolTip = toolTip;
        this._displayName = displayName;
        this._formatString = fmtString;
        this._imageIcon = imageIcon;
        this._argList = argList;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    @Override
    public String getToolTip() {
        return this._toolTip;
    }

    @Override
    public Icon getImageIcon() {
        return this._imageIcon;
    }

    public List getArgList() {
        return this._argList;
    }

    public String toString() {
        String result = this._operationLabel;
        result = result + ": ";
        result = result + this.getSymbol();
        return result;
    }

    @Override
    public String formatSelectedText(String text) {
        String[] argDisplayNames = this.getArgDisplayNames();
        String retValue = FunctionFormat.formatSelectedText(this._formatString, argDisplayNames, text);
        return retValue;
    }

    @Override
    public String formatSelectedText(String text, int[] selStartEnd) {
        String[] argDisplayNames = this.getArgDisplayNames();
        String retValue = FunctionFormat.formatSelectedText(this._formatString, argDisplayNames, text, selStartEnd);
        return retValue;
    }

    private String[] getArgDisplayNames() {
        ArrayList<String> displayNames = new ArrayList<String>();
        Iterator iter = this.getArgList().iterator();
        while (iter.hasNext()) {
            displayNames.add(this.getArgDisplayName(iter.next()));
        }
        return displayNames.toArray(new String[displayNames.size()]);
    }

    protected String getArgDisplayName(Object obj) {
        return obj.toString();
    }
}

