/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.FunctionFormatInterface;
import com.sas.expressions.visuals.FunctionList;
import com.sas.expressions.visuals.FunctionListInterface;
import com.sas.expressions.visuals.FunctionNodeInterface;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;

public class FunctionNode
extends DefaultMutableTreeNode
implements FunctionNodeInterface,
Comparator {
    String _name = null;
    String _displayName = null;
    String _description = null;
    String _toolTip;
    FunctionListInterface _functionList = null;

    public FunctionNode(String name, String displayName) {
        this(name, displayName, displayName);
    }

    public FunctionNode(String name, String displayName, String description) {
        this(name, displayName, description, description);
    }

    public FunctionNode(String name, String displayName, String description, String toolTip) {
        this(name, displayName, description, description, new FunctionList());
    }

    public FunctionNode(String name, String displayName, String description, String toolTip, FunctionListInterface functionList) {
        super(displayName);
        this.setName(name);
        this.setDisplayName(displayName);
        this.setDescription(description);
        if (toolTip != null && toolTip.trim().length() == 0) {
            toolTip = null;
        }
        this.setToolTip(toolTip);
        this.setFunctionList(functionList);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setToolTip(String toolTip) {
        if (toolTip != null && toolTip.trim().length() == 0) {
            toolTip = null;
        }
        this._toolTip = toolTip;
    }

    public void setFunctionList(FunctionListInterface functionList) {
        this._functionList = functionList;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getToolTip() {
        return this._toolTip;
    }

    @Override
    public FunctionListInterface getFunctionListInterface() {
        return this._functionList;
    }

    @Override
    public void setFunctionListInterface(FunctionListInterface functionList) {
        this._functionList = functionList;
    }

    @Override
    public void addFunctionToCategory(FunctionFormatInterface function) {
        this._functionList.addFunctionToList(function);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        String o1str = o1.toString();
        return o1str.compareTo(o2.toString());
    }

    @Override
    public String toString() {
        return this._displayName;
    }

    @Override
    public boolean equals(Object obj) {
        return this._name == null || obj == null ? this._name == obj : this._name.equals(obj);
    }
}

