/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ExpressionTextUndoManager
extends UndoManager {
    public CompoundEdit compoundEdit;
    private JTextComponent editor;
    private int lastOffset;

    public ExpressionTextUndoManager(JTextComponent editor) {
        this.editor = editor;
        editor.getDocument().addUndoableEditListener(this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            return;
        }
        int diff = this.editor.getCaretPosition() - this.lastOffset;
        if (Math.abs(diff) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset += diff;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.compoundEdit = new CompoundEdit(){

            @Override
            public boolean isInProgress() {
                return false;
            }

            @Override
            public void undo() throws CannotUndoException {
                if (ExpressionTextUndoManager.this.compoundEdit != null) {
                    ExpressionTextUndoManager.this.compoundEdit.end();
                }
                super.undo();
                ExpressionTextUndoManager.this.compoundEdit = null;
            }
        };
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }
}

