/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class ExpressionTextPaneCaret
extends DefaultCaret {
    private boolean _selectChecksForSASLiterals = true;
    private boolean _includeQuote = false;
    private String[] _macroSuffixs = new String[]{"n", "d", "t", "dt"};
    private char[] _quoteChars = new char[]{'\'', '\"'};
    private Color disabledTextColor = SystemColor.textText;
    private Color disabledSelectionColor = SystemColor.textInactiveText;
    private Color savedSelectedTextColor = null;
    private Color savedSelectionColor = null;

    public ExpressionTextPaneCaret() {
        this(false);
    }

    public ExpressionTextPaneCaret(boolean includeQuote) {
        this._includeQuote = includeQuote;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._selectChecksForSASLiterals && !e.isConsumed()) {
            int nclicks = e.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e) && nclicks == 2) {
                this.selectSASText();
                return;
            }
        }
        super.mouseClicked(e);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent != null) {
            Component source = focusEvent.getComponent();
            if (source instanceof JTextComponent) {
                JTextComponent text = (JTextComponent)source;
                this.savedSelectedTextColor = text.getSelectedTextColor();
                this.savedSelectionColor = text.getSelectionColor();
                text.setSelectedTextColor(this.disabledTextColor);
                text.setSelectionColor(this.disabledSelectionColor);
                this.setSelectionVisible(false);
                this.setSelectionVisible(true);
                return;
            }
            super.focusLost(focusEvent);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent != null) {
            Component source = focusEvent.getComponent();
            if (source instanceof JTextComponent) {
                JTextComponent text = (JTextComponent)source;
                if (this.savedSelectedTextColor != null) {
                    text.setSelectedTextColor(this.savedSelectedTextColor);
                }
                if (this.savedSelectionColor != null) {
                    text.setSelectionColor(this.savedSelectionColor);
                }
            }
            super.focusGained(focusEvent);
        }
    }

    protected void selectSASText() {
        JTextComponent target = this.getComponent();
        if (target != null) {
            try {
                int offs = target.getCaretPosition();
                int begOffs = Utilities.getWordStart(target, offs);
                int endOffs = Utilities.getWordEnd(target, begOffs);
                if (begOffs > 0) {
                    String text = target.getText();
                    String test = text.substring(begOffs, endOffs);
                    int tickIndex = -1;
                    for (int j = 0; j < this._quoteChars.length; ++j) {
                        int found = test.indexOf(this._quoteChars[j]);
                        if (found <= tickIndex) continue;
                        tickIndex = found;
                    }
                    if (tickIndex > -1 && tickIndex < test.length() - 1) {
                        char tickChar = test.charAt(tickIndex);
                        String suffix = test.substring(tickIndex + 1);
                        block3: for (int i = 0; i < this._macroSuffixs.length; ++i) {
                            String macroSuffix = this._macroSuffixs[i];
                            if (suffix.compareToIgnoreCase(macroSuffix) != 0) continue;
                            for (int backup = begOffs; backup >= 0; --backup) {
                                char prefixChar = text.charAt(backup);
                                if (prefixChar != tickChar) continue;
                                int whereClick = offs - begOffs;
                                if (whereClick < tickIndex) {
                                    if (this._includeQuote) {
                                        begOffs = backup;
                                        continue block3;
                                    }
                                    endOffs = begOffs + tickIndex;
                                    continue block3;
                                }
                                if (whereClick == tickIndex) {
                                    endOffs = begOffs + tickIndex + 1;
                                    begOffs += tickIndex;
                                    continue block3;
                                }
                                begOffs = begOffs + tickIndex + 1;
                                continue block3;
                            }
                        }
                    }
                }
                target.setCaretPosition(begOffs);
                target.moveCaretPosition(endOffs);
            }
            catch (BadLocationException bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public String[] getMacroSuffixs() {
        return this._macroSuffixs;
    }

    public Color getDisabledSelectionColor() {
        return this.disabledSelectionColor;
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setMacroSuffixs(String[] macroSuffixs) {
        this._macroSuffixs = macroSuffixs;
    }

    public void setDisabledSelectionColor(Color disabledSelectionColor) {
        this.disabledSelectionColor = disabledSelectionColor;
    }

    public void setDisabledTextColor(Color disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public char[] getQuoteChars() {
        return this._quoteChars;
    }

    public boolean isSelectChecksForSASLiterals() {
        return this._selectChecksForSASLiterals;
    }

    public void setQuoteChars(char[] quoteChars) {
        this._quoteChars = quoteChars;
    }

    public void setSelectChecksForSASLiterals(boolean selectChecksForSASLiterals) {
        this._selectChecksForSASLiterals = selectChecksForSASLiterals;
    }
}

