/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.CustomTabInterface;
import com.sas.expressions.visuals.DataSourceTreeSelector;
import com.sas.expressions.visuals.DataSourceTreeSelectorEvent;
import com.sas.expressions.visuals.DefaultOperationList;
import com.sas.expressions.visuals.ExpressionBuilderInterface;
import com.sas.expressions.visuals.ExpressionTextPane;
import com.sas.expressions.visuals.FunctionFormatInterface;
import com.sas.expressions.visuals.FunctionTreeSelector;
import com.sas.expressions.visuals.FunctionTreeSelectorEvent;
import com.sas.expressions.visuals.Mnemonics;
import com.sas.expressions.visuals.OperationInterface;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.expressions.visuals.OperationToolbar;
import com.sas.expressions.visuals.OperationToolbarListener;
import com.sas.expressions.visuals.RB;
import com.sas.swing.visuals.FlatSplitPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeModel;

public class ExpressionBuilderPanel
extends JPanel
implements ExpressionBuilderInterface,
DocumentListener {
    public static final String RB_KEY = "ExpressionBuilderPanel.";
    public static final int TAB_NONE = 0;
    public static final int TAB_FUNCTIONS = 1;
    public static final int TAB_DATA_SOURCES = 2;
    public static final int NO_MAX_LINE_LENGTH = -1;
    protected JPanel JPanel_ExpressionAndOkCancel;
    protected JPanel JPanel_OkCancel;
    protected JPanel JPanel_LabelAndExpression;
    protected JScrollPane JScrollPane_Expression;
    protected ImageIcon insertImage;
    protected OperationToolbar myToolBar;
    protected JSplitPane JSplitPane_ExpressionAndTools;
    protected JPanel JPanel_Operations;
    protected JPanel JPanel_Helpers;
    protected JPanel JPanel_Toolbar;
    protected JTabbedPane JTabbedPane_Chooser;
    protected boolean tabPanelVisible = true;
    protected boolean _savedSingleButtonInsertMode = false;
    protected boolean _singleButtonInsertOnToolBar = false;
    protected boolean expressionLabelVisible = true;
    private static SimpleAttributeSet selectTextSet = new SimpleAttributeSet();
    private static SimpleAttributeSet unselectTextSet = new SimpleAttributeSet();
    protected JButton JButton_Insert_InToolBar;
    protected JButton JButton_Insert_BeforeTabs;
    protected FunctionTreeSelector _functionTreeSelector;
    protected DataSourceTreeSelector _dataSourceTreeSelector;
    protected Vector customTabs;
    protected JButton undoButton;
    protected JButton redoButton;
    protected JButton JButton_Validate_BeforeTabs;
    protected ExpressionTextPane _expressionTextPane;
    protected JLabel JLabel_Expression;
    protected String _expressionTextLabel = RB.getStringResource("ExpressionBuilderPanel.", "ExpressionText.Label.txt");
    protected String _expressionTextToolTip = RB.getStringResource("ExpressionBuilderPanel.", "ExpressionText.ToolTip.txt");
    protected String _insertBeforeToolBarLabel = RB.getStringResource("ExpressionBuilderPanel.", "InsertButtonInToolbar.Label.txt");
    protected String _insertBeforeToolBarInitialToolTip = RB.getStringResource("ExpressionBuilderPanel.", "InsertButtonInToolbar.ToolTip.Initial.txt");
    protected String _insertBeforeTabsLabel = RB.getStringResource("ExpressionBuilderPanel.", "InsertButtonBeforeTabs.Label.txt");
    protected String _insertBeforeTabsInitialToolTip = RB.getStringResource("ExpressionBuilderPanel.", "InsertButtonBeforeTabs.ToolTip.Initial.txt");
    protected String _functionsTabLabel = RB.getStringResource("ExpressionBuilderPanel.", "FunctionsTab.Label.txt");
    protected String _functionsTabToolTip = RB.getStringResource("ExpressionBuilderPanel.", "FunctionsTab.ToolTip.txt");
    protected String _dataSourcesTabLabel = RB.getStringResource("ExpressionBuilderPanel.", "DataSourcesTab.Label.txt");
    protected String _dataSourcesTabToolTip = RB.getStringResource("ExpressionBuilderPanel.", "DataSourcesTab.ToolTip.txt");
    protected String _validateButtonLabel = RB.getStringResource("ExpressionBuilderPanel.", "ValidateButtonLabel.txt");
    protected String _validateButtonToolTip = RB.getStringResource("ExpressionBuilderPanel.", "ValidateButton.ToolTip.txt");
    protected int _functionsTabIndex;
    protected int _dataSourcesTabIndex;
    protected int defaultTabsShown = 3;
    protected int maxLineLength;
    private String helpSetDocProd = "expbuild";
    private String helpSetMapID = "expbldwindow";
    boolean doubleClickInsertEnabled = false;
    boolean doubleClickInsertListValueEnabled = true;
    boolean doubleClickInsertTreeLeafEnabled = true;
    protected boolean m_readOnly = false;
    int _helpersMinWidth = 180;
    int _helpersMinHeight = 270;
    int _helpersPrefWidth = 200;
    int _helpersPrefHeight = this._helpersMinHeight;

    public ExpressionBuilderPanel() {
        this.init();
    }

    public ExpressionBuilderPanel(int defaultTabsShown) {
        this.defaultTabsShown = defaultTabsShown;
        this.init();
    }

    public ExpressionBuilderPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public ExpressionBuilderPanel(boolean isDoubleBuffered, int defaultTabsShown) {
        super(isDoubleBuffered);
        this.defaultTabsShown = defaultTabsShown;
        this.init();
    }

    public ExpressionBuilderPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public ExpressionBuilderPanel(LayoutManager layout, int defaultTabsShown) {
        super(layout);
        this.defaultTabsShown = defaultTabsShown;
        this.init();
    }

    public ExpressionBuilderPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    public ExpressionBuilderPanel(LayoutManager layout, boolean isDoubleBuffered, int defaultTabsShown) {
        super(layout, isDoubleBuffered);
        this.defaultTabsShown = defaultTabsShown;
        this.init();
    }

    public void init() {
        this.setMaximumLineLength(-1);
        this.setEnabled(false);
        this.createComponents();
        this.repaint(0L);
        this.initConnections();
        this.validate();
        this.setEnabled(true);
        this.repaint();
        this.setUndoRedoSensitivities();
    }

    public void dispose() {
        if (this._expressionTextPane != null) {
            this._expressionTextPane.dispose();
        }
    }

    public String getDefaultHelpProduct() {
        return this.helpSetDocProd;
    }

    public String getDefaultHelpMapID() {
        return this.helpSetMapID;
    }

    public void createComponents() {
        try {
            boolean initiallyShowInsert_onTabs;
            this.setName("JPanel_ExpressionBuilderPanel");
            this.setLayout(new GridBagLayout());
            this.setName("JPanel_ExpressionBuilder");
            this.insertImage = ExpressionBuilderPanel.findImageIcon("InsertIntoExpressionAbove.image");
            this.JPanel_ExpressionAndOkCancel = new JPanel();
            this.JPanel_ExpressionAndOkCancel.setLayout(new GridBagLayout());
            this.JPanel_ExpressionAndOkCancel.setName("JPanel_ExpressionAndOkCancel");
            this.JPanel_ExpressionAndOkCancel.setOpaque(false);
            this.JPanel_ExpressionAndOkCancel.setBorder(new EmptyBorder(0, 0, 3, 0));
            this.JLabel_Expression = Mnemonics.newMnemonicLabel(this._expressionTextLabel);
            this.JLabel_Expression.setOpaque(false);
            this._expressionTextPane = new ExpressionTextPane();
            this._expressionTextPane.setName("ExpressionTextPane");
            this._expressionTextPane.setToolTipText(this._expressionTextToolTip);
            this.JLabel_Expression.setLabelFor(this._expressionTextPane);
            StyleConstants.setBackground(selectTextSet, SystemColor.textInactiveText);
            StyleConstants.setBackground(unselectTextSet, SystemColor.text);
            this.JScrollPane_Expression = new JScrollPane(this._expressionTextPane);
            this.JScrollPane_Expression.setName("JScrollPane_Expression");
            this.JScrollPane_Expression.setOpaque(false);
            this.setExpressionLabelVisible(this.expressionLabelVisible);
            this.JPanel_LabelAndExpression = new JPanel();
            this.JPanel_LabelAndExpression.setLayout(new GridBagLayout());
            this.JPanel_LabelAndExpression.setName("JPanel_LabelAndExpression");
            this.JPanel_LabelAndExpression.setOpaque(false);
            this.JPanel_LabelAndExpression.add((Component)this.JLabel_Expression, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 0, 2, 0), 0, 0));
            this.JPanel_LabelAndExpression.add((Component)this.JScrollPane_Expression, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 4, 0, 0), 1, 1));
            this.JPanel_ExpressionAndOkCancel.add((Component)this.JPanel_LabelAndExpression, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.JPanel_OkCancel = new JPanel();
            this.JPanel_OkCancel.setLayout(new GridBagLayout());
            this.JPanel_OkCancel.setName("JPanel_OkCancel");
            this.JPanel_OkCancel.setOpaque(false);
            this.JPanel_OkCancel.setBorder(new EmptyBorder(2, 2, 3, 2));
            this.JPanel_ExpressionAndOkCancel.add((Component)this.JPanel_OkCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.JPanel_Toolbar = this.createAndLayoutToolbar();
            this.JPanel_ExpressionAndOkCancel.add((Component)this.JPanel_Toolbar, new GridBagConstraints(0, 9, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 4, 2, 4), 0, 0));
            this.JPanel_Helpers = new JPanel();
            this.JPanel_Helpers.setLayout(new GridBagLayout());
            this.JPanel_Helpers.setName("JPanel_Helpers");
            JPanel undoRedoPanel = new JPanel();
            this.undoButton = new JButton();
            this.undoButton.setVisible(true);
            undoRedoPanel.add(this.undoButton);
            this.redoButton = new JButton();
            this.redoButton.setVisible(true);
            undoRedoPanel.add(this.redoButton);
            this.JPanel_Helpers.add((Component)undoRedoPanel, new GridBagConstraints(1, 0, 1, 1, 2.0, 0.0, 17, 0, new Insets(2, 4, 0, 4), 0, 0));
            this.JButton_Validate_BeforeTabs = Mnemonics.newNmemonicButton(this._validateButtonLabel);
            this.JButton_Validate_BeforeTabs.setName("JButton_Validate_BeforeTabs");
            this.JButton_Validate_BeforeTabs.setToolTipText(this._validateButtonToolTip);
            this.JButton_Validate_BeforeTabs.setVisible(false);
            this.JPanel_Helpers.add((Component)this.JButton_Validate_BeforeTabs, new GridBagConstraints(3, 0, 1, 1, 2.0, 0.0, 13, 0, new Insets(2, 4, 0, 4), 0, 0));
            this.JButton_Insert_BeforeTabs = Mnemonics.newNmemonicButton(this.insertImage, this._insertBeforeTabsLabel);
            this.JButton_Insert_BeforeTabs.setName("JButton_Insert_BeforeTabs");
            this.JButton_Insert_BeforeTabs.setToolTipText(this._insertBeforeTabsInitialToolTip);
            boolean initiallyShowInsert_beforeTabs = this._savedSingleButtonInsertMode && !this._singleButtonInsertOnToolBar;
            this.JButton_Insert_BeforeTabs.setVisible(initiallyShowInsert_beforeTabs);
            this.JPanel_Helpers.add((Component)this.JButton_Insert_BeforeTabs, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 0, 4), 0, 0));
            this.JTabbedPane_Chooser = new JTabbedPane();
            this.JTabbedPane_Chooser.setName("JTabbedPane_Chooser");
            this.JTabbedPane_Chooser.setOpaque(false);
            this.JTabbedPane_Chooser.setFocusable(true);
            boolean bl = initiallyShowInsert_onTabs = !this._savedSingleButtonInsertMode;
            if ((this.defaultTabsShown & 1) != 0) {
                this._functionTreeSelector = new FunctionTreeSelector();
                this._functionTreeSelector.setInsertButtonVisible(initiallyShowInsert_onTabs);
                this.addFunctionsTab();
            }
            if ((this.defaultTabsShown & 2) != 0) {
                this._dataSourceTreeSelector = new DataSourceTreeSelector();
                this._dataSourceTreeSelector.setInsertButtonVisible(initiallyShowInsert_onTabs);
                this.addDataSourcesTab();
            }
            this.setTabSelected(this.getFunctionsTabIndex());
            this.doBugFixForTabHotKeys();
            this.JPanel_Helpers.add((Component)this.JTabbedPane_Chooser, new GridBagConstraints(1, 1, 0, 0, 1.0, 1.0, 15, 1, new Insets(2, 4, 2, 4), 0, 0));
            this.JPanel_ExpressionAndOkCancel.setMinimumSize(new Dimension(350, 100));
            this.JPanel_ExpressionAndOkCancel.setPreferredSize(new Dimension(460, 100));
            this.setupHelperSizes();
            FlatSplitPane splitExpressionAndTools = new FlatSplitPane(2, 5, 5);
            this.JSplitPane_ExpressionAndTools = splitExpressionAndTools.getSplitter();
            this.JSplitPane_ExpressionAndTools.setTopComponent(this.JPanel_ExpressionAndOkCancel);
            this.JSplitPane_ExpressionAndTools.setBottomComponent(this.JPanel_Helpers);
            this.JSplitPane_ExpressionAndTools.setContinuousLayout(true);
            this.JSplitPane_ExpressionAndTools.setDividerSize(3);
            this.JSplitPane_ExpressionAndTools.setName("JSplitPane_ExpressionAndTools");
            this.JSplitPane_ExpressionAndTools.setOpaque(false);
            this.JSplitPane_ExpressionAndTools.setResizeWeight(0.0);
            this.add((Component)this.JSplitPane_ExpressionAndTools, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setReadOnly(this.m_readOnly);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    JPanel createAndLayoutToolbar() {
        JPanel toolbar = new JPanel();
        toolbar.setBorder(null);
        toolbar.setLayout(new GridBagLayout());
        toolbar.setName("JPanel_Toolbar");
        toolbar.setOpaque(false);
        this.myToolBar = new OperationToolbar(new DefaultOperationList());
        this.myToolBar.setName("JPanel_Operations");
        toolbar.add((Component)this.myToolBar, new GridBagConstraints(0, 0, 1, 0, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        this.JButton_Insert_InToolBar = Mnemonics.newNmemonicButton(this.insertImage, this._insertBeforeToolBarLabel);
        this.JButton_Insert_InToolBar.setName("JButton_Insert_InToolBar");
        this.JButton_Insert_InToolBar.setToolTipText(this._insertBeforeToolBarInitialToolTip);
        boolean initiallyShowInsert_inToolbar = this._savedSingleButtonInsertMode && this._singleButtonInsertOnToolBar;
        this.JButton_Insert_InToolBar.setVisible(initiallyShowInsert_inToolbar);
        toolbar.add((Component)this.JButton_Insert_InToolBar, new GridBagConstraints(1, 0, 1, 0, 0.0, 0.0, 10, 0, new Insets(3, 4, 0, 2), 0, 0));
        return toolbar;
    }

    void addFunctionsTab() {
        if ((this.defaultTabsShown & 1) != 0) {
            Mnemonics.addMnemoicTab(this.JTabbedPane_Chooser, this._functionsTabLabel, null, this._functionTreeSelector, this._functionsTabToolTip);
            this._functionsTabIndex = this.JTabbedPane_Chooser.indexOfComponent(this._functionTreeSelector);
        }
    }

    void addDataSourcesTab() {
        if ((this.defaultTabsShown & 2) != 0) {
            Mnemonics.addMnemoicTab(this.JTabbedPane_Chooser, this._dataSourcesTabLabel, null, this._dataSourceTreeSelector, this._dataSourcesTabToolTip);
            this._dataSourcesTabIndex = this.JTabbedPane_Chooser.indexOfComponent(this._dataSourceTreeSelector);
        }
    }

    public boolean isSourceDescriptionEnabled() {
        if (this._dataSourceTreeSelector != null) {
            return this._dataSourceTreeSelector.isSourceDescriptionEnabled();
        }
        return false;
    }

    public void setSourceDescriptionEnabled(boolean enable) {
        if (this._dataSourceTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "DataSourceTreeSelectorInvalid.ex.txt"));
        }
        this._dataSourceTreeSelector.setSourceDescriptionEnabled(enable);
    }

    public void initConnections() {
        ActionListener insertButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == ExpressionBuilderPanel.this.JButton_Insert_InToolBar || source == ExpressionBuilderPanel.this.JButton_Insert_BeforeTabs) {
                        Component currentTab = ExpressionBuilderPanel.this.JTabbedPane_Chooser.getSelectedComponent();
                        Object item = null;
                        if (currentTab == ExpressionBuilderPanel.this._dataSourceTreeSelector) {
                            item = ExpressionBuilderPanel.this._dataSourceTreeSelector.getSelectedObject();
                            if (item != null) {
                                boolean isDataValue = ExpressionBuilderPanel.this._dataSourceTreeSelector.isSelectionFromList();
                                if (isDataValue) {
                                    ExpressionBuilderPanel.this.insertFromValuesList(item);
                                } else {
                                    ExpressionBuilderPanel.this.insertFromSourcesTree(item);
                                }
                            }
                        } else if (currentTab == ExpressionBuilderPanel.this._functionTreeSelector) {
                            item = ExpressionBuilderPanel.this._functionTreeSelector.getSelectedObject();
                            if (item != null) {
                                boolean isFunction = ExpressionBuilderPanel.this._functionTreeSelector.isSelectionFromList();
                                if (isFunction) {
                                    ExpressionBuilderPanel.this.insertFromFunctionsList(item);
                                } else {
                                    ExpressionBuilderPanel.this.insertFromCategoryTree(item);
                                }
                            }
                        } else {
                            CustomTabInterface customTab = ExpressionBuilderPanel.this.getSelectedCustomTab();
                            if (customTab != null) {
                                ExpressionBuilderPanel.this._expressionTextPane.replaceSelectionWithTextAndUnselect(customTab.getInsertText());
                            }
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JButton_Insert_InToolBar.addActionListener(insertButtonActionListener);
        this.JButton_Insert_BeforeTabs.addActionListener(insertButtonActionListener);
        ActionListener dataSourceTreeSelectorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (event instanceof DataSourceTreeSelectorEvent) {
                        DataSourceTreeSelectorEvent dstse = (DataSourceTreeSelectorEvent)event;
                        if (source == ExpressionBuilderPanel.this._dataSourceTreeSelector) {
                            Object item = dstse.getItem();
                            int id = dstse.getID();
                            switch (id) {
                                case 2003: 
                                case 2004: {
                                    ExpressionBuilderPanel.this.updateInsertButtons();
                                    break;
                                }
                                case 2002: {
                                    ExpressionBuilderPanel.this.insertFromValuesList(item);
                                    break;
                                }
                                case 2001: {
                                    ExpressionBuilderPanel.this.insertFromSourcesTree(item);
                                }
                            }
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.addActionEventListener(dataSourceTreeSelectorActionListener);
        }
        ActionListener functionTreeSelectorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (event instanceof FunctionTreeSelectorEvent) {
                        FunctionTreeSelectorEvent ftse = (FunctionTreeSelectorEvent)event;
                        if (source == ExpressionBuilderPanel.this._functionTreeSelector) {
                            int id = ftse.getID();
                            switch (id) {
                                case 2003: 
                                case 2004: {
                                    ExpressionBuilderPanel.this.updateInsertButtons();
                                    break;
                                }
                                case 2002: {
                                    Object item = ftse.getItem();
                                    ExpressionBuilderPanel.this.insertFromFunctionsList(item);
                                    break;
                                }
                                case 2001: {
                                    Object item = ftse.getItem();
                                    ExpressionBuilderPanel.this.insertFromCategoryTree(item);
                                    break;
                                }
                            }
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.addActionEventListener(functionTreeSelectorActionListener);
        }
        OperationToolbarListener toolbarListener1 = new OperationToolbarListener(){

            @Override
            public void operationPerformed(ActionEvent event, OperationInterface operation) {
                ExpressionBuilderPanel.this._expressionTextPane.insertOperation(operation);
            }
        };
        this.myToolBar.addOperationToolbarListener(toolbarListener1);
        FocusListener myInnerFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Object source = focusEvent.getSource();
                Component opposite = focusEvent.getOppositeComponent();
                if (source == ExpressionBuilderPanel.this._expressionTextPane) {
                    ExpressionBuilderPanel parent = ExpressionBuilderPanel.this;
                    FocusEvent newEvent = new FocusEvent(parent, focusEvent.getID(), focusEvent.isTemporary(), opposite);
                    this.myNotify(newEvent, true);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Object source = focusEvent.getSource();
                Component opposite = focusEvent.getOppositeComponent();
                if (source == ExpressionBuilderPanel.this._expressionTextPane) {
                    ExpressionBuilderPanel parent = ExpressionBuilderPanel.this;
                    FocusEvent newEvent = new FocusEvent(parent, focusEvent.getID(), focusEvent.isTemporary(), opposite);
                    this.myNotify(newEvent, false);
                }
            }

            void myNotify(FocusEvent focusEvent, boolean gained) {
                ExpressionBuilderPanel parent = ExpressionBuilderPanel.this;
                FocusListener[] listeners = parent.getFocusListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    FocusListener listener = listeners[i];
                    if (gained) {
                        listener.focusGained(focusEvent);
                        continue;
                    }
                    listener.focusLost(focusEvent);
                }
            }
        };
        this._expressionTextPane.addFocusListener(myInnerFocusListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == ExpressionBuilderPanel.this.JTabbedPane_Chooser) {
                        ExpressionBuilderPanel.this.updateInsertButtons();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JTabbedPane_Chooser.addChangeListener(changeListener);
        this._expressionTextPane.getDocument().addDocumentListener(this);
        this.undoButton.setAction(new UndoAction());
        this.redoButton.setAction(new RedoAction());
    }

    public Action getUndoAction() {
        return this.undoButton.getAction();
    }

    public Action getRedoAction() {
        return this.redoButton.getAction();
    }

    public JComponent getOkCancelContainer() {
        return this.JPanel_OkCancel;
    }

    public void insertFromFunctionsList(Object item) {
        if (item instanceof FunctionFormatInterface) {
            this._expressionTextPane.formatSelection((FunctionFormatInterface)item);
        } else {
            this._expressionTextPane.replaceSelectionWithTextAndUnselect(item.toString());
        }
    }

    public void insertFromCategoryTree(Object item) {
    }

    public void insertFromValuesList(Object item) {
        if (item == null || this._dataSourceTreeSelector == null) {
            return;
        }
        String text = this._dataSourceTreeSelector.getTextFromListSelectedObject(item);
        if (text != null) {
            this._expressionTextPane.replaceSelectionWithTextAndUnselect(text);
        }
    }

    public void insertFromSourcesTree(Object item) {
        if (item == null || this._dataSourceTreeSelector == null) {
            return;
        }
        String text = this._dataSourceTreeSelector.getTextFromTreeSelectedObject(item);
        if (text != null) {
            this._expressionTextPane.replaceSelectionWithTextAndUnselect(text);
        }
    }

    public void setDoubleClickInsertEnabled(boolean enable) {
        this.doubleClickInsertEnabled = enable;
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.setDoubleClickInsertEnabled(enable);
        }
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.setdoubleClickInsertListValueEnabled(enable);
        }
    }

    public boolean isDoubleClickInsertEnabled() {
        return this.doubleClickInsertEnabled;
    }

    public void setdoubleClickInsertListValueEnabled(boolean enable) {
        this.doubleClickInsertListValueEnabled = enable;
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.setdoubleClickInsertListValueEnabled(enable);
        }
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.setdoubleClickInsertListValueEnabled(enable);
        }
    }

    public boolean isDoubleClickInsertListValueEnabled() {
        return this.doubleClickInsertListValueEnabled;
    }

    public void setDoubleClickInsertTreeLeafEnabled(boolean enable) {
        this.doubleClickInsertTreeLeafEnabled = enable;
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.setDoubleClickInsertTreeLeafEnabled(enable);
        }
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.setDoubleClickInsertTreeLeafEnabled(enable);
        }
    }

    public boolean isDoubleClickInsertTreeLeafEnabled() {
        return this.doubleClickInsertTreeLeafEnabled;
    }

    public ExpressionTextPane getExpressionTextPane() {
        return this._expressionTextPane;
    }

    @Override
    public String getExpressionText() {
        return this._expressionTextPane.getText();
    }

    @Override
    public void setExpressionText(String value) {
        this._expressionTextPane.setText(value);
    }

    @Override
    public TreeModel getDataSourceTreeModel() {
        if (this._dataSourceTreeSelector != null) {
            return this._dataSourceTreeSelector.getDataSourceTreeModel();
        }
        return null;
    }

    @Override
    public void setDataSourceTreeModel(TreeModel value) {
        if (this._dataSourceTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "DataSourceTreeSelectorInvalid.ex.txt"));
        }
        this._dataSourceTreeSelector.setDataSourceTreeModel(value);
        if (value == null && this._dataSourceTreeSelector.getParent() != null) {
            this._dataSourceTreeSelector.getParent().remove(this._dataSourceTreeSelector);
        } else if (value != null && this._dataSourceTreeSelector.getParent() == null) {
            this.addDataSourcesTab();
        }
        this.validate();
    }

    @Override
    public TreeModel getFunctionListTreeModel() {
        if (this._functionTreeSelector != null) {
            return this._functionTreeSelector.getFunctionListTreeModel();
        }
        return null;
    }

    @Override
    public void setFunctionListTreeModel(TreeModel value) {
        if (this._functionTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "FunctionTreeSelectorInvalid.ex.txt"));
        }
        this._functionTreeSelector.setFunctionListTreeModel(value);
        if (value == null && this._functionTreeSelector.getParent() != null) {
            this._functionTreeSelector.getParent().remove(this._functionTreeSelector);
        } else if (value != null && this._functionTreeSelector.getParent() == null) {
            this.addFunctionsTab();
        }
        this.validate();
    }

    @Override
    public void setOperationList(OperationListInterface value) {
        this.myToolBar.setOperationList(value);
        this.validate();
    }

    @Override
    public OperationListInterface getOperationList() {
        return this.myToolBar.getOperationList();
    }

    @Override
    public void addCustomTab(Component customTab, String title, String toolTip) {
        if (!(customTab instanceof CustomTabInterface)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "CustomTabImplementInterface.ex.txt"));
        }
        Mnemonics.addMnemoicTab(this.JTabbedPane_Chooser, title, null, customTab, toolTip);
        if (this.customTabs == null) {
            this.customTabs = new Vector();
        }
        this.customTabs.add(customTab);
        ((CustomTabInterface)((Object)customTab)).setExpressionBuilder(this);
    }

    @Override
    public void insertExpressionText(String text) {
        this._expressionTextPane.replaceSelectionWithTextAndUnselect(text);
    }

    @Override
    public void insertExpressionTextChanged() {
        CustomTabInterface customTab = this.getSelectedCustomTab();
        if (customTab != null) {
            boolean enabled = customTab.isInsertButtonEnabled();
            this.JButton_Insert_InToolBar.setEnabled(enabled);
            this.JButton_Insert_BeforeTabs.setEnabled(enabled);
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean value) {
        if (value == this.m_readOnly) {
            return;
        }
        if (value) {
            this.m_readOnly = true;
            this.JPanel_Helpers.setVisible(false);
            this._expressionTextPane.setEnabled(false);
            this._expressionTextPane.setBackground(Color.lightGray);
        } else {
            this.m_readOnly = false;
            this.JPanel_Helpers.setVisible(true);
            this._expressionTextPane.setEnabled(true);
            this._expressionTextPane.setBackground(Color.white);
        }
    }

    public boolean isSingleButtonInsertMode() {
        return this.JButton_Insert_InToolBar.isVisible() || this.JButton_Insert_BeforeTabs.isVisible();
    }

    public void setSingleButtonInsertMode(boolean enable) {
        if (enable && !this.isTabPanelVisible()) {
            return;
        }
        this.JButton_Insert_InToolBar.setVisible(enable && this.isSingleButtonInsertInToolBar());
        this.JButton_Insert_BeforeTabs.setVisible(enable && !this.isSingleButtonInsertInToolBar());
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.setInsertButtonVisible(!enable);
        }
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.setInsertButtonVisible(!enable);
        }
        this.validate();
    }

    public boolean isTabPanelVisible() {
        return this.tabPanelVisible;
    }

    public void setTabPanelVisible(boolean showTabPanel) {
        if (this.tabPanelVisible == showTabPanel) {
            return;
        }
        this.tabPanelVisible = showTabPanel;
        this.setEnabled(false);
        if (showTabPanel) {
            this.removeAll();
            this.JTabbedPane_Chooser.setVisible(true);
            this.setupHelperSizes();
            this.JSplitPane_ExpressionAndTools.setTopComponent(this.JPanel_ExpressionAndOkCancel);
            this.JSplitPane_ExpressionAndTools.setBottomComponent(this.JPanel_Helpers);
            this.add((Component)this.JSplitPane_ExpressionAndTools, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setSingleButtonInsertMode(this._savedSingleButtonInsertMode);
        } else {
            this._savedSingleButtonInsertMode = this.isSingleButtonInsertMode();
            this.removeAll();
            this.JTabbedPane_Chooser.setVisible(false);
            this.setupHelperSizes();
            this.JSplitPane_ExpressionAndTools.setTopComponent(null);
            this.JSplitPane_ExpressionAndTools.setBottomComponent(null);
            this.add((Component)this.JPanel_ExpressionAndOkCancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 1));
            this.add((Component)this.JPanel_Helpers, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setSingleButtonInsertMode(false);
        }
        this.validate();
        this.setEnabled(true);
        this.repaint();
    }

    public boolean isSingleButtonInsertInToolBar() {
        return this._singleButtonInsertOnToolBar;
    }

    public void setSingleButtonInsertInToolBar(boolean enable) {
        this._singleButtonInsertOnToolBar = enable;
        boolean singleButtonInsertMode = this.isSingleButtonInsertMode();
        if (enable && !this.isTabPanelVisible()) {
            return;
        }
        this.JButton_Insert_InToolBar.setVisible(singleButtonInsertMode && enable);
        this.JButton_Insert_BeforeTabs.setVisible(singleButtonInsertMode && !enable);
        if (this._functionTreeSelector != null) {
            this._functionTreeSelector.setInsertButtonVisible(!singleButtonInsertMode);
        }
        if (this._dataSourceTreeSelector != null) {
            this._dataSourceTreeSelector.setInsertButtonVisible(!singleButtonInsertMode);
        }
        this.validate();
    }

    public boolean isExpressionLabelVisible() {
        return this.expressionLabelVisible;
    }

    public void setExpressionLabelVisible(boolean visible) {
        this.JLabel_Expression.setVisible(visible);
    }

    private static ImageIcon findImageIcon(String resourceKey) {
        String path = RB.getStringResource("ImageLocation.notrans");
        String filename = RB.getStringResource(RB_KEY, resourceKey);
        String strIconPath = path + filename;
        URL url = null;
        ImageIcon returnValue = null;
        try {
            url = ClassLoader.getSystemResource(strIconPath);
            returnValue = new ImageIcon(url);
        }
        catch (Exception e) {
            returnValue = null;
        }
        return returnValue;
    }

    public String getExpressionTextLabel(String label) {
        return this._expressionTextLabel;
    }

    public String getExpressionTextLabel() {
        return this._expressionTextLabel;
    }

    public void setExpressionTextLabel(String label) {
        Mnemonics.setMnemonicLabel(this.JLabel_Expression, label);
        this._expressionTextLabel = label;
    }

    public String getCategoryTreeLabel() {
        if (this._functionTreeSelector != null) {
            return this._functionTreeSelector.getCategoryTreeLabel();
        }
        return null;
    }

    public void setCategoryTreeLabel(String label) {
        if (this._functionTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "FunctionTreeSelectorInvalid.ex.txt"));
        }
        this._functionTreeSelector.setCategoryTreeLabel(label);
    }

    public String getFunctionListLabel() {
        if (this._functionTreeSelector != null) {
            return this._functionTreeSelector.getFunctionListLabel();
        }
        return null;
    }

    public void setFunctionListLabel(String label) {
        if (this._functionTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "FunctionTreeSelectorInvalid.ex.txt"));
        }
        this._functionTreeSelector.setFunctionListLabel(label);
    }

    public String getDataElementsTreeLabel() {
        if (this._dataSourceTreeSelector != null) {
            return this._dataSourceTreeSelector.getDataElementsTreeLabel();
        }
        return null;
    }

    public void setDataElementsTreeLabel(String label) {
        if (this._dataSourceTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "DataSourceTreeSelectorInvalid.ex.txt"));
        }
        this._dataSourceTreeSelector.setDataElementsTreeLabel(label);
    }

    public String getDataValuesListLabel() {
        if (this._dataSourceTreeSelector != null) {
            return this._dataSourceTreeSelector.getDataValuesListLabel();
        }
        return null;
    }

    public void setDataValuesListLabel(String label) {
        if (this._dataSourceTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "DataSourceTreeSelectorInvalid.ex.txt"));
        }
        this._dataSourceTreeSelector.setDataValuesListLabel(label);
    }

    public String getDataSourcesTabLabel() {
        return this._dataSourcesTabLabel;
    }

    public void setDataSourcesTabLabel(String label) {
        if (this._dataSourceTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "DataSourceTreeSelectorInvalid.ex.txt"));
        }
        Mnemonics.setMnemonicTab(this.JTabbedPane_Chooser, this._dataSourceTreeSelector, label);
        this._dataSourcesTabLabel = label;
    }

    public String getFunctionsTabLabel() {
        return this._functionsTabLabel;
    }

    public void setFunctionsTabLabel(String label) {
        if (this._functionTreeSelector == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "FunctionTreeSelectorInvalid.ex.txt"));
        }
        Mnemonics.setMnemonicTab(this.JTabbedPane_Chooser, this._functionTreeSelector, label);
        this._functionsTabLabel = label;
    }

    @Override
    public void grabFocus() {
        this._expressionTextPane.grabFocus();
    }

    public boolean isValidationButtonVisible() {
        return this.JButton_Validate_BeforeTabs.isVisible();
    }

    public void setValidationButtonVisible(boolean visible) {
        if (this.JButton_Validate_BeforeTabs.isVisible() != visible) {
            this.JButton_Validate_BeforeTabs.setVisible(visible);
        }
        this.setupHelperSizes();
        this.validate();
    }

    public void addValidateActionListener(ActionListener action) {
        this.JButton_Validate_BeforeTabs.addActionListener(action);
    }

    public void removeValidateActionListener(ActionListener action) {
        this.JButton_Validate_BeforeTabs.removeActionListener(action);
    }

    public void setUndoRedoButtonsVisible(boolean visible) {
        if (this.undoButton.isVisible() != visible) {
            this.undoButton.setVisible(visible);
        }
        if (this.redoButton.isVisible() != visible) {
            this.redoButton.setVisible(visible);
        }
    }

    public boolean isUndoRedoButtonsVisible() {
        return this.undoButton.isVisible();
    }

    public int getFunctionsTabIndex() {
        return this._functionsTabIndex;
    }

    public int getDataSourcesTabIndex() {
        return this._dataSourcesTabIndex;
    }

    public void setTabSelected(int tabIndex) {
        if (tabIndex < this.JTabbedPane_Chooser.getTabCount()) {
            this.JTabbedPane_Chooser.setSelectedIndex(tabIndex);
            this.updateInsertButtons();
        }
    }

    public int getTabSelected() {
        return this.JTabbedPane_Chooser.getSelectedIndex();
    }

    protected CustomTabInterface getSelectedCustomTab() {
        if (this.customTabs != null) {
            Component currentTab = this.JTabbedPane_Chooser.getSelectedComponent();
            for (int i = 0; i < this.customTabs.size(); ++i) {
                if (currentTab != (Component)this.customTabs.get(i)) continue;
                return (CustomTabInterface)this.customTabs.get(i);
            }
        }
        return null;
    }

    public void setMaximumLineLength(int length) {
        this.maxLineLength = length;
    }

    public int getMaximumLineLength() {
        return this.maxLineLength;
    }

    public LineInfo computeMaxLineLength() {
        return this.computeMaxLineLength(this.getExpressionText());
    }

    public LineInfo computeMaxLineLength(String buffer) {
        LineInfo lineInfo = new LineInfo();
        String[] lines = buffer.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= lineInfo.getLine().length()) continue;
            lineInfo.setLine(lines[i]);
            lineInfo.setLineNumber(i + 1);
        }
        return lineInfo;
    }

    public String validateLineLengths(boolean showDialog) {
        if (this.maxLineLength == -1) {
            return null;
        }
        LineInfo lineInfo = this.computeMaxLineLength();
        if (lineInfo.getLine().length() > this.maxLineLength) {
            String errorMsg = MessageFormat.format(RB.getStringResource(RB_KEY, "lineTooLong.fmt"), lineInfo.getLineNumber() + "", this.condenseLine(lineInfo.getLine(), 20), this.maxLineLength + "");
            if (showDialog) {
                JOptionPane.showMessageDialog(this, errorMsg, RB.getStringResource(RB_KEY, "expressionError.txt"), 0);
            }
            return errorMsg;
        }
        return null;
    }

    protected String condenseLine(String line, int minSegmentSize) {
        if (line.length() <= minSegmentSize * 2) {
            return line;
        }
        int i = 0;
        String[] words = line.split(" ");
        StringBuffer firstPart = new StringBuffer();
        while (i < words.length && firstPart.length() < minSegmentSize) {
            firstPart.append(words[i++]).append(" ");
        }
        i = words.length - 1;
        StringBuffer lastPart = new StringBuffer();
        while (i >= 0 && lastPart.length() < minSegmentSize) {
            lastPart.insert(0, " ").insert(0, words[i--]);
        }
        String condensedLine = MessageFormat.format(RB.getStringResource(RB_KEY, "abbreviatedLine.fmt"), firstPart, lastPart);
        return condensedLine;
    }

    protected void updateInsertButtons() {
        Component currentTab = this.JTabbedPane_Chooser.getSelectedComponent();
        String tooltip = null;
        boolean enabled = false;
        if (currentTab == this._dataSourceTreeSelector) {
            tooltip = this._dataSourceTreeSelector.getInsertButtonToolTip();
            enabled = this._dataSourceTreeSelector.isInsertButtonEnabled();
        } else if (currentTab == this._functionTreeSelector) {
            tooltip = this._functionTreeSelector.getInsertButtonToolTip();
            enabled = this._functionTreeSelector.isInsertButtonEnabled();
        } else {
            CustomTabInterface customTab = this.getSelectedCustomTab();
            if (customTab != null) {
                enabled = customTab.isInsertButtonEnabled();
            }
        }
        if (tooltip != null && tooltip.trim().length() == 0) {
            tooltip = null;
        }
        this.JButton_Insert_InToolBar.setToolTipText(tooltip);
        this.JButton_Insert_InToolBar.setEnabled(enabled);
        this.JButton_Insert_BeforeTabs.setToolTipText(tooltip);
        this.JButton_Insert_BeforeTabs.setEnabled(enabled);
    }

    void setupHelperSizes() {
        if (this.tabPanelVisible) {
            this.JPanel_Helpers.setMinimumSize(new Dimension(this._helpersMinWidth, this._helpersMinHeight));
        } else if (this.JButton_Validate_BeforeTabs.isVisible()) {
            this.JPanel_Helpers.setMinimumSize(new Dimension(50, 30));
            this.JPanel_Helpers.setPreferredSize(new Dimension(50, 30));
        } else {
            this.JPanel_Helpers.setMinimumSize(new Dimension(0, 0));
            this.JPanel_Helpers.setPreferredSize(new Dimension(0, 0));
        }
    }

    void doBugFixForTabHotKeys() {
        JPanel bugfixLabelAndTabForChooser = new JPanel();
        bugfixLabelAndTabForChooser.setLayout(new GridLayout(0, 1, 0, 0));
        bugfixLabelAndTabForChooser.setOpaque(false);
        int numTabs = this.JTabbedPane_Chooser.getTabCount();
        for (int index = 0; index < numTabs; ++index) {
            int key = this.JTabbedPane_Chooser.getMnemonicAt(index);
            JLabel label = new JLabel();
            label.setLabelFor(this.JTabbedPane_Chooser);
            label.setBorder(null);
            label.setOpaque(true);
            label.setDisplayedMnemonic(key);
            label.setMinimumSize(new Dimension(0, 0));
            label.setPreferredSize(new Dimension(0, 0));
            label.setMaximumSize(new Dimension(0, 0));
            bugfixLabelAndTabForChooser.add(label);
        }
        this.JPanel_Helpers.add((Component)bugfixLabelAndTabForChooser, new GridBagConstraints(0, 1, 0, 0, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpressionBuilderPanel.this.setUndoRedoSensitivities();
            }
        });
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpressionBuilderPanel.this.setUndoRedoSensitivities();
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpressionBuilderPanel.this.setUndoRedoSensitivities();
            }
        });
    }

    protected void setUndoRedoSensitivities() {
        this.undoButton.setEnabled(this._expressionTextPane.isUndoAvailable());
        this.redoButton.setEnabled(this._expressionTextPane.isRedoAvailable());
    }

    public class LineInfo {
        protected String line = "";
        protected int lineNumber = 0;

        public String getLine() {
            return this.line;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public void setLineNumber(int num) {
            this.lineNumber = num;
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(RB.getStringResource(ExpressionBuilderPanel.RB_KEY, "redo.txt"));
            this.putValue("ShortDescription", RB.getStringResource(ExpressionBuilderPanel.RB_KEY, "redoToolTip.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.firePropertyChange("buttonPressed", null, null);
            ExpressionBuilderPanel.this._expressionTextPane.redo();
            ExpressionBuilderPanel.this.setUndoRedoSensitivities();
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(RB.getStringResource(ExpressionBuilderPanel.RB_KEY, "undo.txt"));
            this.putValue("ShortDescription", RB.getStringResource(ExpressionBuilderPanel.RB_KEY, "undoToolTip.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.firePropertyChange("buttonPressed", null, null);
            ExpressionBuilderPanel.this._expressionTextPane.undo();
            ExpressionBuilderPanel.this.setUndoRedoSensitivities();
        }
    }
}

