/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class DoublePartDescriptionPanel
extends JPanel {
    protected JTextArea _upperTextArea;
    protected JTextArea _lowerTextArea;
    protected String _upperText = null;
    protected String _lowerText = null;

    public DoublePartDescriptionPanel() {
        this.init();
        this.refresh();
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setName("bothTextAreas");
        this.setMinimumSize(new Dimension(10, 15));
        this.setOpaque(false);
    }

    public void setUpperText(String upperText) {
        this._upperText = upperText != null ? upperText.trim() : null;
    }

    public void setLowerText(String lowerText) {
        this._lowerText = lowerText != null ? lowerText.trim() : null;
    }

    public void refresh() {
        int rows = 0;
        String text1 = "";
        String text2 = "";
        boolean showUpperText = false;
        if (this._upperText != null && this._upperText.length() > 0) {
            text1 = this._upperText;
            showUpperText = true;
            ++rows;
        }
        boolean showLowerText = false;
        if (this._lowerText != null && this._lowerText.length() > 0 && this._upperText != null && this._lowerText.compareToIgnoreCase(this._upperText) != 0) {
            text2 = this._lowerText;
            showLowerText = true;
            ++rows;
        }
        if (rows == 0) {
            showUpperText = true;
            text1 = " ";
        }
        this.removeAll();
        this._upperTextArea = null;
        this._lowerTextArea = null;
        if (showUpperText) {
            this._upperTextArea = this.newTextArea("upperTextArea", text1);
            this.add((Component)this._upperTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, rows == 1 ? 1.0 : 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showLowerText) {
            this._lowerTextArea = this.newTextArea("lowerTextArea", text2);
            this.add((Component)this._lowerTextArea, new GridBagConstraints(0, rows, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (rows > 1) {
                Border textborder = this._upperTextArea.getBorder();
                MatteBorder seperator = BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.darkGray);
                this._lowerTextArea.setBorder(BorderFactory.createCompoundBorder(seperator, textborder));
            }
        }
        this.validate();
    }

    protected JTextArea newTextArea(String name, String text) {
        JTextPane fontpane = new JTextPane();
        Font f = fontpane.getFont();
        JTextArea textArea = new JTextArea(text, 1, 0);
        textArea.setName(name);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setDisabledTextColor(SystemColor.textText);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMinimumSize(new Dimension(60, 24));
        textArea.setFont(f);
        textArea.setMargin(new Insets(1, 2, 1, 2));
        return textArea;
    }
}

