/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.Operation;
import com.sas.expressions.visuals.OperationList;
import com.sas.expressions.visuals.RB;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class DefaultOperationList
extends OperationList {
    public static final String RB_KEY = "DefaultOperationList.";
    static final String _defaultListSubkey = RB.getStringResource("DefaultOperationList.", "DefaultListSubKey.notrans");
    public static final String LIST_SQL = "SQL";
    public static final String LIST_MDX = "MDX";
    public static final String LIST_DATASTEP = "DATASTEP";
    transient String _listname = null;
    static final String ERROR_RESOURCES_NOT_AVAILABLE = RB.getStringResource("DefaultOperationList.", "ErrorResourcesNotAvailable.txt");
    static final String ERROR_RESOURCE_FILE_NOT_FOUND_MSG = RB.getStringResource("DefaultOperationList.", "ErrorResourceFileNotFound.fmt.txt");
    static final String ERROR_MISSING_RESOURCE_KEY_MSG = RB.getStringResource("DefaultOperationList.", "ErrorMissingResourceKey.fmt.txt");
    boolean m_UserLookupBundle = false;
    ResourceBundle m_LookupBundle = null;
    static String _bundlePath = DefaultOperationList.getResourceBundlePath(DefaultOperationList.class);
    static ResourceBundle _bundle = DefaultOperationList.getResourceBundle(DefaultOperationList.class);

    public DefaultOperationList(List operations) {
        super(operations);
    }

    public DefaultOperationList() {
        this.init(_defaultListSubkey, false, null);
    }

    public DefaultOperationList(String listname) {
        this.init(listname, false, null);
    }

    public DefaultOperationList(ResourceBundle lookupBundle) {
        this.init(_defaultListSubkey, true, lookupBundle);
    }

    public DefaultOperationList(String listname, ResourceBundle lookupBundle) {
        this.init(listname, true, lookupBundle);
    }

    void init(String listname, boolean userLookupBundle, ResourceBundle lookupBundle) {
        this.m_UserLookupBundle = userLookupBundle;
        this.m_LookupBundle = lookupBundle;
        List operations = this.buildList(listname);
        this.setOperations(operations);
    }

    protected List buildList(String listname) {
        this._listname = listname;
        ArrayList<Operation> operations = new ArrayList<Operation>();
        HashMap<String, String> operationKeys = new HashMap<String, String>();
        HashMap<String, String> operationArgTypes = new HashMap<String, String>();
        ResourceBundle bundle = this.getLookupResourceBundle();
        Enumeration<String> keysEnum = bundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            String item = keysEnum.nextElement();
            if (!(item instanceof String)) continue;
            String key = item;
            String subKey = null;
            subKey = this.getSubKey(key, "Operation.List." + listname + ".Item.", ".notrans");
            if (subKey != null) {
                operationKeys.put(subKey, this.getResourceString(key));
                continue;
            }
            subKey = this.getSubKey(key, "Operation.ArgumentType.", ".DisplayName.txt");
            if (subKey == null) continue;
            operationArgTypes.put(subKey, this.getResourceString(key));
        }
        TreeSet sortedKeys = new TreeSet(operationKeys.keySet());
        for (Object item : sortedKeys) {
            Object formatKey = operationKeys.get(item);
            if (!(formatKey instanceof String)) continue;
            String prefix = (String)formatKey;
            Operation operation = null;
            String name = prefix;
            String displayName = this.getResourceString(prefix + ".displayName.notrans");
            String symbol = this.getResourceRawString(prefix + ".symbol.txt");
            if (symbol != null) {
                String toolTip = this.getResourceRawString(prefix + ".toolTip.txt");
                String formatString = this.getResourceString(prefix + ".format.notrans");
                int i = 0;
                boolean done = false;
                ArrayList<String> argList = new ArrayList<String>();
                while (!done) {
                    String key = prefix + ".arg." + i + ".type.notrans";
                    String argType = this.getResourceRawString(key);
                    boolean bl = done = argType == null;
                    if (!done) {
                        String argDisplayName = (String)operationArgTypes.get(argType);
                        if (argDisplayName == null) {
                            argDisplayName = "<>";
                        }
                        argList.add(argDisplayName);
                    }
                    ++i;
                }
                operation = new Operation(name, displayName, symbol, toolTip, formatString, argList);
            }
            operations.add(operation);
        }
        return operations;
    }

    public ResourceBundle getLookupResourceBundle() {
        if (this.m_UserLookupBundle) {
            return this.m_LookupBundle;
        }
        return _bundle;
    }

    private static String getResourceBundlePath(Class source) {
        String strBundlePath = source.getName();
        return strBundlePath;
    }

    private static ResourceBundle getResourceBundle(Class source) {
        String strBundlePath = DefaultOperationList.getResourceBundlePath(source);
        Locale locale = Locale.getDefault();
        ResourceBundle returnValue = null;
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                return null;
            }
        }
        return returnValue;
    }

    public String getResourceString(String key) {
        String retValue = "";
        ResourceBundle lookupBundle = this.getLookupResourceBundle();
        if (lookupBundle == null) {
            retValue = this.m_UserLookupBundle ? ERROR_RESOURCES_NOT_AVAILABLE : MessageFormat.format(ERROR_RESOURCE_FILE_NOT_FOUND_MSG, _bundlePath);
        } else {
            try {
                retValue = lookupBundle.getString(key);
            }
            catch (Throwable t) {
                retValue = MessageFormat.format(ERROR_MISSING_RESOURCE_KEY_MSG, key);
            }
        }
        return retValue;
    }

    public String getResourceRawString(String key) {
        String retValue = null;
        ResourceBundle lookupBundle = this.getLookupResourceBundle();
        if (lookupBundle != null) {
            try {
                retValue = lookupBundle.getString(key);
            }
            catch (Throwable t) {
                retValue = null;
            }
        }
        return retValue;
    }

    public String getResourceMessageString(String key, Object[] args) {
        String pattern = this.getResourceString(key);
        return MessageFormat.format(pattern, args);
    }

    String getSubKey(String key, String prefix, String suffix) {
        if (key == null) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (!key.startsWith(prefix)) {
            return null;
        }
        if (suffix == null) {
            suffix = "";
        }
        if (!key.endsWith(suffix)) {
            return null;
        }
        return key.substring(prefix.length(), key.length() - suffix.length());
    }
}

