/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.FunctionFormat;
import com.sas.expressions.visuals.FunctionList;
import com.sas.expressions.visuals.FunctionNode;
import com.sas.expressions.visuals.FunctionNodeInterface;
import com.sas.expressions.visuals.FunctionTree;
import com.sas.expressions.visuals.FunctionTreeInterface;
import com.sas.expressions.visuals.RB;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class DefaultFunctionTree
extends FunctionTree
implements FunctionTreeInterface {
    public static final String RB_KEY = "DefaultFunctionTree.";
    public static final int LANGUAGE_CUSTOM = -1;
    public static final int LANGUAGE_SQL = 0;
    public static final int LANGUAGE_MDX = 1;
    public static final String PREFIX_SQL = "SQL.";
    public static final String PREFIX_MDX = "MDX.";
    int m_LanguageType = 0;
    String m_LanguagePrefix = "SQL.";
    String m_categoryTreeRootNodeDisplayName = RB.getStringResource("DefaultFunctionTree.", "CategoryTreeRootNode.DisplayName.txt");
    static final String ERROR_RESOURCES_NOT_AVAILABLE = RB.getStringResource("DefaultFunctionTree.", "ErrorResourcesNotAvailable.txt");
    static final String ERROR_RESOURCE_FILE_NOT_FOUND_MSG = RB.getStringResource("DefaultFunctionTree.", "ErrorResourceFileNotFound.fmt.txt");
    static final String ERROR_MISSING_RESOURCE_KEY_MSG = RB.getStringResource("DefaultFunctionTree.", "ErrorMissingResourceKey.fmt.txt");
    boolean m_UserLookupBundle = false;
    ResourceBundle m_LookupBundle = null;
    static String m_bundlePath = DefaultFunctionTree.getResourceBundlePath(DefaultFunctionTree.class);
    static ResourceBundle m_bundle = DefaultFunctionTree.getResourceBundle(DefaultFunctionTree.class);
    Map _cachedImageIcons = new HashMap();
    protected static Icon m_selectedCategoryIcon = null;
    protected static Icon m_unSelectedCategoryIcon = null;
    protected static Icon m_spacingIcon = null;

    public DefaultFunctionTree() {
        super(new DefaultMutableTreeNode());
        this.init(this.m_LanguageType, this.m_LanguagePrefix, false, null);
    }

    public DefaultFunctionTree(int iLangType) {
        super(new DefaultMutableTreeNode());
        this.init(iLangType, null, false, null);
    }

    public DefaultFunctionTree(String customPrefix) {
        super(new DefaultMutableTreeNode());
        this.init(-1, customPrefix, false, null);
    }

    public DefaultFunctionTree(int iLangType, ResourceBundle lookupBundle) {
        super(new DefaultMutableTreeNode());
        this.init(iLangType, null, true, lookupBundle);
    }

    public DefaultFunctionTree(String customPrefix, ResourceBundle lookupBundle) {
        super(new DefaultMutableTreeNode());
        this.init(-1, customPrefix, true, lookupBundle);
    }

    void init(int languageType, String languagePrefix, boolean userLookupBundle, ResourceBundle lookupBundle) {
        if (languagePrefix == null) {
            languagePrefix = PREFIX_SQL;
            if (languageType == 1) {
                languagePrefix = PREFIX_MDX;
            } else if (languageType == -1) {
                languagePrefix = "";
            }
        } else if (languagePrefix.length() > 0 && languagePrefix.lastIndexOf(".") != languagePrefix.length() - 1) {
            languagePrefix = languagePrefix + ".";
        }
        this.m_LanguageType = languageType;
        this.m_LanguagePrefix = languagePrefix;
        this.m_UserLookupBundle = userLookupBundle;
        this.m_LookupBundle = lookupBundle;
        TreeNode initRoot = this.buildRootNode();
        this.setRoot(initRoot);
    }

    protected TreeNode buildRootNode() {
        String catRootName = this.m_LanguagePrefix + "Root";
        String langSpecificCatRootKey = this.m_LanguagePrefix + "categoryTreeRootNode.DisplayName.txt";
        String langSpecificCatRootDisplayName = this.getResourceRawString(langSpecificCatRootKey);
        if (langSpecificCatRootDisplayName != null) {
            this.m_categoryTreeRootNodeDisplayName = langSpecificCatRootDisplayName;
        }
        FunctionNode rootNode = new FunctionNode(catRootName, this.m_categoryTreeRootNodeDisplayName);
        FunctionNode allNode = null;
        ArrayList<String> functionKeys = new ArrayList<String>();
        HashMap<String, String> argTypeNames = new HashMap<String, String>();
        HashMap<String, FunctionNode> categories = new HashMap<String, FunctionNode>();
        HashMap argumentLists = new HashMap();
        ResourceBundle bundle = this.getLookupResourceBundle();
        Enumeration<String> keysEnum = bundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            int argStart;
            String item = keysEnum.nextElement();
            if (!(item instanceof String)) continue;
            String key = item;
            String subKey = null;
            Object prefix = null;
            Object suffix = null;
            subKey = this.getSubKey(key, this.m_LanguagePrefix + "Function.Category.", ".DisplayName.txt");
            if (subKey != null) {
                FunctionNode node = new FunctionNode(this.m_LanguagePrefix + "Function.Category." + subKey, this.getResourceString(key));
                node.setFunctionList(new FunctionList());
                if (subKey.equalsIgnoreCase("ALL")) {
                    allNode = node;
                }
                categories.put(subKey, node);
                continue;
            }
            subKey = this.getSubKey(key, this.m_LanguagePrefix + "Function.ArgumentType.", ".DisplayName.txt");
            if (subKey != null) {
                argTypeNames.put(subKey, this.getResourceString(key));
                continue;
            }
            subKey = this.getSubKey(key, this.m_LanguagePrefix + "Function.Format.", ".DisplayName.txt");
            if (subKey != null) {
                functionKeys.add(subKey);
                continue;
            }
            subKey = this.getSubKey(key, this.m_LanguagePrefix + "Function.Format.", ".type.notrans");
            if (subKey == null || (argStart = subKey.lastIndexOf(".arg.")) < 0) continue;
            String argString = subKey.substring(argStart + 5);
            int argIndex = Integer.parseInt(argString);
            String trueSubKey = subKey.substring(0, argStart);
            ArrayList<String> args = (ArrayList<String>)argumentLists.get(trueSubKey);
            if (args == null) {
                args = new ArrayList<String>();
                argumentLists.put(trueSubKey, args);
            }
            while (argIndex >= args.size()) {
                args.add(null);
            }
            args.set(argIndex, this.getResourceString(key));
        }
        TreeSet catKeys = new TreeSet(categories.keySet());
        for (Object key : catKeys) {
            FunctionNode node = (FunctionNode)categories.get(key);
            rootNode.add(node);
        }
        TreeSet functKeys = new TreeSet(functionKeys);
        Iterator functsIter = functKeys.iterator();
        String prefix = this.m_LanguagePrefix + "Function.Format.";
        while (functsIter.hasNext()) {
            FunctionNode node;
            ArrayList args;
            Object item = functsIter.next();
            if (!(item instanceof String)) continue;
            String subKey = (String)item;
            String name = prefix + subKey;
            String displayName = this.getResourceString(name + ".DisplayName.txt");
            String description = this.getResourceRawString(name + ".Description.txt");
            String toolTip = this.getResourceRawString(name + ".ToolTip.txt");
            String fmtString = this.getResourceString(name + ".fmt.notrans");
            if (description == null) {
                description = displayName;
            }
            if ((args = (ArrayList)argumentLists.get(subKey)) == null) {
                args = new ArrayList();
                argumentLists.put(subKey, args);
            } else {
                for (int i = 0; i < args.size(); ++i) {
                    String argType = (String)args.get(i);
                    if (argType == null) continue;
                    args.set(i, argTypeNames.get(argType));
                }
            }
            FunctionFormat function = new FunctionFormat(name, displayName, description, toolTip, fmtString, args);
            String category = this.getResourceRawString(name + ".Category.notrans");
            if (category != null && (node = (FunctionNode)categories.get(category)) != null) {
                node.addFunctionToCategory(function);
            }
            if (allNode == null) continue;
            allNode.addFunctionToCategory(function);
        }
        return rootNode;
    }

    public ResourceBundle getLookupResourceBundle() {
        if (this.m_UserLookupBundle) {
            return this.m_LookupBundle;
        }
        return m_bundle;
    }

    private static String getResourceBundlePath(Class source) {
        String strBundlePath = source.getName();
        return strBundlePath;
    }

    private static ResourceBundle getResourceBundle(Class source) {
        String strBundlePath = DefaultFunctionTree.getResourceBundlePath(source);
        Locale locale = Locale.getDefault();
        ResourceBundle returnValue = null;
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                return null;
            }
        }
        return returnValue;
    }

    public String getResourceString(String key) {
        String retValue = "";
        ResourceBundle lookupBundle = this.getLookupResourceBundle();
        if (lookupBundle == null) {
            retValue = this.m_UserLookupBundle ? ERROR_RESOURCES_NOT_AVAILABLE : MessageFormat.format(ERROR_RESOURCE_FILE_NOT_FOUND_MSG, m_bundlePath);
        } else {
            try {
                retValue = lookupBundle.getString(key);
            }
            catch (Throwable t) {
                retValue = MessageFormat.format(ERROR_MISSING_RESOURCE_KEY_MSG, key);
            }
        }
        return retValue;
    }

    public String getResourceRawString(String key) {
        String retValue = null;
        ResourceBundle lookupBundle = this.getLookupResourceBundle();
        if (lookupBundle != null) {
            try {
                retValue = lookupBundle.getString(key);
            }
            catch (Throwable t) {
                retValue = null;
            }
        }
        return retValue;
    }

    public String getResourceMessageString(String key, Object[] args) {
        String pattern = this.getResourceString(key);
        return MessageFormat.format(pattern, args);
    }

    String getSubKey(String key, String prefix, String suffix) {
        if (key == null) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (!key.startsWith(prefix)) {
            return null;
        }
        if (suffix == null) {
            suffix = "";
        }
        if (!key.endsWith(suffix)) {
            return null;
        }
        return key.substring(prefix.length(), key.length() - suffix.length());
    }

    private Icon findIcon(String resourceKey) {
        if (resourceKey == null) {
            return null;
        }
        if (this._cachedImageIcons.containsKey(resourceKey)) {
            return (ImageIcon)this._cachedImageIcons.get(resourceKey);
        }
        String path = this.getResourceString("ImageLocation.notrans");
        String filename = this.getResourceString(resourceKey);
        String strIconPath = path + filename;
        URL url = null;
        ImageIcon returnValue = null;
        try {
            url = ClassLoader.getSystemResource(strIconPath);
            returnValue = new ImageIcon(url);
        }
        catch (Exception e) {
            returnValue = null;
        }
        this._cachedImageIcons.put(resourceKey, returnValue);
        return returnValue;
    }

    @Override
    public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
        InnerTreeCellRenderer itcr = new InnerTreeCellRenderer();
        DefaultTreeCellRenderer def = new DefaultTreeCellRenderer();
        try {
            m_selectedCategoryIcon = this.findIcon("DefaultFunctionTree.Category.Selected.image");
        }
        catch (Exception e) {
            m_selectedCategoryIcon = def.getOpenIcon();
        }
        try {
            m_unSelectedCategoryIcon = this.findIcon("DefaultFunctionTree.Category.image");
        }
        catch (Exception e) {
            m_unSelectedCategoryIcon = def.getClosedIcon();
        }
        try {
            m_spacingIcon = this.findIcon("DefaultFunctionTree.BlankSpacing.image");
        }
        catch (Exception e) {
            m_spacingIcon = null;
        }
        if (m_spacingIcon == null) {
            tree.setRowHeight(16);
        } else {
            tree.setRowHeight(Math.max(16, m_spacingIcon.getIconHeight() + 2));
        }
        return itcr;
    }

    class InnerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        InnerTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree.hasFocus() && tree.getSelectionCount() == 0 && row == 0) {
                hasFocus = true;
            }
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!(value instanceof FunctionNodeInterface)) {
                return this;
            }
            FunctionNodeInterface node = (FunctionNodeInterface)value;
            boolean setBold = false;
            String stringValue = node.getDisplayName();
            String tipText = node.getDescription();
            if (tipText != null && (tipText.trim().length() == 0 || tipText.equals(stringValue))) {
                tipText = null;
            }
            String key = node.getName();
            Icon icon = null;
            if (selected) {
                if (expanded) {
                    icon = DefaultFunctionTree.this.findIcon(key + ".Opened.Selected.image");
                }
                if (icon == null) {
                    icon = DefaultFunctionTree.this.findIcon(key + ".Selected.image");
                }
            } else {
                if (expanded) {
                    icon = DefaultFunctionTree.this.findIcon(key + ".Opened.image");
                }
                if (icon == null) {
                    icon = DefaultFunctionTree.this.findIcon(key + ".image");
                }
            }
            if (icon == null) {
                icon = selected ? m_selectedCategoryIcon : m_unSelectedCategoryIcon;
            }
            Font font = this.getFont();
            if (setBold && font != null) {
                font = new Font(font.getName(), 1, font.getSize());
            }
            this.setText(stringValue);
            this.setToolTipText(tipText);
            this.setIcon(icon);
            this.setFont(font);
            if (selected) {
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setForeground(SystemColor.textText);
            }
            this.setEnabled(true);
            this.selected = selected;
            this.setComponentOrientation(tree.getComponentOrientation());
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

