/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.servers;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerBase;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.web.data.servers.LogicalServerData;
import com.sas.svcs.web.data.servers.LogicalServers;
import com.sas.svcs.web.data.servers.ServerBaseData;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="servercontext")
public class ServerContextData
extends ServerBaseData {
    private ServerContext serverContext;

    public ServerContextData() {
        this(new ServerContext());
    }

    public ServerContextData(ServerContext serverContext) {
        super((ServerBase)serverContext);
        this.serverContext = serverContext;
    }

    public ServerContextData(ServerContext serverContext, boolean doFull) {
        super((ServerBase)serverContext, doFull);
        this.serverContext = serverContext;
    }

    @XmlElement
    public LogicalServers getLogicalServers() {
        ArrayList lsList;
        if (!this.doFull) {
            return null;
        }
        LogicalServers result = null;
        ReferenceList lsRef = this.serverContext.getLogicalServers();
        if (lsRef != null && (lsList = (ArrayList)lsRef.getTargetList()) != null && lsList.size() > 0) {
            ArrayList<LogicalServerData> lsDataList = new ArrayList<LogicalServerData>();
            for (LogicalServer logicalServer : lsList) {
                lsDataList.add(new LogicalServerData(logicalServer, this.doFull));
            }
            result = new LogicalServers(lsDataList);
        }
        return result;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        ReferenceList lsRef;
        List<Link> result = this.getLinkList();
        if (!this.doFull && this.serverContext != null && (lsRef = this.serverContext.getLogicalServers()) != null && lsRef.getTargetList() != null && ((ArrayList)lsRef.getTargetList()).size() > 0) {
            for (LogicalServer nextLogicalServer : (ArrayList)lsRef.getTargetList()) {
                Link lsLink = new Link("GET", "logicalServer", "/content/94/" + ContentRESTUtils.getIdForLink((String)nextLogicalServer.getId()));
                result.add(lsLink);
            }
        }
        return result;
    }

    public ServerContext toServerContext() {
        return this.serverContext;
    }
}

