/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.servers;

import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.resource.platform.machine.client.Machine;
import com.sas.svcs.resource.platform.serverdata.client.ServerComponent;
import com.sas.svcs.web.data.content.ContentObjectAttrData;
import com.sas.svcs.web.data.servers.ServerComponentData;
import com.sas.svcs.web.data.servers.ServerComponents;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="machine")
public class MachineData
extends ContentObjectAttrData {
    private static final String MACHINE_DATA_VERSION = "1";
    Machine machine;

    public MachineData() {
        this(new Machine());
    }

    public MachineData(Machine machine) {
        super((ContentComponent)machine);
        this.machine = machine;
    }

    @XmlElement
    public Long getMemorySize() {
        return this.machine.getMemorySize();
    }

    public ServerComponents getServers() {
        ServerComponents result = null;
        ReferenceList scRef = this.machine.getServerData();
        if (scRef != null && scRef.getTargetList() != null) {
            ArrayList<ServerComponentData> scDataList = new ArrayList<ServerComponentData>();
            ArrayList scList = (ArrayList)scRef.getTargetList();
            for (ServerComponent sc : scList) {
                scDataList.add(new ServerComponentData(sc));
            }
            result = new ServerComponents(scDataList);
        }
        return result;
    }

    public final String getVersion() {
        return MACHINE_DATA_VERSION;
    }
}

