/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.relationships;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.relationship.client.ExternalResource;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.Resource;
import com.sas.svcs.content.relationship.client.ResourceAttribute;
import com.sas.svcs.web.data.relationships.ResourceAttributeData;
import com.sas.svcs.web.data.relationships.ResourceAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resource")
public class ResourceData {
    private static String _version = "1";
    protected String label;
    protected Integer resourceId;
    protected String id;
    protected long objectType;
    protected String externalId;
    protected Date analysisDate;
    protected ResourceAttributes resourceAttributes;

    public ResourceData() {
    }

    public ResourceData(Resource r) {
        this.label = r.getLabel();
        this.resourceId = r.getResourceId();
        this.id = r.getId();
        this.objectType = r.getObjectType();
        this.analysisDate = r.getAnalysisDate();
        if (r instanceof ExternalResource) {
            this.externalId = ((ExternalResource)r).getExternalId();
        }
        this.resourceAttributes = new ResourceAttributes(r.getAttributeMap());
    }

    public String getLabel() {
        return this.label;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public String getId() {
        return this.id;
    }

    public long getObjectType() {
        return this.objectType;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @XmlElement(name="date")
    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    @XmlAttribute
    public String getVersion() {
        return _version;
    }

    @JsonIgnore
    public void setVersion(String version) {
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    public void setAnalysisDate(Date date) {
        this.analysisDate = date;
    }

    @XmlElement(name="properties")
    public ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setResourceAttributes(ResourceAttributes resourceAttributes) throws RelationshipException {
        if (resourceAttributes != null) {
            this.resourceAttributes = resourceAttributes;
        }
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(new Link("GET", "self", "/relsvc/" + this.objectType + "/" + ContentRESTUtils.getIdForLink((String)this.id)));
        links.add(new Link("GET", "get-relationships", "/relsvc/" + this.objectType + "/" + ContentRESTUtils.getIdForLink((String)this.id) + "/relationships"));
        return links;
    }

    public Resource toResource() {
        Resource r;
        if (null != this.externalId && !this.externalId.isEmpty()) {
            r = new ExternalResource(this.label, this.objectType, this.externalId);
            r.setId(this.id);
        } else {
            r = new Resource(this.label, this.objectType, this.id);
        }
        r.setAnalysisDate(this.analysisDate);
        if (null != this.resourceAttributes) {
            List<ResourceAttributeData> attrsL = this.resourceAttributes.getResourceAttributes();
            ArrayList<ResourceAttribute> attrs = new ArrayList<ResourceAttribute>();
            for (ResourceAttributeData attrData : attrsL) {
                attrs.add(attrData.toResourceAttribute());
            }
            r.setAttributeMap(attrs);
        } else {
            r.setAttributeMap(new ArrayList());
        }
        return r;
    }
}

