/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.relationships;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sas.svcs.content.relationship.client.Relationship;
import com.sas.svcs.content.relationship.client.RelationshipModel;
import com.sas.svcs.content.relationship.client.Resource;
import com.sas.svcs.web.data.relationships.RelationshipData;
import com.sas.svcs.web.data.relationships.Relationships;
import com.sas.svcs.web.data.relationships.ResourceData;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="", propOrder={"resource", "relationshipNodes"})
@XmlRootElement(name="relationshipModel")
public class RelationshipModelData {
    protected RelationshipModel rm;
    protected Relationships relationshipNodes;
    protected ResourceData resource;
    private static String _version = "1";

    public RelationshipModelData() {
        this.rm = new RelationshipModel();
    }

    public RelationshipModelData(RelationshipModel relationshipModel) {
        this.rm = relationshipModel;
        this.relationshipNodes = new Relationships(relationshipModel.getRelationships());
    }

    @XmlElement(name="resource", required=true)
    public ResourceData getResource() {
        return new ResourceData(this.rm.getResource());
    }

    @XmlElement(name="relationships")
    public Relationships getRelationshipNodes() {
        return this.relationshipNodes;
    }

    @XmlAttribute
    public String getVersion() {
        return _version;
    }

    @JsonIgnore
    public void setVersion(String version) {
    }

    public void setRelationshipNodes(Relationships relationshipNodes) {
        if (relationshipNodes != null) {
            List<RelationshipData> rnDataL = relationshipNodes.getRelationshipNodes();
            for (RelationshipData rnData : rnDataL) {
                this.rm.addRelationship(rnData.toRelationshipNode());
            }
            this.relationshipNodes = relationshipNodes;
        }
    }

    @JsonIgnore
    public void setResource(Resource resource) {
        this.rm.setResource(resource);
        this.resource = new ResourceData(resource);
    }

    @JsonProperty(value="resource")
    public void setResource(ResourceData resourceData) {
        this.rm.setResource(resourceData.toResource());
        this.resource = resourceData;
    }

    public void addRelationshipNode(Relationship relationship) {
        this.rm.addRelationship(relationship);
    }

    public RelationshipModel toRelationshipModel() {
        return this.rm;
    }
}

