/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.document;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.document.client.Document;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.web.data.content.ContentNodeAttrData;
import com.sas.svcs.web.data.document.DocumentAttributeData;
import com.sas.svcs.web.data.document.DocumentAttributeType;
import com.sas.svcs.web.data.document.DocumentAttributes;
import com.sas.svcs.web.data.document.DocumentQnameData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

@XmlRootElement(name="document")
public class DocumentData
extends ContentNodeAttrData {
    private static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault());
    private static final String DATA_VERSION = "1";
    private Document document;
    private List<Link> contentLinks = new ArrayList<Link>();

    public DocumentData() {
        this(new Document());
    }

    public DocumentData(Document document) {
        super((ContentNode)document);
        this.document = document;
    }

    @XmlAttribute
    public String getAuthor() {
        return this.document.getAuthor();
    }

    public void setAuthor(String author) {
        this.document.setAuthor(author);
    }

    @XmlAttribute
    public String getDocumentType() {
        return this.document.getDocumentType();
    }

    public void setDocumentType(String documentType) {
        this.document.setDocumentType(documentType);
    }

    @XmlAttribute
    public String getContentType() {
        return this.document.getContentType();
    }

    public void setContentType(String contentType) {
        this.document.setContentType(contentType);
    }

    @XmlAttribute
    public String getContentVersion() {
        return this.document.getVersion();
    }

    @XmlAttribute
    public String getVersion() {
        return DATA_VERSION;
    }

    @XmlAttribute
    public String getEncoding() {
        return this.document.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.document.setEncoding(encoding);
    }

    @XmlElement
    public DocumentAttributes getAttributes() {
        ArrayList<DocumentAttributeData> attributeList = new ArrayList<DocumentAttributeData>();
        Map attrMap = this.document.getAttributes();
        if (attrMap == null || attrMap.size() == 0) {
            return null;
        }
        for (Map.Entry nextEntry : attrMap.entrySet()) {
            attributeList.add(this.makeAttributeData((QName)nextEntry.getKey(), nextEntry.getValue()));
        }
        return new DocumentAttributes(attributeList);
    }

    private DocumentAttributeData makeAttributeData(QName name, Object value) {
        DocumentAttributeType type = DocumentAttributeType.STRING;
        String stringValue = "";
        if (value instanceof Calendar) {
            type = DocumentAttributeType.DATE;
            stringValue = ISO8601FORMAT.format(((Calendar)value).getTime());
        } else if (value instanceof Boolean) {
            type = DocumentAttributeType.BOOLEAN;
            stringValue = value.toString();
        } else if (value instanceof Long) {
            type = DocumentAttributeType.LONG;
            stringValue = value.toString();
        } else if (value instanceof Double) {
            type = DocumentAttributeType.DOUBLE;
            stringValue = value.toString();
        } else {
            type = DocumentAttributeType.STRING;
            stringValue = value.toString();
        }
        return new DocumentAttributeData(new DocumentQnameData(name), type, stringValue);
    }

    public void setAttributes(DocumentAttributes attributes) {
        HashMap<QName, Object> attrMap = new HashMap<QName, Object>();
        for (DocumentAttributeData nextAttribute : attributes.getAttributes()) {
            QName qname = nextAttribute.getQname().toQName();
            Object object = this.makeValue(nextAttribute.type, nextAttribute.getValue());
            attrMap.put(qname, object);
        }
        this.document.setAttributes(attrMap);
    }

    private Object makeValue(DocumentAttributeType type, String stringValue) {
        Object result = null;
        if (type == DocumentAttributeType.STRING) {
            result = stringValue;
        } else if (type == DocumentAttributeType.BOOLEAN) {
            result = Boolean.valueOf(stringValue);
        } else if (type == DocumentAttributeType.DATE) {
            try {
                result = new GregorianCalendar();
                ((GregorianCalendar)result).setTime(ISO8601FORMAT.parse(stringValue));
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        } else if (type == DocumentAttributeType.DOUBLE) {
            result = Double.valueOf(stringValue);
        } else if (type == DocumentAttributeType.LONG) {
            result = Long.valueOf(stringValue);
        }
        return result;
    }

    public void addContentLink(Link contentLink) {
        this.contentLinks.add(contentLink);
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        ArrayList<Link> linkList = new ArrayList<Link>();
        linkList.add(new Link("GET", "self", "/content/documents/" + this.document.getId()));
        for (Link contentLink : this.contentLinks) {
            linkList.add(contentLink);
        }
        return linkList;
    }

    public Document toDocument() {
        return this.document;
    }
}

